/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block;

import de.bluecolored.bluemap.core.world.BlockEntity;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.block.BlockAccess;
import org.jetbrains.annotations.Nullable;

public class Block
implements BlockAccess {
    private final World world;
    private int x;
    private int y;
    private int z;
    @Nullable
    private Chunk chunk;
    @Nullable
    private BlockState blockState;
    private final LightData lightData = new LightData(-1, -1);
    @Nullable
    private Biome biome;
    private boolean isBlockEntitySet;
    @Nullable
    private BlockEntity blockEntity;

    public Block(World world, int x, int y, int z) {
        this.world = world;
        this.set(x, y, z);
    }

    @Override
    public void set(int x, int y, int z) {
        if (this.x == x && this.z == z) {
            if (this.y == y) {
                return;
            }
        } else {
            this.chunk = null;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockState = null;
        this.lightData.set(-1, -1);
        this.biome = null;
        this.isBlockEntitySet = false;
        this.blockEntity = null;
    }

    @Override
    public BlockAccess copy() {
        return new Block(this.world, this.x, this.y, this.z);
    }

    public Chunk getChunk() {
        if (this.chunk == null) {
            this.chunk = this.world.getChunkAtBlock(this.x, this.z);
        }
        return this.chunk;
    }

    @Override
    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.getChunk().getBlockState(this.x, this.y, this.z);
        }
        return this.blockState;
    }

    @Override
    public LightData getLightData() {
        if (this.lightData.getSkyLight() < 0) {
            this.getChunk().getLightData(this.x, this.y, this.z, this.lightData);
        }
        return this.lightData;
    }

    @Override
    public Biome getBiome() {
        if (this.biome == null) {
            this.biome = this.getChunk().getBiome(this.x, this.y, this.z);
        }
        return this.biome;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity() {
        if (!this.isBlockEntitySet) {
            this.blockEntity = this.getChunk().getBlockEntity(this.x, this.y, this.z);
            this.isBlockEntitySet = true;
        }
        return this.blockEntity;
    }

    @Override
    public boolean hasOceanFloorY() {
        return this.getChunk().hasOceanFloorHeights();
    }

    @Override
    public int getOceanFloorY() {
        return this.getChunk().getOceanFloorY(this.x, this.z);
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }
}

