/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block;

import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.block.BlockAccess;
import de.bluecolored.bluemap.core.world.block.ExtendedBlock;

public class BlockNeighborhood
extends ExtendedBlock {
    private static final int DIAMETER = 8;
    private static final int DIAMETER_MASK = 7;
    private static final int DIAMETER_SQUARED = 64;
    private final ExtendedBlock[] neighborhood = new ExtendedBlock[512];
    private int thisIndex = -1;

    public BlockNeighborhood(BlockAccess blockAccess, ResourcePack resourcePack, RenderSettings renderSettings, DimensionType dimensionType) {
        super(blockAccess, resourcePack, renderSettings, dimensionType);
    }

    @Override
    public void set(int x, int y, int z) {
        int i = this.index(x, y, z);
        if (i == this.thisIndex()) {
            return;
        }
        if (this.neighborhood[i] == null) {
            this.neighborhood[i] = this.copy();
        }
        this.neighborhood[i].set(x, y, z);
        this.copyFrom(this.neighborhood[i]);
        this.thisIndex = i;
    }

    public ExtendedBlock getNeighborBlock(int dx, int dy, int dz) {
        return this.getBlock(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
    }

    private ExtendedBlock getBlock(int x, int y, int z) {
        int i = this.index(x, y, z);
        if (i == this.thisIndex()) {
            return this;
        }
        if (this.neighborhood[i] == null) {
            this.neighborhood[i] = this.copy();
        }
        this.neighborhood[i].set(x, y, z);
        return this.neighborhood[i];
    }

    private int thisIndex() {
        if (this.thisIndex == -1) {
            this.thisIndex = this.index(this.getX(), this.getY(), this.getZ());
        }
        return this.thisIndex;
    }

    private int index(int x, int y, int z) {
        return (x & 7) * 64 + (y & 7) * 8 + (z & 7);
    }
}

