/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.Vector2iCache;
import de.bluecolored.bluemap.core.util.WatchService;
import de.bluecolored.bluemap.core.world.ChunkConsumer;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.mca.ChunkLoader;
import de.bluecolored.bluemap.core.world.mca.MCAWorldRegionWatchService;
import de.bluecolored.bluemap.core.world.mca.region.RegionType;
import de.bluecolored.shadow.caffeine.cache.Caffeine;
import de.bluecolored.shadow.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ChunkGrid<T> {
    private static final Grid CHUNK_GRID = new Grid(16);
    private static final Grid REGION_GRID = new Grid(32).multiply(CHUNK_GRID);
    private static final Vector2iCache VECTOR_2_I_CACHE = new Vector2iCache();
    private final ChunkLoader<T> chunkLoader;
    private final Path regionFolder;
    private final LoadingCache<Vector2i, Region<T>> regionCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).softValues().maximumSize(32L).expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.MINUTES).build(this::loadRegion);
    private final LoadingCache<Vector2i, T> chunkCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).softValues().maximumSize(10240L).expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.MINUTES).build(this::loadChunk);

    public Grid getChunkGrid() {
        return CHUNK_GRID;
    }

    public Grid getRegionGrid() {
        return REGION_GRID;
    }

    public T getChunk(int x, int z) {
        return this.getChunk(VECTOR_2_I_CACHE.get(x, z));
    }

    private T getChunk(Vector2i pos) {
        return this.chunkCache.get(pos);
    }

    public Region<T> getRegion(int x, int z) {
        return this.getRegion(VECTOR_2_I_CACHE.get(x, z));
    }

    private Region<T> getRegion(Vector2i pos) {
        return this.regionCache.get(pos);
    }

    public void preloadRegionChunks(int x, int z, final Predicate<Vector2i> chunkFilter) {
        try {
            this.getRegion(x, z).iterateAllChunks(new ChunkConsumer<T>(){

                @Override
                public boolean filter(int chunkX, int chunkZ, int lastModified) {
                    Vector2i chunkPos = VECTOR_2_I_CACHE.get(chunkX, chunkZ);
                    return chunkFilter.test(chunkPos);
                }

                @Override
                public void accept(int chunkX, int chunkZ, T chunk) {
                    Vector2i chunkPos = VECTOR_2_I_CACHE.get(chunkX, chunkZ);
                    ChunkGrid.this.chunkCache.put(chunkPos, chunk);
                }
            });
        }
        catch (IOException ex) {
            Logger.global.logDebug("Unexpected exception trying to load preload region ('%s' -> x:%d, z:%d): %s".formatted(this.regionFolder, x, z, ex));
        }
    }

    public Collection<Vector2i> listRegions() {
        List<Vector2i> list;
        block9: {
            if (!Files.exists(this.regionFolder, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.list(this.regionFolder);
            try {
                list = stream.map(file -> {
                    try {
                        if (Files.size(file) <= 0L) {
                            return null;
                        }
                        return RegionType.regionForFileName(file.getFileName().toString());
                    }
                    catch (IOException ex) {
                        Logger.global.logError("Failed to read region-file: " + String.valueOf(file), ex);
                        return null;
                    }
                }).filter(Objects::nonNull).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    Logger.global.logError("Failed to list regions from: '%s'".formatted(this.regionFolder), ex);
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    public WatchService<Vector2i> createRegionWatchService() throws IOException {
        return new MCAWorldRegionWatchService(this.regionFolder);
    }

    public void invalidateChunkCache() {
        this.regionCache.invalidateAll();
        this.chunkCache.invalidateAll();
    }

    public void invalidateChunkCache(int x, int z) {
        this.regionCache.invalidate(VECTOR_2_I_CACHE.get(x >> 5, z >> 5));
        this.chunkCache.invalidate(VECTOR_2_I_CACHE.get(x, z));
    }

    private Region<T> loadRegion(Vector2i regionPos) {
        return this.loadRegion(regionPos.getX(), regionPos.getY());
    }

    private Region<T> loadRegion(int x, int z) {
        return RegionType.loadRegion(this.chunkLoader, this.regionFolder, x, z);
    }

    private T loadChunk(Vector2i chunkPos) {
        return this.loadChunk(chunkPos.getX(), chunkPos.getY());
    }

    private T loadChunk(int x, int z) {
        int tries = 3;
        int tryInterval = 1000;
        Exception loadException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.getRegion(x >> 5, z >> 5).loadChunk(x, z);
            }
            catch (IOException | RuntimeException e) {
                if (loadException != null && loadException != e) {
                    e.addSuppressed(loadException);
                }
                loadException = e;
                if (i + 1 >= 3) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        Logger.global.logDebug("Unexpected exception trying to load chunk ('%s' -> x:%d, z:%d): %s".formatted(this.regionFolder, x, z, loadException));
        return this.chunkLoader.erroredChunk();
    }

    public ChunkGrid(ChunkLoader<T> chunkLoader, Path regionFolder) {
        this.chunkLoader = chunkLoader;
        this.regionFolder = regionFolder;
    }
}

