/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.command.suggestion.SuggestionProviders;
import org.popcraft.chunky.event.task.GenerationTaskFinishEvent;
import org.popcraft.chunky.event.task.GenerationTaskUpdateEvent;
import org.popcraft.chunky.listeners.bossbar.BossBarTaskFinishListener;
import org.popcraft.chunky.listeners.bossbar.BossBarTaskUpdateListener;
import org.popcraft.chunky.platform.NeoForgePlayer;
import org.popcraft.chunky.platform.NeoForgeSender;
import org.popcraft.chunky.platform.NeoForgeServer;
import org.popcraft.chunky.platform.impl.GsonConfig;

@Mod(value="chunky")
public class ChunkyNeoForge {
    public static final String MOD_ID = "chunky";
    private Chunky chunky;
    private final Map<ResourceLocation, ServerBossEvent> bossBars = new ConcurrentHashMap<ResourceLocation, ServerBossEvent>();

    public ChunkyNeoForge() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("chunky/config.json");
        this.chunky = new Chunky(new NeoForgeServer(this, server), new GsonConfig(configPath));
        if (this.chunky.getConfig().getContinueOnRestart()) {
            this.chunky.getCommands().get("continue").execute(this.chunky.getServer().getConsole(), CommandArguments.empty());
        }
        this.chunky.getEventBus().subscribe(GenerationTaskUpdateEvent.class, new BossBarTaskUpdateListener(this.bossBars));
        this.chunky.getEventBus().subscribe(GenerationTaskFinishEvent.class, new BossBarTaskFinishListener(this.bossBars));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)MOD_ID).requires(serverCommandSource -> {
            MinecraftServer server = serverCommandSource.getServer();
            if (server != null && server.isSingleplayer()) {
                return true;
            }
            return serverCommandSource.hasPermission(2);
        })).executes(context -> {
            NeoForgeSender sender;
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                sender = new NeoForgePlayer(player);
            } else {
                sender = new NeoForgeSender((CommandSourceStack)context.getSource());
            }
            Map<String, ChunkyCommand> commands = this.chunky.getCommands();
            String input = context.getInput().substring(((ParsedCommandNode)context.getLastChild().getNodes().get(0)).getRange().getStart());
            String[] tokens = input.split(" ");
            String subCommand = tokens.length > 1 && commands.containsKey(tokens[1]) ? tokens[1] : "help";
            CommandArguments arguments = tokens.length > 2 ? CommandArguments.of(Arrays.copyOfRange(tokens, 2, tokens.length)) : CommandArguments.empty();
            commands.get(subCommand).execute(sender, arguments);
            return 1;
        });
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"cancel"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"center"), Commands.argument((String)"x", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"z", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"confirm")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"continue"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"corners"), Commands.argument((String)"x1", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"z1", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"x2", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"z2", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"help"), Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"pattern"), Commands.argument((String)"pattern", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.PATTERNS), Commands.argument((String)"value", (ArgumentType)StringArgumentType.string())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"pause"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"progress")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"quiet"), Commands.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"radius"), Commands.argument((String)"radius", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radius", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"reload"), Commands.argument((String)"type", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"selection")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"shape"), Commands.argument((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES)});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"silent")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"spawn")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"start"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension()), Commands.argument((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), Commands.argument((String)"centerX", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"centerZ", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radiusX", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radiusZ", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"trim"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension()), Commands.argument((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), Commands.argument((String)"centerX", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"centerZ", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radiusX", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radiusZ", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"trimMode", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.TRIM_MODES), Commands.argument((String)"inhabited", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"worldborder")});
        this.registerArguments(command, new ArgumentBuilder[]{Commands.literal((String)"world"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension())});
        LiteralArgumentBuilder borderCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"border").requires(serverCommandSource -> this.chunky != null && this.chunky.getCommands().containsKey("border"))).executes(command.getCommand());
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"add"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension()), Commands.argument((String)"shape", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.SHAPES), Commands.argument((String)"centerX", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"centerZ", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radiusX", (ArgumentType)StringArgumentType.word()), Commands.argument((String)"radiusZ", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"bypass"), Commands.argument((String)"player", (ArgumentType)EntityArgument.player())});
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"help")});
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"list")});
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"load"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension())});
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"remove"), Commands.argument((String)"world", (ArgumentType)DimensionArgument.dimension())});
        this.registerArguments(borderCommand, new ArgumentBuilder[]{Commands.literal((String)"wrap"), Commands.argument((String)"wrap", (ArgumentType)StringArgumentType.word())});
        this.registerArguments(command, new ArgumentBuilder[]{borderCommand});
        event.getDispatcher().register(command);
    }

    @SafeVarargs
    private <S> void registerArguments(LiteralArgumentBuilder<S> command, ArgumentBuilder<S, ?> ... arguments) {
        for (int i = arguments.length - 1; i > 0; --i) {
            arguments[i - 1].then(arguments[i].executes(command.getCommand()));
        }
        command.then(arguments[0].executes(command.getCommand()));
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        if (this.chunky != null) {
            this.chunky.disable();
        }
    }

    public Chunky getChunky() {
        return this.chunky;
    }
}

