/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.popcraft.chunky.util.ChunkMath;

public class RegionCache {
    private final Map<String, WorldState> cache = new ConcurrentHashMap<String, WorldState>();

    public WorldState getWorld(String world) {
        return this.cache.computeIfAbsent(world, x -> new WorldState());
    }

    public void clear(String world) {
        this.cache.remove(world);
    }

    public static final class WorldState {
        private final Map<Long, BitSet> regions = new ConcurrentHashMap<Long, BitSet>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setGenerated(int x, int z) {
            int regionX = x >> 5;
            int regionZ = z >> 5;
            long regionKey = ChunkMath.pack(regionX, regionZ);
            BitSet region = this.regions.computeIfAbsent(regionKey, v -> new BitSet());
            int chunkIndex = ChunkMath.regionIndex(x, z);
            BitSet bitSet = region;
            synchronized (bitSet) {
                region.set(chunkIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isGenerated(int x, int z) {
            int regionX = x >> 5;
            int regionZ = z >> 5;
            long regionKey = ChunkMath.pack(regionX, regionZ);
            if (!this.regions.containsKey(regionKey)) {
                return false;
            }
            BitSet region = this.regions.get(regionKey);
            int chunkIndex = ChunkMath.regionIndex(x, z);
            BitSet bitSet = region;
            synchronized (bitSet) {
                return region.get(chunkIndex);
            }
        }
    }
}

