/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources;

import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockTypeResTransformer<T extends BlockType> {
    private final ResourceManager manager;
    private final String modId;
    private final List<TextModification<T>> textModifiers = new ArrayList<TextModification<T>>();
    private TextModification<T> idModifiers = (s, id, w) -> s;

    private BlockTypeResTransformer(String modId, ResourceManager manager) {
        this.manager = manager;
        this.modId = modId;
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> create(String modId, ResourceManager manager) {
        return new BlockTypeResTransformer<T>(modId, manager);
    }

    public static BlockTypeResTransformer<WoodType> wood(String modId, ResourceManager manager) {
        return new BlockTypeResTransformer<WoodType>(modId, manager);
    }

    public static BlockTypeResTransformer<LeavesType> leaves(String modId, ResourceManager manager) {
        return new BlockTypeResTransformer<LeavesType>(modId, manager);
    }

    public BlockTypeResTransformer<T> andThen(BlockTypeResTransformer<T> other) {
        this.textModifiers.addAll(other.textModifiers);
        this.idModifiers = other.idModifiers;
        return this;
    }

    public BlockTypeResTransformer<T> setIDModifier(TextModification<T> modifier) {
        this.idModifiers = modifier;
        return this;
    }

    public BlockTypeResTransformer<T> IDReplaceType(String oldTypeName) {
        return this.setIDModifier((s, id, w) -> BlockTypeResTransformer.replaceTypeNoNamespace(s, w, id, oldTypeName));
    }

    public BlockTypeResTransformer<T> IDReplaceBlock(String blockName) {
        return this.setIDModifier((s, id, w) -> s.replace(blockName, id.getPath()));
    }

    public BlockTypeResTransformer<T> addModifier(TextModification<T> modifier) {
        this.textModifiers.add(modifier);
        return this;
    }

    public BlockTypeResTransformer<T> replaceSimpleType(String oldTypeName) {
        return this.addModifier((s, id, w) -> BlockTypeResTransformer.replaceType(s, w, id, oldTypeName, this.modId));
    }

    public BlockTypeResTransformer<T> replaceGenericType(String oldTypeName, String entryClass) {
        this.addModifier((s, id, w) -> BlockTypeResTransformer.replaceFullGenericType(s, w, id, oldTypeName, this.modId, entryClass));
        return this;
    }

    public BlockTypeResTransformer<T> replaceBlockType(String oldTypeName) {
        this.addModifier((s, id, w) -> BlockTypeResTransformer.replaceFullGenericType(s, w, id, oldTypeName, this.modId, "block"));
        return this;
    }

    public BlockTypeResTransformer<T> replaceItemType(String oldTypeName) {
        this.addModifier((s, id, w) -> BlockTypeResTransformer.replaceFullGenericType(s, w, id, oldTypeName, this.modId, "item"));
        return this;
    }

    public BlockTypeResTransformer<T> replaceString(String from, String to) {
        return this.addModifier((s, id, w) -> s.replace(from, to));
    }

    @Nullable
    private ItemLike wfl(T t, String s) {
        LeavesType l;
        if (t instanceof LeavesType && (l = (LeavesType)t).getWoodType() != null) {
            ItemLike il;
            Object c = l.getWoodType().getChild(s);
            return c instanceof ItemLike ? (il = (ItemLike)c) : null;
        }
        return null;
    }

    public BlockTypeResTransformer<T> replaceWithTextureFromChild(String target, String textureFromChild) {
        return this.replaceWithTextureFromChild(target, textureFromChild, (String s) -> true);
    }

    public BlockTypeResTransformer<T> replaceWithTextureFromChild(String target, String textureFromChild, Predicate<String> texturePredicate) {
        return this.replaceWithTextureFromChild(target, (T w) -> (ItemLike)w.getChild(textureFromChild), texturePredicate);
    }

    public BlockTypeResTransformer<T> replaceWithTextureFromChild(String target, Function<T, ItemLike> childProvider, Predicate<String> texturePredicate) {
        return this.addModifier((s, id, w) -> {
            String r = s;
            if (!s.matches("\\{\\s*\"parent\":\\s*\".*\"\\s*\\}")) {
                try {
                    ItemLike woodObject = (ItemLike)childProvider.apply(w);
                    ResourceLocation newTexture = null;
                    if (woodObject instanceof Block) {
                        Block b = (Block)woodObject;
                        newTexture = RPUtils.findFirstBlockTextureLocation(this.manager, b, texturePredicate);
                    } else if (woodObject instanceof Item) {
                        Item i = (Item)woodObject;
                        newTexture = RPUtils.findFirstItemTextureLocation(this.manager, i);
                    }
                    if (newTexture != null) {
                        r = r.replace("\"" + target + "\"", "\"" + String.valueOf(newTexture) + "\"");
                        r = s.replace("\"block/", "\"minecraft:block/");
                        r = r.replace("\"" + target + "\"", "\"" + String.valueOf(newTexture) + "\"");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return r;
        });
    }

    public StaticResource transform(StaticResource resource, ResourceLocation blockId, T type) {
        String newText = new String(resource.data, StandardCharsets.UTF_8);
        for (TextModification<T> m : this.textModifiers) {
            newText = m.apply(newText, blockId, type);
        }
        ResourceLocation oldPath = resource.location;
        String id = this.idModifiers.apply(oldPath.getPath(), blockId, type);
        ResourceLocation newLocation = blockId.withPath(id);
        return StaticResource.create(newText.getBytes(), newLocation);
    }

    public static String replaceTypeNoNamespace(String text, BlockType blockType, ResourceLocation blockId, String oldTypeName) {
        return BlockTypeResTransformer.replaceFullGenericType(text, blockType, blockId, oldTypeName, null, 1);
    }

    public static String replaceType(String text, BlockType blockType, ResourceLocation blockId, String oldTypeName, String oldNamespace) {
        return BlockTypeResTransformer.replaceFullGenericType(text, blockType, blockId, oldTypeName, oldNamespace, 1);
    }

    public static String replaceFullGenericType(String text, BlockType newBlockType, ResourceLocation newBlockId, String oldTypeName, @Nullable String oldTypeNamespace, int folderDepth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < folderDepth; ++i) {
            if (i != 0) {
                sb.append("\\/");
            }
            sb.append(".*?");
        }
        return BlockTypeResTransformer.replaceFullGenericType(text, newBlockType, newBlockId, oldTypeName, oldTypeNamespace, sb.toString());
    }

    public static String replaceFullGenericType(String text, BlockType blockType, ResourceLocation blockId, String oldTypeName, @Nullable String oldNamespace, String folderName) {
        Pattern blockPathSubPathPattern = Pattern.compile("([^,]*(?=/))");
        Matcher blockPathSubPathMather = blockPathSubPathPattern.matcher(blockId.getPath());
        String blockFolderPrefix = blockPathSubPathMather.find() ? blockPathSubPathMather.group(1) : "";
        String blockTypeName = blockType.getTypeName();
        String newNamespace = oldNamespace == null ? "" : blockId.getNamespace() + ":";
        oldNamespace = oldNamespace == null ? "" : (String)oldNamespace + ":";
        String folderRegEx = "(" + folderName + ")/";
        String excludeKeyword = "(?<![a-z]stone)";
        Pattern subFolderPattern = Pattern.compile((String)oldNamespace + folderRegEx + "([\\w,/,\\-]*)" + oldTypeName + excludeKeyword);
        Matcher subFolderMatcher = subFolderPattern.matcher(text);
        return subFolderMatcher.replaceAll(m -> {
            String group2 = m.group(2).contains(oldTypeName) ? m.group(2).replaceAll(oldTypeName, blockTypeName) : m.group(2);
            return newNamespace + BlockTypeResTransformer.joinWithSeparator(m.group(1), blockFolderPrefix, group2 + blockTypeName);
        });
    }

    private static String joinWithSeparator(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            if (s.isEmpty()) continue;
            if (!sb.isEmpty()) {
                sb.append("/");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @FunctionalInterface
    public static interface TextModification<T extends BlockType>
    extends TriFunction<String, ResourceLocation, T, String> {
        @Override
        public String apply(String var1, ResourceLocation var2, T var3);
    }
}

