/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import org.jetbrains.annotations.Nullable;

public class Respriter {
    private final TextureImage imageToRecolor;
    private final List<Palette> originalPalettes;
    private final boolean useMergedPalette;

    public static Respriter of(TextureImage imageToRecolor) {
        return new Respriter(imageToRecolor, Palette.fromAnimatedImage(imageToRecolor, null, 0.0f));
    }

    public static Respriter masked(TextureImage imageToRecolor, TextureImage colorMask) {
        return new Respriter(imageToRecolor, List.of(Palette.fromImage(imageToRecolor, colorMask, 0.0f)));
    }

    public static Respriter ofPalette(TextureImage imageToRecolor, List<Palette> colorsToSwap) {
        return new Respriter(imageToRecolor, colorsToSwap);
    }

    public static Respriter ofPalette(TextureImage imageToRecolor, Palette colorsToSwap) {
        return new Respriter(imageToRecolor, List.of(colorsToSwap));
    }

    private Respriter(TextureImage imageToRecolor, List<Palette> colorsToSwap) {
        if (colorsToSwap.isEmpty()) {
            throw new UnsupportedOperationException("Respriter must have a non empty target palette");
        }
        if (imageToRecolor.frameCount() > colorsToSwap.size()) {
            Palette firstPalette = colorsToSwap.get(0);
            colorsToSwap = Collections.nCopies(imageToRecolor.frameCount(), firstPalette);
            this.useMergedPalette = true;
        } else {
            this.useMergedPalette = false;
        }
        this.imageToRecolor = imageToRecolor;
        this.originalPalettes = colorsToSwap;
    }

    public TextureImage recolorWithAnimationOf(TextureImage textureImage) {
        return this.recolorWithAnimation(List.of(Palette.fromImage(textureImage)), textureImage.getMcMeta());
    }

    @Deprecated(forRemoval=true)
    public TextureImage recolorWithAnimation(List<Palette> targetPalettes, @Nullable AnimationMetadataSection targetAnimationData) {
        return this.recolorWithAnimation(targetPalettes, targetAnimationData == null ? null : McMetaFile.of(targetAnimationData));
    }

    public TextureImage recolorWithAnimation(List<Palette> targetPalettes, @Nullable McMetaFile targetAnimationData) {
        if (targetAnimationData == null) {
            return this.recolor(targetPalettes);
        }
        Palette originalPalette = this.originalPalettes.get(0);
        if (this.imageToRecolor.getMcMeta() != null) {
            targetAnimationData = this.imageToRecolor.getMcMeta();
        }
        TextureImage texture = this.imageToRecolor.createAnimationTemplate(targetPalettes.size(), targetAnimationData);
        NativeImage img = texture.getImage();
        HashMap mapForFrameCache = new HashMap();
        texture.forEachFramePixel((ind, x, y) -> {
            Integer oldValue;
            Integer newValue;
            int finalInd = this.useMergedPalette ? 0 : ind;
            ColorToColorMap oldToNewMap = mapForFrameCache.computeIfAbsent(finalInd, i -> {
                Palette toPalette = (Palette)targetPalettes.get(finalInd);
                return ColorToColorMap.create(originalPalette, toPalette);
            });
            if (oldToNewMap != null && (newValue = oldToNewMap.mapColor(oldValue = Integer.valueOf(img.getPixelRGBA(x.intValue(), y.intValue())))) != null) {
                img.setPixelRGBA(x.intValue(), y.intValue(), newValue.intValue());
            }
        });
        return texture;
    }

    public TextureImage recolor(Palette targetPalette) {
        return this.recolor(List.of(targetPalette));
    }

    public TextureImage recolor(List<Palette> targetPalettes) {
        boolean onlyUseFirst = targetPalettes.size() < this.originalPalettes.size();
        TextureImage texture = this.imageToRecolor.makeCopy();
        NativeImage img = texture.getImage();
        HashMap mapForFrameCache = new HashMap();
        texture.forEachFramePixel((ind, x, y) -> {
            Integer oldValue;
            Integer newValue;
            int finalInd = this.useMergedPalette ? 0 : ind;
            ColorToColorMap oldToNewMap = mapForFrameCache.computeIfAbsent(ind, i -> {
                Palette toPalette = onlyUseFirst ? (Palette)targetPalettes.get(0) : (Palette)targetPalettes.get(finalInd);
                Palette originalPalette = this.originalPalettes.get(finalInd);
                return ColorToColorMap.create(originalPalette, toPalette);
            });
            if (oldToNewMap != null && (newValue = oldToNewMap.mapColor(oldValue = Integer.valueOf(img.getPixelRGBA(x.intValue(), y.intValue())))) != null) {
                img.setPixelRGBA(x.intValue(), y.intValue(), newValue.intValue());
            }
        });
        return texture;
    }

    public record ColorToColorMap(Map<Integer, Integer> map) {
        @Nullable
        public Integer mapColor(Integer color) {
            return this.map.get(color);
        }

        @Nullable
        public static ColorToColorMap create(Palette originalPalette, Palette toPalette) {
            Palette copy = toPalette.copy();
            copy.matchSize(originalPalette.size(), Float.valueOf(originalPalette.getAverageLuminanceStep()));
            if (copy.size() != originalPalette.size()) {
                return null;
            }
            return new ColorToColorMap(ColorToColorMap.zipToMap(originalPalette.getValues(), copy.getValues()));
        }

        private static Map<Integer, Integer> zipToMap(List<PaletteColor> keys, List<PaletteColor> values) {
            return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(i -> ((PaletteColor)keys.get((int)i)).value(), i -> ((PaletteColor)values.get((int)i)).value()));
        }
    }
}

