/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.neoforge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.mehvahdjukaar.moonlight.neoforge.MoonlightForge;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSetInternalImpl {
    private static final Map<String, Map<ResourceKey<? extends Registry<?>>, List<Runnable>>> LATE_REGISTRATION_QUEUE = new ConcurrentHashMap();
    private static boolean hasFilledBlockSets = false;

    public static <T extends BlockType, E> void addDynamicRegistration(BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType, Registry<E> registry) {
        if (registry == BuiltInRegistries.BLOCK) {
            BlockSetInternalImpl.addEvent(BuiltInRegistries.BLOCK, registrationFunction, blockType);
        } else if (registry == BuiltInRegistries.ITEM) {
            BlockSetInternalImpl.addEvent(BuiltInRegistries.ITEM, registrationFunction, blockType);
        } else {
            if (registry == BuiltInRegistries.FLUID || registry == BuiltInRegistries.SOUND_EVENT) {
                throw new IllegalArgumentException("Fluid and Sound Events registry not supported here");
            }
            BlockSetInternalImpl.getOrAddQueue(Registries.BLOCK_ENTITY_TYPE);
            RegHelper.registerInBatch(registry, e -> registrationFunction.accept((Registrator)e, BlockSetAPI.getBlockSet(blockType).getValues()));
        }
    }

    public static <T extends BlockType, E> void addEvent(Registry<E> reg, BlockSetAPI.BlockTypeRegistryCallback<E, T> registrationFunction, Class<T> blockType) {
        List<Runnable> registrationQueues = BlockSetInternalImpl.getOrAddQueue(reg.key());
        Runnable lateRegistration = () -> registrationFunction.accept((r, o) -> Registry.register((Registry)reg, (ResourceLocation)r, (Object)o), BlockSetAPI.getBlockSet(blockType).getValues());
        registrationQueues.add(lateRegistration);
    }

    @NotNull
    private static List<Runnable> getOrAddQueue(@Nullable ResourceKey<? extends Registry<?>> regKey) {
        IEventBus bus = MoonlightForge.getCurrentBus();
        String modId = ModLoadingContext.get().getActiveContainer().getModId();
        return LATE_REGISTRATION_QUEUE.computeIfAbsent(modId, m -> {
            HashMap map = new HashMap();
            Consumer<RegisterEvent> eventConsumer = r -> BlockSetInternalImpl.registerLateBlockAndItems(r, map);
            bus.addListener(EventPriority.HIGHEST, eventConsumer);
            return map;
        }).computeIfAbsent(regKey, c -> new ArrayList());
    }

    protected static void registerLateBlockAndItems(RegisterEvent event, Map<ResourceKey<? extends Registry<?>>, List<Runnable>> toRun) {
        if (event.getRegistryKey().equals(BuiltInRegistries.ENTITY_TYPE.key()) && !hasFilledBlockSets) {
            BlockSetInternal.initializeBlockSets();
            hasFilledBlockSets = true;
        }
        if (event.getRegistryKey().equals(Registries.ENTITY_TYPE)) {
            List<Runnable> itemQueue;
            List<Runnable> blockQueue;
            BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
            if (!hasFilledBlockSets) {
                BlockSetInternal.initializeBlockSets();
                hasFilledBlockSets = true;
            }
            if ((blockQueue = toRun.remove(Registries.BLOCK)) != null) {
                blockQueue.forEach(Runnable::run);
            }
            if ((itemQueue = toRun.remove(Registries.ITEM)) != null) {
                itemQueue.forEach(Runnable::run);
            }
            for (Map.Entry<ResourceKey<Registry<?>>, List<Runnable>> e : toRun.entrySet()) {
                e.getValue().forEach(Runnable::run);
            }
            toRun.clear();
        }
    }

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    static {
        Consumer<RegisterEvent> eventConsumer = e -> {
            if (e.getRegistryKey().equals(BuiltInRegistries.POTION.key())) {
                BlockSetInternal.getRegistries().forEach(BlockTypeRegistry::onItemInit);
            }
        };
        MoonlightForge.getCurrentBus().addListener(eventConsumer);
    }
}

