/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.neoforge;

import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.platform.configs.ModConfigHolder;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

public class MoonlightForgeClient {
    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(MoonlightForgeClient::afterLoad);
        modEventBus.addListener(EventPriority.LOWEST, MoonlightForgeClient::onTextureStitch);
        NeoForge.EVENT_BUS.addListener(MoonlightForgeClient::onInputUpdate);
    }

    public static void afterLoad(FMLLoadCompleteEvent event) {
        for (ModConfigHolder config : ModConfigHolder.getTrackedSpecs()) {
            if (config.hasConfigScreen()) continue;
            ModList.get().getModContainerById(config.getModId()).ifPresent(c -> c.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new)));
        }
    }

    public static void onTextureStitch(TextureAtlasStitchedEvent event) {
        MoonlightClient.afterTextureReload();
    }

    public static void onInputUpdate(MovementInputUpdateEvent event) {
        Entity riddenEntity;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (riddenEntity = mc.player.getVehicle()) instanceof IControllableVehicle) {
            IControllableVehicle listener = (IControllableVehicle)riddenEntity;
            Input movementInput = event.getInput();
            listener.onInputUpdate(movementInput.left, movementInput.right, movementInput.up, movementInput.down, mc.options.keySprint.isDown(), movementInput.jumping);
        }
    }
}

