/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.block.CrabEggBlock;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CrabBrain;
import com.faboslav.friendsandfoes.common.entity.ai.control.WallClimbNavigation;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.CrabAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.pose.CrabEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedGameRulesProvider;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import com.faboslav.friendsandfoes.common.versions.VersionedProfilerProvider;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CrabEntity
extends Animal
implements FlyingAnimal,
AnimatedEntity {
    public static final float BABY_SCALE = 0.3f;
    private static final float MOVEMENT_SPEED = 0.225f;
    private static final String SIZE_NBT_NAME = "Size";
    private static final String HOME_NBT_NAME = "Home";
    private static final String HOME_NBT_NAME_X = "x";
    private static final String HOME_NBT_NAME_Y = "y";
    private static final String HOME_NBT_NAME_Z = "z";
    private static final String HAS_EGG_NBT_NAME = "HasEgg";
    private AnimationContextTracker animationContextTracker;
    private static final EntityDataAccessor<Integer> POSE_TICKS = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_CLIMBING_WALL = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> SIZE = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> HOME = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_DANCING = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int climbingTicks = 0;

    public CrabEntity(EntityType<? extends CrabEntity> entityType, Level world) {
        super(entityType, world);
        this.setPose(CrabEntityPose.IDLE);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DOOR_IRON_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_WOOD_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_OPEN, -1.0f);
        this.lookControl = new CrabLookControl(this, 10);
        this.navigation = new CrabWallClimbNavigation((Mob)this, world);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        SpawnGroupData superEntityData = super.finalizeSpawn(world, difficulty, spawnReason, entityData);
        this.setHome(this.getNewHome());
        this.setSize(CrabSize.getRandomCrabSize(world.getRandom()));
        this.setPose(CrabEntityPose.IDLE);
        CrabBrain.setWaveCooldown(this);
        return superEntityData;
    }

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (AnimationHolder animation : this.getTrackedAnimations()) {
                this.animationContextTracker.add(animation);
            }
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return CrabAnimations.ANIMATIONS;
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        return CrabAnimations.WALK;
    }

    public boolean isPushedByFluid() {
        return !this.isSwimming();
    }

    public boolean shouldDiscardFriction() {
        return this.isSwimming();
    }

    public void jumpFromGround() {
    }

    public boolean isFlying() {
        return this.onClimbable();
    }

    public float getSpeed() {
        if (this.isBaby()) {
            return 0.1125f;
        }
        return 0.225f;
    }

    @Override
    public int getCurrentAnimationTick() {
        return (Integer)this.entityData.get(POSE_TICKS);
    }

    @Override
    public void setCurrentAnimationTick(int keyframeAnimationTicks) {
        this.entityData.set(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(POSE_TICKS, (Object)0);
        builder.define(IS_CLIMBING_WALL, (Object)false);
        builder.define(SIZE, (Object)CrabSize.getDefaultCrabSize().getName());
        builder.define(HOME, (Object)new CompoundTag());
        builder.define(HAS_EGG, (Object)false);
        builder.define(IS_DANCING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString(SIZE_NBT_NAME, this.getSize().getName());
        nbt.put(HOME_NBT_NAME, (Tag)this.getHome());
        nbt.putBoolean(HAS_EGG_NBT_NAME, this.hasEgg());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setSize(Objects.requireNonNull(CrabSize.getCrabSizeByName(VersionedNbt.getString(nbt, SIZE_NBT_NAME, CrabSize.getDefaultCrabSize().getName()))));
        this.setHome(VersionedNbt.getCompound(nbt, HOME_NBT_NAME));
        this.setHasEgg(VersionedNbt.getBoolean(nbt, HAS_EGG_NBT_NAME, false));
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CrabBrain.create(dynamic);
    }

    public Brain<CrabEntity> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public static AttributeSupplier.Builder createCrabAttributes() {
        AttributeSupplier.Builder attributes = Mob.createMobAttributes();
        return attributes.add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, (double)0.225f).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.STEP_HEIGHT, 0.0).add(Attributes.SCALE);
    }

    protected float nextStep() {
        return this.moveDist + 0.175f;
    }

    public boolean onClimbable() {
        return this.climbingTicks > 8 && this.isClimbingWall();
    }

    public boolean isClimbingWall() {
        return (Boolean)this.entityData.get(IS_CLIMBING_WALL);
    }

    public void setClimbingWall(boolean isClimbingWall) {
        this.entityData.set(IS_CLIMBING_WALL, (Object)isClimbingWall);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_CRAB_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)FriendsAndFoesSoundEvents.ENTITY_CRAB_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (!this.onGround() && state.liquid()) {
            return;
        }
        this.playSound((SoundEvent)FriendsAndFoesSoundEvents.ENTITY_CRAB_STEP.get(), 0.15f, 1.0f + this.random.nextFloat() * 0.2f);
    }

    public void tick() {
        if (!this.level().isClientSide() && !FriendsAndFoes.getConfig().enableCrab) {
            this.discard();
        }
        this.updateKeyframeAnimations();
        this.calculateSize();
        super.tick();
        if (!this.level().isClientSide()) {
            this.setClimbingWall(this.horizontalCollision);
        }
        if (this.isClimbingWall()) {
            ++this.climbingTicks;
            BlockState blockStateAtPos = this.getInBlockState();
            if (this.isMoving() && !blockStateAtPos.liquid() && this.climbingTicks % 6 == 0) {
                this.playStepSound(this.blockPosition(), blockStateAtPos);
            }
        } else {
            this.climbingTicks = 0;
        }
        if (this.onClimbable()) {
            Vec3 velocity = this.getDeltaMovement();
            this.setDeltaMovement(velocity.x, velocity.y * (double)0.33f, velocity.z);
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 5 == 0) {
            boolean isDancing = false;
            for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)this.blockPosition(), (int)7, (int)7, (int)7)) {
                BlockEntity possibleJukeboxBlockEntity;
                BlockPos.MutableBlockPos possibleJukeboxBlockPos = blockPos.mutable();
                BlockState possibleJukeboxBlockState = this.level().getBlockState((BlockPos)possibleJukeboxBlockPos);
                if (!possibleJukeboxBlockState.is(Blocks.JUKEBOX) || !possibleJukeboxBlockState.hasBlockEntity() || !((possibleJukeboxBlockEntity = this.level().getBlockEntity((BlockPos)possibleJukeboxBlockPos)) instanceof JukeboxBlockEntity) || !((JukeboxBlockEntity)possibleJukeboxBlockEntity).getSongPlayer().isPlaying()) continue;
                isDancing = true;
                break;
            }
            this.setIsDancing(isDancing);
        }
    }

    private void updateKeyframeAnimations() {
        AnimationHolder animationToStart;
        if (!this.level().isClientSide()) {
            this.updateCurrentAnimationTick();
        }
        if ((animationToStart = this.getAnimationByPose()) != null) {
            this.tryToStartAnimation(animationToStart);
        }
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        AnimationHolder animation = null;
        if (this.isInPose(CrabEntityPose.IDLE) && !this.isMoving()) {
            animation = CrabAnimations.IDLE;
        } else if (this.isInPose(CrabEntityPose.WAVE)) {
            animation = CrabAnimations.WAVE;
        } else if (this.isInPose(CrabEntityPose.DANCE)) {
            animation = CrabAnimations.DANCE;
        }
        return animation;
    }

    private void tryToStartAnimation(AnimationHolder animationToStart) {
        if (this.isKeyframeAnimationRunning(animationToStart)) {
            return;
        }
        if (!this.level().isClientSide()) {
            this.setCurrentAnimationTick(animationToStart.get().lengthInTicks());
        }
        this.startKeyframeAnimation(animationToStart);
    }

    private void startKeyframeAnimation(AnimationHolder animationToStart) {
        for (AnimationHolder animation : this.getTrackedAnimations()) {
            if (animation == animationToStart) continue;
            this.stopKeyframeAnimation(animation);
        }
        this.startKeyframeAnimation(animationToStart, this.tickCount);
    }

    public void startWaveAnimation() {
        if (this.isInPose(CrabEntityPose.WAVE)) {
            return;
        }
        this.setPose(CrabEntityPose.WAVE);
    }

    public void startDanceAnimation() {
        if (this.isInPose(CrabEntityPose.DANCE)) {
            return;
        }
        this.setPose(CrabEntityPose.DANCE);
    }

    public void setPose(CrabEntityPose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        this.setPose(pose.get());
    }

    public boolean hasPose(Pose pose) {
        return this.getPose() == pose;
    }

    public boolean isInPose(CrabEntityPose pose) {
        return this.getPose() == pose.get();
    }

    protected void customServerAiStep() {
        ServerLevel level = (ServerLevel)this.level();
        ProfilerFiller profiler = VersionedProfilerProvider.getProfiler((Entity)this);
        profiler.push("crabBrain");
        this.getBrain().tick(level, (LivingEntity)this);
        profiler.pop();
        profiler.push("crabMemoryUpdate");
        CrabBrain.updateMemories(this);
        profiler.pop();
        profiler.push("crabActivityUpdate");
        CrabBrain.updateActivities(this);
        profiler.pop();
        super.customServerAiStep();
    }

    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && VersionedGameRulesProvider.getGameRules((Entity)this).getBoolean(GameRules.RULE_DOMOBLOOT)) {
            VersionedEntity.spawnAtLocation((Entity)this, ((Item)FriendsAndFoesItems.CRAB_CLAW.get()).getDefaultInstance(), 1.0f);
        }
    }

    public boolean isMoving() {
        return (this.onGround() || this.onClimbable()) && this.getDeltaMovement().lengthSqr() >= 1.0E-4;
    }

    public static boolean canSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(FriendsAndFoesTags.CRABS_SPAWNABLE_ON) && CrabEggBlock.isSuitableBelow((BlockGetter)world, pos) && CrabEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public boolean isFood(ItemStack itemStack) {
        return CrabBrain.getTemptations().test(itemStack);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob entity) {
        CrabEntity crab = (CrabEntity)((EntityType)FriendsAndFoesEntityTypes.CRAB.get()).create((Level)serverWorld);
        CrabBrain.setWaveCooldown(crab);
        return crab;
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal mate) {
        ServerPlayer serverPlayerEntity = this.getLoveCause();
        if (serverPlayerEntity == null && mate.getLoveCause() != null) {
            serverPlayerEntity = mate.getLoveCause();
        }
        if (serverPlayerEntity != null) {
            serverPlayerEntity.awardStat(Stats.ANIMALS_BRED);
            CriteriaTriggers.BRED_ANIMALS.trigger(serverPlayerEntity, (Animal)this, mate, null);
        }
        this.setHasEgg(true);
        this.resetLove();
        mate.resetLove();
        RandomSource random = this.getRandom();
        if (VersionedGameRulesProvider.getGameRules((Entity)this).getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY(), this.getZ(), random.nextInt(7) + 1));
        }
    }

    @Nullable
    public GlobalPos getBurrowSpotPos() {
        return this.getBrain().getMemoryInternal((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()).orElse(null);
    }

    public boolean isBurrowSpotAccessible(BlockPos pos) {
        Level world = this.level();
        boolean isBlockSand = world.getBlockState(pos.below()).is(FriendsAndFoesTags.CRAB_BURROW_SPOT_BLOCKS);
        boolean isBlockAccessible = world.isEmptyBlock(pos) && world.isEmptyBlock(pos.above());
        return isBlockSand && isBlockAccessible;
    }

    public CompoundTag getNewHome() {
        CompoundTag home = new CompoundTag();
        home.putDouble(HOME_NBT_NAME_X, this.position().x());
        home.putDouble(HOME_NBT_NAME_Y, this.position().y());
        home.putDouble(HOME_NBT_NAME_Z, this.position().z());
        return home;
    }

    public void setHome(CompoundTag home) {
        this.entityData.set(HOME, (Object)home);
    }

    public CompoundTag getHome() {
        return (CompoundTag)this.entityData.get(HOME);
    }

    public Vec3 getHomePos() {
        CompoundTag nbt = this.getHome();
        return new Vec3(VersionedNbt.getDouble(nbt, HOME_NBT_NAME_X, this.position().x()), VersionedNbt.getDouble(nbt, HOME_NBT_NAME_Y, this.position().y()), VersionedNbt.getDouble(nbt, HOME_NBT_NAME_Z, this.position().z()));
    }

    public boolean isAtHomePos() {
        return this.distanceToSqr(this.getHomePos()) < 0.1;
    }

    public boolean isCloseToHomePos(float distance) {
        return this.distanceToSqr(this.getHomePos()) < (double)distance;
    }

    public boolean hasEgg() {
        return (Boolean)this.entityData.get(HAS_EGG);
    }

    public void setHasEgg(boolean hasEgg) {
        this.entityData.set(HAS_EGG, (Object)hasEgg);
    }

    public boolean isDancing() {
        return (Boolean)this.entityData.get(IS_DANCING);
    }

    public void setIsDancing(boolean isDancing) {
        this.entityData.set(IS_DANCING, (Object)isDancing);
    }

    private void setSize(CrabSize size) {
        this.entityData.set(SIZE, (Object)size.getName());
        this.calculateSize();
    }

    private void calculateSize() {
        this.refreshDimensions();
        this.makeBoundingBox();
    }

    public CrabSize getSize() {
        return CrabSize.getCrabSizeByName((String)this.entityData.get(SIZE));
    }

    public float getAgeScale() {
        CrabSize size = this.getSize();
        float scaleModifier = size.getScaleModifier();
        if (this.isBaby()) {
            return scaleModifier * 0.3f;
        }
        return scaleModifier;
    }

    class CrabLookControl
    extends SmoothSwimmingLookControl {
        public CrabLookControl(CrabEntity crab, int yawAdjustThreshold) {
            super((Mob)crab, yawAdjustThreshold);
        }

        public void tick() {
            if (!CrabEntity.this.onClimbable()) {
                super.tick();
            }
        }
    }

    class CrabWallClimbNavigation
    extends WallClimbNavigation {
        public CrabWallClimbNavigation(Mob mobEntity, Level world) {
            super(mobEntity, world);
        }

        @Override
        public void tick() {
            if (!CrabEntity.this.isDancing()) {
                super.tick();
            }
        }
    }

    public static enum CrabSize {
        SMALL("small", 0.9f),
        MEDIUM("medium", 0.95f),
        BIG("big", 1.0f);

        private final String name;
        private final float scaleModifier;

        private CrabSize(String name, float scaleModifier) {
            this.name = name;
            this.scaleModifier = scaleModifier;
        }

        public String getName() {
            return this.name;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }

        @Nullable
        public static CrabSize getCrabSizeByName(String name) {
            for (CrabSize crabSize : CrabSize.values()) {
                if (!Objects.equals(crabSize.getName(), name)) continue;
                return crabSize;
            }
            return null;
        }

        public static CrabSize getDefaultCrabSize() {
            return BIG;
        }

        public static CrabSize getRandomCrabSize(RandomSource random) {
            CrabSize[] values = CrabSize.values();
            int min = 0;
            int max = values.length - 1;
            return values[random.nextInt(max - min + 1) + min];
        }
    }
}

