/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareBeGrumpyAtDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareLocateGlowBerriesTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareShakeGlowBerriesTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareStrollTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTeleportToOwnerTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToDarkSpotTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare.GlareTravelToGlowBerriesTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSensorTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GoToWantedItem;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StayCloseToTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;

public final class GlareBrain {
    public static final List<MemoryModuleType<?>> MEMORY_MODULES;
    public static final List<SensorType<? extends Sensor<? super GlareEntity>>> SENSORS;
    private static final UniformInt DARK_SPOT_LOCATING_COOLDOWN_PROVIDER;
    private static final UniformInt EAT_GLOW_BERRIES_COOLDOWN_PROVIDER;

    public static Brain<?> create(Dynamic<?> dynamic) {
        Brain.Provider profile = Brain.provider(MEMORY_MODULES, SENSORS);
        Brain brain = profile.makeBrain(dynamic);
        GlareBrain.addCoreActivities((Brain<GlareEntity>)brain);
        GlareBrain.addAvoidActivities((Brain<GlareEntity>)brain);
        GlareBrain.addIdleActivities((Brain<GlareEntity>)brain);
        GlareBrain.addDarkSpotActivities((Brain<GlareEntity>)brain);
        GlareBrain.addGlowBerriesActivities((Brain<GlareEntity>)brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void addCoreActivities(Brain<GlareEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get()), (Object)new CountDownCooldownTicks((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get())));
    }

    private static void addDarkSpotActivities(Brain<GlareEntity> brain) {
        brain.addActivityWithConditions((Activity)FriendsAndFoesActivities.GLARE_SHOW_DARK_SPOT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new GlareLocateDarkSpotTask())), (Object)Pair.of((Object)1, (Object)((Object)new GlareTravelToDarkSpotTask())), (Object)Pair.of((Object)2, (Object)((Object)new GlareBeGrumpyAtDarkSpotTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get()), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object[])new Pair[0]));
    }

    private static void addGlowBerriesActivities(Brain<GlareEntity> brain) {
        brain.addActivityWithConditions((Activity)FriendsAndFoesActivities.GLARE_EAT_GLOW_BERRIES.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)GoToWantedItem.create(glare -> true, (float)1.25f, (boolean)true, (int)32)), (Object)Pair.of((Object)1, (Object)((Object)new GlareLocateGlowBerriesTask())), (Object)Pair.of((Object)2, (Object)((Object)new GlareTravelToGlowBerriesTask())), (Object)Pair.of((Object)3, (Object)((Object)new GlareShakeGlowBerriesTask()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addAvoidActivities(Brain<GlareEntity> brain) {
        brain.addActivityWithConditions(Activity.AVOID, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.25f, (int)16, (boolean)false))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get()), (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void addIdleActivities(Brain<GlareEntity> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new FollowTemptation(glare -> Float.valueOf(1.25f))), (Object)Pair.of((Object)1, (Object)new AnimalMakeLove((EntityType)FriendsAndFoesEntityTypes.GLARE.get())), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)((Object)new GlareTeleportToOwnerTask())), (Object)Pair.of((Object)4, (Object)StayCloseToTarget.create(glare -> GlareBrain.getOwner((GlareEntity)glare), glare -> true, (int)3, (int)8, (float)2.0f)), (Object)Pair.of((Object)5, (Object)SetEntityLookTargetSometimes.create((float)3.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)6, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)3), (Object)Pair.of((Object)((Object)new GlareStrollTask()), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.AVOID_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get()), (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get()), (Object)MemoryStatus.VALUE_PRESENT), (Object)Pair.of((Object)((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get()), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static Optional<PositionTracker> getOwner(GlareEntity glare) {
        if (!glare.isTame() || glare.getOwner() == null) {
            return Optional.empty();
        }
        return Optional.of(new EntityTracker((Entity)glare.getOwner(), true));
    }

    public static void updateActivities(GlareEntity glare) {
        glare.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)FriendsAndFoesActivities.GLARE_SHOW_DARK_SPOT.get()), (Object)((Activity)FriendsAndFoesActivities.GLARE_EAT_GLOW_BERRIES.get()), (Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static void updateMemories(GlareEntity glare) {
        if ((!glare.isBaby() && !glare.isTame() || !GlareLocateDarkSpotTask.canLocateDarkSpot(glare)) && glare.getBrain().checkMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT)) {
            GlareBrain.setDarkSpotLocatingCooldown(glare);
        }
        if (glare.isOrderedToSit() || glare.isLeashed() || glare.isPassenger()) {
            glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (Object)true);
        } else {
            glare.getBrain().eraseMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get());
        }
        if (glare.isTame()) {
            glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (Object)true);
        } else {
            glare.getBrain().eraseMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get());
        }
    }

    public static void setDarkSpotLocatingCooldown(GlareEntity glare) {
        glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)DARK_SPOT_LOCATING_COOLDOWN_PROVIDER.sample(glare.getRandom()));
    }

    public static void setDarkSpotLocatingCooldown(GlareEntity glare, UniformInt cooldown) {
        glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (Object)cooldown.sample(glare.getRandom()));
    }

    public static void setLocatingGlowBerriesCooldown(GlareEntity glare) {
        glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)EAT_GLOW_BERRIES_COOLDOWN_PROVIDER.sample(glare.getRandom()));
    }

    public static void setLocatingGlowBerriesCooldown(GlareEntity glare, UniformInt cooldown) {
        glare.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get(), (Object)cooldown.sample(glare.getRandom()));
    }

    public static void setItemPickupCooldown(GlareEntity glare) {
        glare.getBrain().setMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, (Object)TimeUtil.rangeOfSeconds((int)1, (int)10).sample(glare.getRandom()));
    }

    public static Predicate<ItemStack> getTemptations() {
        return itemStack -> itemStack.is(FriendsAndFoesTags.GLARE_TEMPT_ITEMS);
    }

    static {
        SENSORS = List.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.NEAREST_ITEMS, SensorType.NEAREST_ADULT, (SensorType)FriendsAndFoesSensorTypes.GLARE_TEMPTATIONS.get(), (SensorType)FriendsAndFoesSensorTypes.GLARE_SPECIFIC_SENSOR.get());
        MEMORY_MODULES = List.of(MemoryModuleType.IS_PANICKING, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryModuleType.IS_PANICKING, MemoryModuleType.IS_TEMPTED, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.PATH, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.ATE_RECENTLY, MemoryModuleType.BREED_TARGET, MemoryModuleType.AVOID_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.NEAREST_VISIBLE_WANTED_ITEM, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_IDLE.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_IS_TAMED.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.GLARE_LOCATING_GLOW_BERRIES_COOLDOWN.get());
        DARK_SPOT_LOCATING_COOLDOWN_PROVIDER = TimeUtil.rangeOfSeconds((int)20, (int)40);
        EAT_GLOW_BERRIES_COOLDOWN_PROVIDER = TimeUtil.rangeOfSeconds((int)30, (int)60);
    }
}

