/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json;

import com.faboslav.friendsandfoes.common.entity.animation.AnimationChannel;
import com.faboslav.friendsandfoes.common.entity.animation.animator.Keyframe;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.AnimationTarget;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationParser;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class AnimationTypeManager {
    private static final ImmutableBiMap<ResourceLocation, AnimationTarget> DEFAULT_TARGETS = ImmutableBiMap.of((Object)ResourceLocation.withDefaultNamespace((String)"position"), (Object)AnimationTarget.POSITION, (Object)ResourceLocation.withDefaultNamespace((String)"rotation"), (Object)AnimationTarget.ROTATION, (Object)ResourceLocation.withDefaultNamespace((String)"scale"), (Object)AnimationTarget.SCALE);
    private static final ImmutableBiMap<ResourceLocation, AnimationChannel.Interpolation> DEFAULT_INTERPOLATIONS = ImmutableBiMap.of((Object)ResourceLocation.withDefaultNamespace((String)"linear"), (Object)AnimationChannel.Interpolations.LINEAR, (Object)ResourceLocation.withDefaultNamespace((String)"catmullrom"), (Object)AnimationChannel.Interpolations.CATMULLROM);
    private static ImmutableBiMap<ResourceLocation, AnimationTarget> TARGETS = DEFAULT_TARGETS;
    private static ImmutableMap<AnimationChannel.Target, AnimationTarget> TARGETS_BY_CHANNEL_TARGET = ImmutableMap.of();
    private static ImmutableMap<AnimationTarget, Codec<Keyframe>> KEYFRAME_CODECS = ImmutableMap.of();
    private static ImmutableBiMap<ResourceLocation, AnimationChannel.Interpolation> INTERPOLATIONS = DEFAULT_INTERPOLATIONS;
    private static String TARGET_LIST = "";
    private static String INTERPOLATION_LIST = "";

    private AnimationTypeManager() {
    }

    @Nullable
    public static AnimationTarget getTarget(ResourceLocation name) {
        return (AnimationTarget)TARGETS.get((Object)name);
    }

    @Nullable
    public static ResourceLocation getTargetName(AnimationTarget target) {
        return (ResourceLocation)TARGETS.inverse().get((Object)target);
    }

    @Nullable
    public static AnimationTarget getTargetFromChannelTarget(AnimationChannel.Target target) {
        return (AnimationTarget)TARGETS_BY_CHANNEL_TARGET.get((Object)target);
    }

    @Nullable
    public static Codec<Keyframe> getKeyframeCodec(AnimationTarget target) {
        return (Codec)KEYFRAME_CODECS.get((Object)target);
    }

    @Nullable
    public static AnimationChannel.Interpolation getInterpolation(ResourceLocation name) {
        return (AnimationChannel.Interpolation)INTERPOLATIONS.get((Object)name);
    }

    @Nullable
    public static ResourceLocation getInterpolationName(AnimationChannel.Interpolation interpolation) {
        return (ResourceLocation)INTERPOLATIONS.inverse().get((Object)interpolation);
    }

    public static String getTargetList() {
        return TARGET_LIST;
    }

    public static String getInterpolationList() {
        return INTERPOLATION_LIST;
    }

    @ApiStatus.Internal
    public static void init() {
        ImmutableBiMap.Builder targets = ImmutableBiMap.builder().putAll(DEFAULT_TARGETS);
        ImmutableBiMap.Builder interpolations = ImmutableBiMap.builder().putAll(DEFAULT_INTERPOLATIONS);
        TARGETS = targets.buildOrThrow();
        INTERPOLATIONS = interpolations.buildOrThrow();
        AnimationTypeManager.recomputeDerivedFields();
    }

    private static void recomputeDerivedFields() {
        TARGETS_BY_CHANNEL_TARGET = (ImmutableMap)TARGETS.values().stream().collect(ImmutableMap.toImmutableMap(AnimationTarget::channelTarget, Function.identity()));
        KEYFRAME_CODECS = (ImmutableMap)TARGETS.values().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), AnimationParser::keyframeCodec));
        TARGET_LIST = TARGETS.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
        INTERPOLATION_LIST = INTERPOLATIONS.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
    }

    static {
        AnimationTypeManager.recomputeDerivedFields();
    }
}

