/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ZombieHorseEntityAccess;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin
extends Level
implements WorldGenLevel {
    protected ServerWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow
    protected abstract BlockPos findLightningTargetAround(BlockPos var1);

    @Inject(method={"tickChunk"}, at={@At(value="TAIL")})
    public void friendsandfoes_addZombieHorseSpawnEvent(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        if (FriendsAndFoes.getConfig().enableZombieHorseTrap) {
            BlockPos blockPos;
            ChunkPos chunkPos = chunk.getPos();
            int i = chunkPos.getMinBlockX();
            int j = chunkPos.getMinBlockZ();
            ProfilerFiller profiler = this.getProfiler();
            profiler.push("thunder2");
            if (this.isRaining() && this.isThundering() && this.getRandom().nextInt(100000) == 0 && this.isRainingAt(blockPos = this.findLightningTargetAround(this.getBlockRandomPos(i, 0, j, 15)))) {
                boolean canZombieHorseSpawn;
                DifficultyInstance localDifficulty = this.getCurrentDifficultyAt(blockPos);
                boolean bl = canZombieHorseSpawn = ((ServerLevel)this).getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.random.nextDouble() < (double)localDifficulty.getEffectiveDifficulty() * 0.01 && !this.getBlockState(blockPos.below()).is(FriendsAndFoesTags.LIGHTNING_RODS);
                if (canZombieHorseSpawn) {
                    ZombieHorse zombieHorse = (ZombieHorse)EntityType.ZOMBIE_HORSE.create((Level)this);
                    ((ZombieHorseEntityAccess)zombieHorse).friendsandfoes_setTrapped(true);
                    zombieHorse.setAge(0);
                    zombieHorse.setPos((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                    this.addFreshEntity((Entity)zombieHorse);
                }
                LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)this);
                lightningBolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockPos));
                lightningBolt.setVisualOnly(canZombieHorseSpawn);
                this.addFreshEntity((Entity)lightningBolt);
            }
            profiler.pop();
        }
    }

    @Inject(method={"findLightningRod"}, at={@At(value="TAIL")}, cancellable=true)
    public void friendsandfoes_getLightningRodPos(BlockPos pos, CallbackInfoReturnable<Optional<BlockPos>> cir) {
        ServerLevel serverWorld;
        Optional optional;
        if (((Optional)cir.getReturnValue()).isEmpty() && (optional = (serverWorld = (ServerLevel)this).getPoiManager().findClosest(registryEntry -> registryEntry.is(FriendsAndFoesTags.LIGHTNING_ROD_POI), posx -> posx.getY() == this.getHeight(Heightmap.Types.WORLD_SURFACE, posx.getX(), posx.getZ()) - 1, pos, 128, PoiManager.Occupancy.ANY)).isPresent()) {
            cir.setReturnValue(optional.map(posx -> posx.above(1)));
        }
    }
}

