/*
 * Decompiled with CFR 0.152.
 */
package net.countered.terrainslabs.mixin;

import net.fabricmc.fabric.mixin.content.registry.ShovelItemAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShovelItem.class})
public abstract class ShovelItemMixin {
    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void useOnCustomSlab(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = world.getBlockState(blockPos);
        if (context.getClickedFace() == Direction.DOWN) {
            return;
        }
        BlockState pathState = (BlockState)ShovelItemAccessor.getPathStates().get(blockState.getBlock());
        if (pathState != null && blockState.getBlock() instanceof SlabBlock && world.getBlockState(blockPos.above()).isAir()) {
            Player playerEntity = context.getPlayer();
            SlabType slabType = (SlabType)blockState.getValue((Property)SlabBlock.TYPE);
            pathState = (BlockState)((BlockState)pathState.setValue((Property)SlabBlock.TYPE, (Comparable)slabType)).setValue((Property)SlabBlock.WATERLOGGED, (Comparable)((Boolean)blockState.getValue((Property)SlabBlock.WATERLOGGED)));
            world.playSound(playerEntity, blockPos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.isClientSide) {
                world.setBlock(blockPos, pathState, 11);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)playerEntity, (BlockState)pathState));
                if (playerEntity != null) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)playerEntity, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
                }
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

