/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.utils.tradebox;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lekavar.lma.drinkbeer.utils.tradebox.Locations;

public enum Residents {
    EMPTY(0, "empty", Locations.EMPTY),
    LEKA(1, "leka", Locations.NORTHON),
    HAAR(2, "haar", Locations.NORTHON),
    ANU(3, "anu", Locations.TWIGVALLEY),
    WILL(4, "will", Locations.TWIGVALLEY);

    private final int id;
    private final String name;
    private final Locations location;
    public static final Residents EMPTY_RESIDENT;

    private Residents(int id, String name, Locations location) {
        this.id = id;
        this.name = name;
        this.location = location;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Locations getLocation() {
        return this.location;
    }

    public static Residents byId(int id) {
        Residents[] residents;
        for (Residents resident : residents = Residents.values()) {
            if (resident.id != id) continue;
            return resident;
        }
        return EMPTY_RESIDENT;
    }

    public static List<Residents> getList() {
        return Arrays.stream(Residents.values()).collect(Collectors.toList());
    }

    public static List<Residents> getList(Locations location) {
        return Arrays.stream(Residents.values()).filter(resident -> resident.getLocation().equals((Object)location)).collect(Collectors.toList());
    }

    public static List<Residents> getList(int locationId) {
        return Arrays.stream(Residents.values()).filter(resident -> resident.getLocation().getId() == locationId).collect(Collectors.toList());
    }

    public static int size() {
        return Residents.values().length;
    }

    public static int genRandomResidentId(int locationId) {
        int residentId = EMPTY_RESIDENT.getId();
        List<Residents> residentsList = Residents.getList(locationId);
        if (residentsList != null && !residentsList.isEmpty()) {
            residentId = residentsList.get(new Random().nextInt(residentsList.size())).getId();
        }
        return residentId;
    }

    static {
        EMPTY_RESIDENT = EMPTY;
    }
}

