/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.math.Kalkuel;
import com.talhanation.smallships.mixin.controlling.BoatAccessor;
import com.talhanation.smallships.network.ModPackets;
import com.talhanation.smallships.network.packet.ServerboundUpdateShipControlPacket;
import com.talhanation.smallships.world.entity.projectile.ShipCannon;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.IceBreakable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Ship
extends Boat {
    public static final EntityDataAccessor<CompoundTag> ATTRIBUTES = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> ROT_SPEED = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Byte> SAIL_STATE = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<String> SAIL_COLOR = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<ItemStack> BANNER = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Float> CANNON_POWER = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Byte> CANNON_COUNT = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BACKWARD = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SUNKEN = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<CompoundTag> SHIELD_DATA = SynchedEntityData.defineId(Ship.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private boolean isLocked = false;
    private int sunkenTime = 0;
    private float prevWaveAngle;
    private float waveAngle;
    public float prevBannerWaveAngle;
    public float bannerWaveAngle;
    protected boolean cannonKeyPressed;
    public int sailStateCooldown = 0;
    private float setPoint;
    public final List<ShipCannon> CANNONS = new ArrayList<ShipCannon>();
    public final Stack<ItemStack> SHIELDS = new Stack();
    public float maxSpeed;
    private CameraType previousCameraType;

    public Ship(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        if (this.getCustomName() == null) {
            this.setCustomName((Component)Component.literal((String)StringUtils.capitalize((String)EntityType.getKey((EntityType)this.getType()).getPath())));
        }
    }

    public void tick() {
        super.tick();
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() + 1.0f);
        }
        if (this.isSunken()) {
            int n;
            ++this.sunkenTime;
            if ((double)n > (Double)SmallShipsConfig.Common.shipGeneralDespawnTimeSunken.get() * 20.0 * 60.0) {
                this.destroy(this.getCommandSenderWorld().damageSources().drown());
            } else {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.2, this.getDeltaMovement().z);
            }
        } else {
            Ship ship = this;
            if (ship instanceof Sailable) {
                Sailable sailShip = (Sailable)((Object)ship);
                sailShip.tickSailShip();
            }
            if ((ship = this) instanceof Bannerable) {
                Bannerable bannerShip = (Bannerable)((Object)ship);
                bannerShip.tickBannerShip();
            }
            if ((ship = this) instanceof Cannonable) {
                Cannonable cannonShip = (Cannonable)((Object)ship);
                cannonShip.tickCannonShip();
            }
            if ((ship = this) instanceof Paddleable) {
                Paddleable paddleShip = (Paddleable)((Object)ship);
                paddleShip.tickPaddleShip();
            }
            if ((ship = this) instanceof Shieldable) {
                Shieldable shieldShip = (Shieldable)((Object)ship);
                shieldShip.tickShieldShip();
            }
            if ((ship = this) instanceof IceBreakable) {
                IceBreakable iceBreakable = (IceBreakable)((Object)ship);
                iceBreakable.tickIceBreakable();
            }
            boolean isCruising = this.getSpeed() > 0.085f || this.getSpeed() < -0.085f;
            this.updateShipAmbience(isCruising);
            this.updateCollision(isCruising);
            this.updateWaveAngle();
            this.updateWaterMobs();
            this.floatUp();
            if (this.outOfControlTicks > 0.0f) {
                this.outOfControlTicks -= 1.0f;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPEED, (Object)Float.valueOf(0.0f));
        builder.define(ROT_SPEED, (Object)Float.valueOf(0.0f));
        builder.define(ATTRIBUTES, (Object)this.createDefaultAttributes());
        builder.define(FORWARD, (Object)false);
        builder.define(BACKWARD, (Object)false);
        builder.define(LEFT, (Object)false);
        builder.define(RIGHT, (Object)false);
        builder.define(SUNKEN, (Object)false);
        builder.define(SAIL_STATE, (Object)0);
        builder.define(SAIL_COLOR, (Object)SailModel.Color.WHITE.toString());
        builder.define(BANNER, (Object)ItemStack.EMPTY);
        builder.define(CANNON_POWER, (Object)Float.valueOf(4.0f));
        builder.define(CANNON_COUNT, (Object)0);
        builder.define(SHIELD_DATA, (Object)new CompoundTag());
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(tag, this);
        this.setData(ATTRIBUTES, attributes.getSaveData());
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.readSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.readBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.readCannonShipSaveData(tag);
        }
        if ((ship = this) instanceof Shieldable) {
            Shieldable shieldShip = (Shieldable)((Object)ship);
            shieldShip.readShieldShipSaveData(tag);
        }
        this.setSunken(tag.getBoolean("Sunken"));
        this.isLocked = tag.getBoolean("locked");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        attributes.addSaveData(tag);
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.addSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.addBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.addCannonShipSaveData(tag);
        }
        if ((ship = this) instanceof Shieldable) {
            Shieldable shieldShip = (Shieldable)((Object)ship);
            shieldShip.addShieldShipSaveData(tag);
        }
        tag.putBoolean("Sunken", this.isSunken());
        tag.putBoolean("locked", this.isLocked);
    }

    public void onAboveBubbleCol(boolean bl) {
        if (!this.level().isClientSide) {
            this.isAboveBubbleColumn = true;
            this.bubbleColumnDirectionIsDown = bl;
            if (this.getBubbleTime() == 0) {
                this.setBubbleTime(1200);
            }
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)this.random.nextFloat(), this.getY() + 0.7, this.getZ() + (double)this.random.nextFloat(), 0.0, 0.0, 0.0);
        if (this.random.nextInt(20) == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), this.getSwimSplashSound(), this.getSoundSource(), 1.0f, 0.8f + 0.4f * this.random.nextFloat(), false);
            this.gameEvent((Holder)GameEvent.SPLASH, (Entity)this.getControllingPassenger());
        }
    }

    public <T> T getData(EntityDataAccessor<T> accessor) {
        return (T)this.getEntityData().get(accessor);
    }

    public boolean canAddPassenger(Entity entity) {
        return super.canAddPassenger(entity) && !(entity instanceof Ship) && !((List)SmallShipsConfig.Common.mountBlackList.get()).contains(entity.getEncodeId()) && !this.isLocked() && this.getPassengers().size() < this.getMaxPassengers() && !entity.isPassenger() && entity.getBbWidth() < this.getBbWidth() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal);
    }

    public <T> void setData(EntityDataAccessor<T> accessor, T value) {
        this.getEntityData().set(accessor, value);
    }

    protected void controlBoat() {
        Player player;
        float f;
        float f2;
        float f3;
        Attributes attributes = this.getAttributes();
        float f4 = 1.0f + this.getBiomeModifier() / 100.0f;
        Ship ship = this;
        if (ship instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            f3 = cannonShip.getCannonModifier() / 100.0f;
        } else {
            f3 = 0.0f;
        }
        float f5 = f4 * (1.0f - f3);
        ship = this;
        if (ship instanceof ContainerShip) {
            ContainerShip containerShip = (ContainerShip)ship;
            f2 = containerShip.getContainerModifier() / 100.0f;
        } else {
            f2 = 0.0f;
        }
        float f6 = f5 * (1.0f - f2);
        ship = this;
        if (ship instanceof Paddleable) {
            Paddleable paddleShip = (Paddleable)((Object)ship);
            f = paddleShip.getPaddlingModifier() / 100.0f;
        } else {
            f = 0.0f;
        }
        float speedModifier = f6 * (1.0f + f);
        this.maxSpeed = attributes.maxSpeed / 69.0f * speedModifier;
        float maxRotSp = attributes.maxRotationSpeed * 0.1f + 1.8f;
        float acceleration = attributes.acceleration;
        float rotAcceleration = attributes.rotationAcceleration;
        if (this.level().isClientSide() && !this.isSunken() && (player = this.getDriver()) != null) {
            this.updateControls(((BoatAccessor)((Object)this)).isInputUp(), ((BoatAccessor)((Object)this)).isInputDown(), ((BoatAccessor)((Object)this)).isInputLeft(), ((BoatAccessor)((Object)this)).isInputRight(), player);
        }
        if (this.isInWater() && !this.isShipLeashed() && !this.isSunken() && !this.isLocked()) {
            Sailable sailShip;
            Ship ship2;
            if (this instanceof Paddleable && (ship2 = this) instanceof Sailable) {
                Sailable sailShip2 = (Sailable)((Object)ship2);
                if (this.isForward() && this.getDriver() != null) {
                    this.setPoint = this.maxSpeed * 12.0f / 16.0f * (1.0f + (float)(1 + sailShip2.getSailState()) * 0.1f);
                } else {
                    switch (sailShip2.getSailState()) {
                        case 0: {
                            this.setPoint = 0.0f;
                            break;
                        }
                        case 1: {
                            this.setPoint = this.maxSpeed * 4.0f / 16.0f;
                            break;
                        }
                        case 2: {
                            this.setPoint = this.maxSpeed * 8.0f / 16.0f;
                            break;
                        }
                        case 3: {
                            this.setPoint = this.maxSpeed * 12.0f / 16.0f;
                            break;
                        }
                        case 4: {
                            this.setPoint = this.maxSpeed * 16.0f / 16.0f;
                        }
                    }
                }
            } else {
                ship2 = this;
                if (ship2 instanceof Sailable) {
                    sailShip = (Sailable)((Object)ship2);
                    switch (sailShip.getSailState()) {
                        case 0: {
                            this.setPoint = 0.0f;
                            break;
                        }
                        case 1: {
                            this.setPoint = this.maxSpeed * 4.0f / 16.0f;
                            break;
                        }
                        case 2: {
                            this.setPoint = this.maxSpeed * 8.0f / 16.0f;
                            break;
                        }
                        case 3: {
                            this.setPoint = this.maxSpeed * 12.0f / 16.0f;
                            break;
                        }
                        case 4: {
                            this.setPoint = this.maxSpeed * 16.0f / 16.0f;
                        }
                    }
                }
            }
            this.calculateSpeed(acceleration);
            float rotationSpeed = Kalkuel.subtractToZero(this.getRotSpeed(), this.getVelocityResistance() * 2.5f);
            if (this.getDriver() != null) {
                if (this.isRight() && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration * 1.0f / 8.0f, maxRotSp);
                }
                if (this.isLeft() && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration * 1.0f / 8.0f, -maxRotSp);
                }
            }
            this.setRotSpeed(rotationSpeed);
            ((BoatAccessor)((Object)this)).setDeltaRotation(rotationSpeed);
            this.setYRot(this.getYRot() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            if (this.getDriver() != null) {
                ship2 = this;
                if (ship2 instanceof Sailable) {
                    sailShip = (Sailable)((Object)ship2);
                    sailShip.controlBoatSailShip();
                }
                if ((ship2 = this) instanceof Paddleable) {
                    Paddleable paddleShip = (Paddleable)((Object)ship2);
                    paddleShip.controlBoatPaddleShip();
                }
            }
            this.setDeltaMovement(Kalkuel.calculateMotionX(this.getSpeed(), this.getYRot()), this.getDeltaMovement().y, Kalkuel.calculateMotionZ(this.getSpeed(), this.getYRot()));
        } else {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public boolean isShipLeashed() {
        return this.isLeashed();
    }

    private void calculateSpeed(float acceleration) {
        float speed = this.getSpeed();
        speed = speed < this.setPoint ? Kalkuel.addToSetPoint(speed, acceleration, this.setPoint) : Kalkuel.subtractToZero(speed, this.getVelocityResistance() * 0.8f);
        if (this.isLeft() || this.isRight()) {
            speed *= 1.0f - Mth.abs((float)this.getRotSpeed()) * 0.02f;
        }
        this.setSpeed(speed);
    }

    public CompoundTag getShieldData() {
        return (CompoundTag)this.entityData.get(SHIELD_DATA);
    }

    public void setShieldData(CompoundTag f) {
        this.entityData.set(SHIELD_DATA, (Object)f);
    }

    public float getSpeed() {
        return ((Float)this.entityData.get(SPEED)).floatValue();
    }

    public float getRotSpeed() {
        return ((Float)this.entityData.get(ROT_SPEED)).floatValue();
    }

    public void setSpeed(float f) {
        this.entityData.set(SPEED, (Object)Float.valueOf(f));
    }

    public void setRotSpeed(float f) {
        this.entityData.set(ROT_SPEED, (Object)Float.valueOf(f));
    }

    public void setForward(boolean forward) {
        this.entityData.set(FORWARD, (Object)forward);
    }

    public void setBackward(boolean backward) {
        this.entityData.set(BACKWARD, (Object)backward);
    }

    public void setLeft(boolean left) {
        this.entityData.set(LEFT, (Object)left);
    }

    public void setRight(boolean right) {
        this.entityData.set(RIGHT, (Object)right);
    }

    public boolean isForward() {
        if (this.getControllingPassenger() == null) {
            return false;
        }
        return (Boolean)this.entityData.get(FORWARD);
    }

    public boolean isBackward() {
        if (this.getControllingPassenger() == null) {
            return false;
        }
        return (Boolean)this.entityData.get(BACKWARD);
    }

    public boolean isLeft() {
        return (Boolean)this.entityData.get(LEFT);
    }

    public boolean isRight() {
        return (Boolean)this.entityData.get(RIGHT);
    }

    public float getBiomeModifier() {
        boolean warmType;
        BiomeModifierType shipBiomeType = this.getBiomeModifierType();
        if (shipBiomeType == BiomeModifierType.NONE) {
            return 0.0f;
        }
        BlockPos pos = new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ());
        int tmp = ((Biome)this.getCommandSenderWorld().getBiome(pos).value()).getWaterColor();
        float modifier = ((Double)SmallShipsConfig.Common.shipGeneralBiomeModifier.get()).floatValue();
        boolean coldBiomes = tmp < 4100000;
        boolean warmBiomes = tmp > 4300000;
        boolean neutralBiomes = !coldBiomes && !warmBiomes;
        boolean coldType = shipBiomeType == BiomeModifierType.COLD;
        boolean neutralType = shipBiomeType == BiomeModifierType.NEUTRAL;
        boolean bl = warmType = shipBiomeType == BiomeModifierType.WARM;
        if (coldBiomes && coldType || warmBiomes && warmType || neutralBiomes && neutralType) {
            return modifier;
        }
        if (coldBiomes && warmType || warmBiomes && coldType || (coldBiomes || warmBiomes) && neutralType) {
            return -modifier;
        }
        if (neutralBiomes && warmType || neutralBiomes && coldType) {
            return -modifier / 4.0f;
        }
        return 0.0f;
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!this.isLocked()) {
            Shieldable shieldShip;
            Bannerable bannerShip;
            Sailable sailShip;
            Cannonable cannonShip;
            if (this.interactWithNameTag(player)) {
                return InteractionResult.SUCCESS;
            }
            if (this.interactIronNuggets(player)) {
                return InteractionResult.SUCCESS;
            }
            Ship ship = this;
            if (ship instanceof Cannonable && (cannonShip = (Cannonable)((Object)ship)).interactCannon(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            ship = this;
            if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).interactSail(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            ship = this;
            if (ship instanceof Bannerable && (bannerShip = (Bannerable)((Object)ship)).interactBanner(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            ship = this;
            if (ship instanceof Shieldable && (shieldShip = (Shieldable)((Object)ship)).interactShield(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            return super.interact(player, interactionHand);
        }
        return InteractionResult.PASS;
    }

    private boolean interactWithNameTag(@NotNull Player player) {
        if (player.getMainHandItem().is(Items.NAME_TAG) && player.getMainHandItem().has(DataComponents.CUSTOM_NAME) && !player.getCommandSenderWorld().isClientSide) {
            this.setCustomName(player.getMainHandItem().getHoverName());
            this.setCustomNameVisible(false);
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
            }
            return true;
        }
        return false;
    }

    private boolean interactIronNuggets(@NotNull Player player) {
        if (this.getDamage() > 0.0f && player.getMainHandItem().is(Items.IRON_NUGGET) && player.getInventory().hasAnyMatching(stack -> stack.is(ItemTags.PLANKS))) {
            this.repairShip(5 + this.level().random.nextInt(5));
            if (!player.isCreative()) {
                player.getMainHandItem().shrink(1);
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack itemStack = player.getInventory().getItem(i);
                    if (!itemStack.is(ItemTags.PLANKS)) continue;
                    itemStack.shrink(1);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void repairShip(int repairAmount) {
        this.getCommandSenderWorld().playSound(null, this.getX(), this.getY() + 1.0, this.getZ(), SoundEvents.WOOD_HIT, SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * this.getCommandSenderWorld().getRandom().nextFloat());
        this.getCommandSenderWorld().playSound(null, this.getX(), this.getY() + 2.0, this.getZ(), SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f + 0.2f * this.getCommandSenderWorld().getRandom().nextFloat());
        float newDamage = this.getDamage() - (float)repairAmount;
        if (newDamage < 0.0f) {
            newDamage = 0.0f;
        }
        this.setDamage(newDamage);
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity livingEntity) {
        Sailable sailShip;
        Ship ship = this;
        if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).getSailState() != 0) {
            sailShip.toggleSail();
        }
        return super.getDismountLocationForPassenger(livingEntity);
    }

    protected void addPassenger(Entity entity) {
        if (this.level().isClientSide() && ((Boolean)SmallShipsConfig.Client.shipGeneralCameraAutoThirdPerson.get()).booleanValue() && Objects.equals(Minecraft.getInstance().player, entity)) {
            this.previousCameraType = Minecraft.getInstance().options.getCameraType();
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
        }
        super.addPassenger(entity);
    }

    protected void removePassenger(Entity entity) {
        if (this.level().isClientSide() && ((Boolean)SmallShipsConfig.Client.shipGeneralCameraAutoThirdPerson.get()).booleanValue() && Objects.equals(Minecraft.getInstance().player, entity)) {
            Minecraft.getInstance().options.setCameraType(this.previousCameraType);
        }
        super.removePassenger(entity);
    }

    public void setSunken(boolean sunken) {
        this.entityData.set(SUNKEN, (Object)sunken);
    }

    public boolean isSunken() {
        return (Boolean)this.entityData.get(SUNKEN);
    }

    private void updateWaveAngle() {
        this.prevWaveAngle = this.waveAngle;
        this.waveAngle = (float)Math.sin(this.getWaveSpeed() * (float)this.tickCount) * this.getWaveFactor();
    }

    private float getWaveFactor() {
        return this.level().isRaining() ? 3.0f : 1.25f;
    }

    private float getWaveSpeed() {
        return this.level().isRaining() ? 0.12f : 0.03f;
    }

    public float getWaveAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevWaveAngle, (float)this.waveAngle);
    }

    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        return attributes;
    }

    public void setCannonKeyPressed(boolean b) {
        this.cannonKeyPressed = b;
    }

    public boolean isCannonKeyPressed() {
        return this.cannonKeyPressed;
    }

    @NotNull
    public AABB getBoundingBoxForCulling() {
        return this.getBoundingBox().inflate(5.0);
    }

    public abstract int getMaxPassengers();

    @NotNull
    public abstract Item getDropItem();

    public abstract BiomeModifierType getBiomeModifierType();

    public abstract CompoundTag createDefaultAttributes();

    public float getVelocityResistance() {
        return 0.007f;
    }

    protected void waterSplash() {
    }

    private void updateShipAmbience(boolean isSwimming) {
        if (isSwimming && this.isInWater()) {
            this.waterSplash();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_SWIM, this.getSoundSource(), 0.05f, 0.8f + 0.4f * this.random.nextFloat());
        }
    }

    private void updateWaterMobs() {
        if (!this.getCommandSenderWorld().isClientSide()) {
            double radius = (Double)SmallShipsConfig.Common.waterAnimalFleeRadius.get();
            List waterAnimals = this.level().getEntitiesOfClass(WaterAnimal.class, new AABB(this.getX() - radius, this.getY() - radius, this.getZ() - radius, this.getX() + radius, this.getY() + radius, this.getZ() + radius));
            for (WaterAnimal waterAnimal : waterAnimals) {
                if (this.tickCount % 20 != 0) continue;
                this.fleeEntity((Mob)waterAnimal);
            }
        }
    }

    private void fleeEntity(Mob entity) {
        double fleeDistance = (Double)SmallShipsConfig.Common.waterAnimalFleeDistance.get();
        double fleeSpeed = (Double)SmallShipsConfig.Common.waterAnimalFleeSpeed.get();
        Vec3 vecBoat = new Vec3(this.getX(), this.getY(), this.getZ());
        Vec3 vecEntity = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        Vec3 fleeDir = vecEntity.subtract(vecBoat);
        fleeDir = fleeDir.normalize();
        Vec3 fleePos = new Vec3(vecEntity.x + fleeDir.x * fleeDistance, vecEntity.y + fleeDir.y * fleeDistance, vecEntity.z + fleeDir.z * fleeDistance);
        entity.getNavigation().moveTo(fleePos.x, fleePos.y, fleePos.z, fleeSpeed);
    }

    protected void floatUp() {
        if (this.isEyeInFluid(FluidTags.WATER)) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.2, 0.0));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(DamageSource damageSource, float f) {
        block9: {
            if (this.isInvulnerableTo(damageSource)) {
                return false;
            }
            if (this.getCommandSenderWorld().isClientSide() || this.isRemoved()) break block9;
            v0 = this.getDamage();
            var4_3 = this;
            if (var4_3 instanceof Shieldable) {
                shieldShip = (Shieldable)var4_3;
                v1 = shieldShip.getDamageModifier();
            } else {
                v1 = 1.0f;
            }
            this.setDamage(v0 + f * v1);
            this.markHurt();
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, damageSource.getEntity());
            var5_6 = damageSource.getEntity();
            if (!(var5_6 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var5_6;
            if (player.getAbilities().instabuild && player.isCrouching()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = bl = false;
            }
            if (this.getDamage() > this.getAttributes().maxHealth) {
                if (this.isSunken() && this.sunkenTime > 200) {
                    this.destroy(this.getCommandSenderWorld().damageSources().drown());
                } else {
                    this.setSunken(true);
                }
            }
            if (bl) {
                this.discard();
            }
            return true;
        }
        return true;
    }

    private void knockBack(Entity entity, double speed, AABB boundingBox) {
        double d0 = (boundingBox.minX + boundingBox.maxX) / 2.0;
        double d1 = (boundingBox.minZ + boundingBox.maxZ) / 2.0;
        if (entity instanceof LivingEntity) {
            double d2 = entity.getX() - d0;
            double d3 = entity.getZ() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.setDeltaMovement(this.getDeltaMovement().add(d2 / d4 * (1.0 + speed * 1.1), 0.0, d3 / d4 * (1.0 + speed * 1.1)));
        }
    }

    private void updateCollision(boolean isCruising) {
        if (isCruising && this.canDoKnockBack() && ((Boolean)SmallShipsConfig.Common.shipGeneralCollisionKnockBack.get()).booleanValue()) {
            AABB boundingBox = this.getBoundingBox().inflate(2.25, 1.25, 2.25).move(0.0, -2.0, 0.0);
            List list = this.level().getEntities((Entity)this, boundingBox, EntitySelector.pushableBy((Entity)this));
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity) || this.getPassengers().contains(entity)) continue;
                this.knockBack(entity, this.getSpeed(), boundingBox);
                this.collisionDamage(entity, this.getSpeed());
            }
        }
    }

    public boolean canDoKnockBack() {
        return true;
    }

    public boolean canDoCollisionDamage() {
        return true;
    }

    private void collisionDamage(Entity entity, float speed) {
        if (this.getControllingPassenger() != null) {
            float damage;
            if (this.getControllingPassenger().getTeam() != null && this.getControllingPassenger().getTeam().isAlliedTo((Team)entity.getTeam()) && !this.getControllingPassenger().getTeam().isAllowFriendlyFire()) {
                return;
            }
            if (this.canDoCollisionDamage() && speed > 0.1f && (damage = speed * ((Double)SmallShipsConfig.Common.shipGeneralCollisionDamage.get()).floatValue()) > 0.0f) {
                entity.hurt(this.getCommandSenderWorld().damageSources().mobAttack(this.getControllingPassenger()), damage);
            }
        }
    }

    @Nullable
    public Player getDriver() {
        List passengers = this.getPassengers();
        if (passengers.isEmpty()) {
            return null;
        }
        Object e = passengers.get(0);
        if (e instanceof Player) {
            Player player = (Player)e;
            if (this.getCommandSenderWorld().isClientSide) {
                Minecraft minecraft = Minecraft.getInstance();
                LocalPlayer instancePlayer = minecraft.player;
                return player.equals((Object)instancePlayer) ? player : null;
            }
            return (Player)passengers.get(0);
        }
        return null;
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, @Nullable Player player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.getCommandSenderWorld().isClientSide && needsUpdate && player != null) {
            ModPackets.clientSendPacket(new ServerboundUpdateShipControlPacket(forward, backward, left, right));
        }
    }

    public void destroy(@NotNull DamageSource damageSource) {
        super.destroy(damageSource);
        if (this.getCommandSenderWorld().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Ship ship = this;
            if (ship instanceof ContainerShip) {
                ContainerShip containerShip = (ContainerShip)ship;
                containerShip.chestVehicleDestroyed(damageSource, this.getCommandSenderWorld(), (Entity)this);
            }
            if ((ship = this) instanceof Cannonable) {
                Cannonable cannonableShip = (Cannonable)((Object)ship);
                cannonableShip.cannonShipDestroyed(this.getCommandSenderWorld(), this);
            }
        }
        this.discard();
    }

    public static enum BiomeModifierType {
        NONE,
        COLD,
        NEUTRAL,
        WARM;

    }
}

