/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.mixin.controlling.BoatAccessor;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;

public interface Paddleable
extends Ability {
    default public void tickPaddleShip() {
    }

    default public float getPaddlingModifier() {
        return this.self().isForward() ? ((Double)SmallShipsConfig.Common.shipGeneralPaddlingModifier.get()).floatValue() : 0.0f;
    }

    default public void controlBoatPaddleShip() {
        if (this.self().isControlledByLocalInstance()) {
            this.self().setPaddleState(this.shouldPaddleLeft(), this.shouldPaddleRight());
        }
    }

    default public void animatePaddle(PaddleSide side, ModelPart modelPart, float f) {
        float f2 = this.self().getRowingTime(side.ordinal(), f);
        float xRotChange = Mth.clampedLerp((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.sin((float)(-f2)) + 1.0f) / 2.0f));
        float yRotChange = Mth.clampedLerp((float)-0.7853982f, (float)0.7853982f, (float)((Mth.sin((float)(-f2 + 1.0f)) + 1.0f) / 2.0f));
        if (side.equals((Object)PaddleSide.LEFT)) {
            modelPart.yRot = -yRotChange;
            modelPart.xRot = 4.55f - ((float)Math.PI - xRotChange);
        } else {
            modelPart.yRot = (float)Math.PI + yRotChange;
            modelPart.xRot = 4.5415926f + xRotChange;
        }
    }

    private boolean shouldPaddleLeft() {
        return ((BoatAccessor)((Object)this.self())).isInputRight() && !((BoatAccessor)((Object)this.self())).isInputLeft() || ((BoatAccessor)((Object)this.self())).isInputUp();
    }

    private boolean shouldPaddleRight() {
        return ((BoatAccessor)((Object)this.self())).isInputLeft() && !((BoatAccessor)((Object)this.self())).isInputRight() || ((BoatAccessor)((Object)this.self())).isInputUp();
    }

    public static enum PaddleSide {
        LEFT,
        RIGHT;

    }
}

