/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.venturecraft.gliders.VCGliders;
import net.venturecraft.gliders.client.model.GliderModel;
import net.venturecraft.gliders.client.model.ModelRegistry;
import net.venturecraft.gliders.client.model.XWingModel;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.util.GliderUtil;

public class PlayerGliderLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation COPPER_EMBED = VCGliders.id("textures/entity/glider/copper_overlay.png");
    private static final ResourceLocation NETHER_UPGRADE = VCGliders.id("textures/entity/glider/nether_upgrade_overlay.png");
    private static final ResourceLocation COPPER_EMBED_CHARGED = VCGliders.id("textures/entity/glider/copper_overlay_charged.png");
    private static final ResourceLocation XWING_TEXTURE = VCGliders.id("textures/entity/glider/xwing.png");
    public static GliderModel gliderModel;
    public static XWingModel<Entity> xWingModel;

    public PlayerGliderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
        gliderModel = new GliderModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelRegistry.GLIDER));
        xWingModel = new XWingModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelRegistry.X_WING));
    }

    public static ResourceLocation getGliderTexture(ItemStack stack) {
        if (stack.getDisplayName().getString().contains("xwing")) {
            return XWING_TEXTURE;
        }
        ResourceLocation itemLoc = GliderUtil.getItemId(stack.getItem());
        return ResourceLocation.fromNamespaceAndPath((String)itemLoc.getNamespace(), (String)("textures/entity/glider/" + itemLoc.getPath() + ".png"));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int p_117351_, T living, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        if (living.isInvisibleTo((Player)Minecraft.getInstance().player)) {
            return;
        }
        ItemStack stack = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)living);
        if (GliderUtil.isGlidingWithActiveGlider(living)) {
            poseStack.pushPose();
            if (stack.getDisplayName().getString().contains("xwing")) {
                poseStack.translate(0.0, -1.9, -0.5);
                xWingModel.setupAnim((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).tickCount, 0.0f, 0.0f);
                xWingModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PlayerGliderLayer.getGliderTexture(stack))), p_117351_, OverlayTexture.NO_OVERLAY, -1);
            } else {
                poseStack.translate(0.0, -1.8, 0.0);
                gliderModel.setupAnim((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).tickCount, 0.0f, 0.0f);
                gliderModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PlayerGliderLayer.getGliderTexture(stack))), p_117351_, OverlayTexture.NO_OVERLAY, -1);
                if (GliderItem.hasCopperUpgrade(stack)) {
                    gliderModel.setupAnim((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).tickCount, 0.0f, 0.0f);
                    gliderModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.eyes((ResourceLocation)(GliderItem.hasBeenStruck(stack) ? COPPER_EMBED_CHARGED : COPPER_EMBED))), p_117351_, OverlayTexture.NO_OVERLAY, -1);
                }
                if (GliderItem.hasNetherUpgrade(stack)) {
                    gliderModel.setupAnim((Entity)living, 0.0f, 0.0f, ((LivingEntity)living).tickCount, 0.0f, 0.0f);
                    gliderModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)NETHER_UPGRADE)), p_117351_, OverlayTexture.NO_OVERLAY, -1);
                }
            }
            poseStack.popPose();
        }
    }
}

