/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.client.model;

import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;

public class GliderModel
extends HierarchicalModel {
    public static final AnimationDefinition CLOSING = AnimationDefinition.Builder.withLength((float)0.25f).addAnimation("CentreBrace", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.041666668f, KeyframeAnimations.posVec((float)0.0f, (float)-3.05f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.083333336f, KeyframeAnimations.posVec((float)0.0f, (float)-7.37f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.125f, KeyframeAnimations.posVec((float)0.0f, (float)-11.63f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.16666667f, KeyframeAnimations.posVec((float)0.0f, (float)-14.54f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.posVec((float)0.0f, (float)-17.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LArm", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-85.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LBrace", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-87.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RArm", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)85.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RBrace", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)87.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LMain", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)60.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RMain", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-60.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LStrut", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-132.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RStrut", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)132.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("Glider", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.041666668f, KeyframeAnimations.posVec((float)0.0f, (float)1.78f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.125f, KeyframeAnimations.posVec((float)0.0f, (float)6.1f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.16666667f, KeyframeAnimations.posVec((float)0.0f, (float)7.8f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.20833333f, KeyframeAnimations.posVec((float)0.0f, (float)8.5f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.posVec((float)0.0f, (float)9.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();
    public static final AnimationDefinition OPENING = AnimationDefinition.Builder.withLength((float)30.0f).addAnimation("CentreBrace", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.posVec((float)0.0f, (float)-17.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.16666667f, KeyframeAnimations.posVec((float)0.0f, (float)-15.35f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.20833333f, KeyframeAnimations.posVec((float)0.0f, (float)-10.46f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.25f, KeyframeAnimations.posVec((float)0.0f, (float)-3.21f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.posVec((float)0.0f, (float)2.4f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.33333334f, KeyframeAnimations.posVec((float)0.0f, (float)4.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.375f, KeyframeAnimations.posVec((float)0.0f, (float)3.66f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.41666666f, KeyframeAnimations.posVec((float)0.0f, (float)2.29f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.45833334f, KeyframeAnimations.posVec((float)0.0f, (float)0.76f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.posVec((float)0.0f, (float)-0.1f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LArm", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-85.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-5.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LBrace", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-87.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)20.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RArm", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)85.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RBrace", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)87.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-20.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LMain", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)60.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RMain", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-60.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LStrut", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-132.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)12.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RStrut", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)132.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-12.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("Glider", new AnimationChannel(AnimationChannel.Targets.POSITION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.posVec((float)0.0f, (float)9.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.29166666f, KeyframeAnimations.posVec((float)0.0f, (float)1.78f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.posVec((float)0.0f, (float)1.78f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("Glider", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.125f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.5f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(1.0f, KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(2.2916667f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(5.25f, KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(9.583333f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(13.666667f, KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(18.0f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(22.75f, KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(27.083334f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(30.0f, KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(34.333332f, KeyframeAnimations.degreeVec((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();
    private final ModelPart root;

    public GliderModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Glider = partdefinition.addOrReplaceChild("Glider", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)26.8f, (float)0.0f));
        PartDefinition CentreBrace = Glider.addOrReplaceChild("CentreBrace", CubeListBuilder.create().texOffs(75, 17).addBox(-1.0f, -0.1f, -8.0f, 2.0f, 1.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition RMain = Glider.addOrReplaceChild("RMain", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-17.0f, (float)0.0f));
        PartDefinition RMain_r1 = RMain.addOrReplaceChild("RMain_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-13.0f, 0.0f, -0.25f, 13.0f, 0.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition RStrut = RMain.addOrReplaceChild("RStrut", CubeListBuilder.create(), PartPose.offset((float)-12.0f, (float)5.0f, (float)0.0f));
        PartDefinition RExtension_r1 = RStrut.addOrReplaceChild("RExtension_r1", CubeListBuilder.create().texOffs(0, 28).mirror().addBox(-6.1166f, -0.0788f, -0.25f, 6.0f, 0.0f, 19.0f, new CubeDeformation(-0.01f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition RStruts_r1 = RStrut.addOrReplaceChild("RStruts_r1", CubeListBuilder.create().texOffs(0, 50).addBox(-0.1166f, -0.5788f, -0.25f, 12.0f, 1.0f, 16.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition RArm = RMain.addOrReplaceChild("RArm", CubeListBuilder.create(), PartPose.offset((float)-12.0f, (float)5.0f, (float)0.0f));
        PartDefinition RPole_r1 = RArm.addOrReplaceChild("RPole_r1", CubeListBuilder.create().texOffs(48, 25).addBox(-13.5f, -0.5f, -0.25f, 1.0f, 1.0f, 25.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)12.0f, (float)-5.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition RBack_r1 = RArm.addOrReplaceChild("RBack_r1", CubeListBuilder.create().texOffs(49, 87).mirror().addBox(0.0f, -0.0272f, 15.75f, 0.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition RMain_r2 = RArm.addOrReplaceChild("RMain_r2", CubeListBuilder.create().texOffs(58, 64).mirror().addBox(-1.9134f, 4.5922f, -0.25f, 1.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition RBrace = RArm.addOrReplaceChild("RBrace", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)2.4f, (float)0.0f));
        PartDefinition RBrace_r1 = RBrace.addOrReplaceChild("RBrace_r1", CubeListBuilder.create().texOffs(0, 67).mirror().addBox(-0.2687f, -0.5127f, -16.0f, 4.0f, 1.0f, 16.0f, new CubeDeformation(-0.02f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition LMain = Glider.addOrReplaceChild("LMain", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-17.0f, (float)0.0f));
        PartDefinition LMain_r1 = LMain.addOrReplaceChild("LMain_r1", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, -0.25f, 13.0f, 0.0f, 25.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition LStrut = LMain.addOrReplaceChild("LStrut", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)5.0f, (float)-7.75f));
        PartDefinition LExtension_r1 = LStrut.addOrReplaceChild("LExtension_r1", CubeListBuilder.create().texOffs(12, 28).mirror().addBox(0.1166f, -0.0788f, -0.25f, 6.0f, 0.0f, 19.0f, new CubeDeformation(-0.01f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition LStruts_r1 = LStrut.addOrReplaceChild("LStruts_r1", CubeListBuilder.create().texOffs(51, 0).addBox(-11.8834f, -0.5788f, -0.25f, 12.0f, 1.0f, 16.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition LArm = LMain.addOrReplaceChild("LArm", CubeListBuilder.create(), PartPose.offset((float)12.0f, (float)5.0f, (float)0.0f));
        PartDefinition LPole_r1 = LArm.addOrReplaceChild("LPole_r1", CubeListBuilder.create().texOffs(48, 25).mirror().addBox(12.5f, -0.5f, -0.25f, 1.0f, 1.0f, 25.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-12.0f, (float)-5.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition LBack_r1 = LArm.addOrReplaceChild("LBack_r1", CubeListBuilder.create().texOffs(49, 87).addBox(0.0f, -0.0272f, 15.75f, 0.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(58, 64).addBox(-1.0f, -0.0272f, -0.25f, 1.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.75f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition LBrace = LArm.addOrReplaceChild("LBrace", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)2.4f, (float)0.0f));
        PartDefinition LBrace_r1 = LBrace.addOrReplaceChild("LBrace_r1", CubeListBuilder.create().texOffs(0, 67).addBox(-3.7313f, -0.5127f, -16.0f, 4.0f, 1.0f, 16.0f, new CubeDeformation(-0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof LivingEntity) {
            AnimationState animation;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!GliderData.getIsGliding(livingEntity)) {
                return;
            }
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (GliderUtil.isGlidingWithActiveGlider(livingEntity) && (animation = GliderData.getAnimation(GliderData.AnimationStates.GLIDER_OPENING)) != null) {
                this.animate(animation, OPENING, ageInTicks);
            }
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

