/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.client.model;

import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;

public class XWingModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final AnimationDefinition OPEN_XWING = AnimationDefinition.Builder.withLength((float)26.0f).addAnimation("LW1", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)2.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.41666666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-17.66f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.7083333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-17.5f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("LW2", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-5.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.41666666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)17.66f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.6666667f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)15.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RW1", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-2.5f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.41666666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)18.27f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.6666667f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)15.0f), AnimationChannel.Interpolations.CATMULLROM)})).addAnimation("RW2", new AnimationChannel(AnimationChannel.Targets.ROTATION, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)5.0f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.41666666f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-17.66f), AnimationChannel.Interpolations.CATMULLROM), new Keyframe(0.7083333f, KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-15.0f), AnimationChannel.Interpolations.CATMULLROM)})).build();
    private final ModelPart bone;
    private final ModelPart bone4;
    private final ModelPart bone8;
    private final ModelPart LW1;
    private final ModelPart LW2;
    private final ModelPart RW1;
    private final ModelPart RW2;
    private final ModelPart root;

    public XWingModel(ModelPart root) {
        this.root = root;
        this.bone = root.getChild("bone");
        this.bone4 = root.getChild("bone4");
        this.bone8 = root.getChild("bone8");
        this.LW1 = root.getChild("LW1");
        this.LW2 = root.getChild("LW2");
        this.RW1 = root.getChild("RW1");
        this.RW2 = root.getChild("RW2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bone7 = bone.addOrReplaceChild("bone7", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone4 = partdefinition.addOrReplaceChild("bone4", CubeListBuilder.create().texOffs(62, 34).addBox(-3.0f, -1.5f, -3.5f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(23, 10).addBox(-3.0f, 1.5f, -10.5f, 6.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(55, 22).addBox(1.75f, 0.5f, -10.5f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(55, 22).addBox(-2.75f, 0.5f, -10.5f, 1.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.5f, (float)5.5f));
        PartDefinition bone5 = bone4.addOrReplaceChild("bone5", CubeListBuilder.create().texOffs(38, 51).addBox(-1.0f, 0.0f, -7.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(24, 39).addBox(-1.25f, 1.0f, -7.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(24, 39).addBox(-5.75f, 1.0f, -7.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(38, 51).addBox(-6.0f, 0.0f, -7.0f, 1.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(13, 58).addBox(-6.0f, 0.0f, -8.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(54, 0).addBox(-5.0f, 0.25f, -7.0f, 4.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.5f, (float)-3.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bone6 = bone4.addOrReplaceChild("bone6", CubeListBuilder.create().texOffs(23, 0).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(-1.25f, 1.0f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(-5.75f, 1.0f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(23, 0).addBox(-6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(61, 61).addBox(-6.0f, 0.0f, 2.0f, 6.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(-5.0f, 0.25f, 0.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-1.5f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone8 = partdefinition.addOrReplaceChild("bone8", CubeListBuilder.create().texOffs(13, 53).addBox(-3.5f, -7.0f, -6.0f, 7.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(46, 34).addBox(-1.0f, -7.5f, -18.0f, 2.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(46, 34).addBox(-1.0f, -3.5f, -18.0f, 2.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(11, 11).addBox(-2.0f, -7.5f, -19.0f, 4.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 17).addBox(-2.0f, -5.5f, -22.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 22).addBox(-4.0f, -8.0f, 5.0f, 8.0f, 5.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(11, 0).addBox(-2.0f, -8.0f, 16.5f, 4.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.5f, -7.5f, 17.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(57, 8).addBox(4.0f, -10.0f, 6.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(57, 8).addBox(-7.0f, -10.0f, 6.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(57, 8).addBox(4.0f, -5.0f, 6.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(57, 8).addBox(-7.0f, -5.0f, 6.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(5, 5).addBox(5.0f, -9.0f, 5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 5).addBox(-6.0f, -9.0f, 5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 5).addBox(5.0f, -4.0f, 5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(5, 5).addBox(-6.0f, -4.0f, 5.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(4.5f, -9.5f, 5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-6.5f, -9.5f, 5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(4.5f, -4.5f, 5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-6.5f, -4.5f, 5.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(4.5f, -9.5f, 12.0f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(-6.5f, -9.5f, 12.0f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(4.5f, -4.5f, 12.0f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(24, 51).addBox(-6.5f, -4.5f, 12.0f, 2.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(28, 22).addBox(-4.0f, -9.0f, 6.0f, 8.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 53).addBox(2.5f, -9.5f, 6.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(1.0f, -9.5f, 7.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(1.0f, -3.5f, -5.0f, 1.0f, 1.0f, 21.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-2.0f, -9.5f, 7.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-2.0f, -3.5f, -5.0f, 1.0f, 1.0f, 21.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-1.0f, -9.25f, 10.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-1.0f, -9.25f, 7.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-1.0f, -9.25f, 13.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 53).addBox(-3.5f, -9.5f, 6.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 41).addBox(-3.5f, -5.0f, -5.0f, 7.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bone2 = bone8.addOrReplaceChild("bone2", CubeListBuilder.create().texOffs(27, 34).addBox(-3.0f, -3.0f, -13.0f, 3.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(41, 61).addBox(-4.0f, -3.0f, -7.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.5f, (float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.1571f, (float)0.0f));
        PartDefinition bone11 = bone8.addOrReplaceChild("bone11", CubeListBuilder.create().texOffs(27, 34).addBox(0.0f, -3.0f, -13.0f, 3.0f, 4.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(41, 61).addBox(3.0f, -3.0f, -7.0f, 1.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-4.0f, (float)-6.0f, (float)0.0f, (float)-0.1571f, (float)0.0f));
        PartDefinition bone3 = bone8.addOrReplaceChild("bone3", CubeListBuilder.create().texOffs(50, 61).addBox(-4.0f, -2.0f, 0.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-2.5f, (float)-18.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone12 = bone3.addOrReplaceChild("bone12", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone15 = bone8.addOrReplaceChild("bone15", CubeListBuilder.create().texOffs(50, 61).addBox(-4.0f, 0.0f, 0.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-7.5f, (float)-18.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone16 = bone15.addOrReplaceChild("bone16", CubeListBuilder.create().texOffs(50, 61).addBox(-4.0f, 0.0f, -3.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition bone9 = bone8.addOrReplaceChild("bone9", CubeListBuilder.create().texOffs(11, 5).addBox(-2.0f, -3.0f, 0.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 5).addBox(-2.0f, -3.61f, 0.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 5).addBox(-2.0f, -3.11f, 1.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-22.0f, (float)-0.9828f, (float)0.0f, (float)0.0f));
        PartDefinition bone10 = bone8.addOrReplaceChild("bone10", CubeListBuilder.create().texOffs(11, 5).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 5).addBox(-2.0f, 0.61f, 0.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(11, 5).addBox(-2.0f, 0.11f, 1.0f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)-22.0f, (float)0.9828f, (float)0.0f, (float)0.0f));
        PartDefinition bone13 = bone8.addOrReplaceChild("bone13", CubeListBuilder.create().texOffs(0, 39).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-4.0f, 0.0f, 0.4142f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)5.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bone17 = bone8.addOrReplaceChild("bone17", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone14 = bone8.addOrReplaceChild("bone14", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-11.0f, (float)8.0f));
        PartDefinition LW1 = partdefinition.addOrReplaceChild("LW1", CubeListBuilder.create().texOffs(23, 0).addBox(0.0f, -0.5f, -4.0f, 11.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(48, 48).addBox(11.0f, -1.0f, -5.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(11.0f, -1.0f, -14.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 10).addBox(11.5f, -0.5f, -16.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(13.0f, -0.5f, -4.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)18.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition LW2 = partdefinition.addOrReplaceChild("LW2", CubeListBuilder.create().texOffs(23, 0).addBox(0.0f, -0.5f, -4.0f, 11.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(48, 48).addBox(11.0f, -1.0f, -5.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(11.0f, -1.0f, -14.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 10).addBox(11.5f, -0.5f, -16.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(13.0f, -0.5f, -4.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)18.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition RW1 = partdefinition.addOrReplaceChild("RW1", CubeListBuilder.create().texOffs(23, 0).addBox(-11.0f, -0.5f, -4.0f, 11.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(48, 48).addBox(-13.0f, -1.0f, -5.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-13.0f, -1.0f, -14.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 10).addBox(-12.5f, -0.5f, -16.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-14.0f, -0.5f, -4.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)18.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition RW2 = partdefinition.addOrReplaceChild("RW2", CubeListBuilder.create().texOffs(23, 0).addBox(-11.0f, -0.5f, -4.0f, 11.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(48, 48).addBox(-13.0f, -1.0f, -5.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 13).addBox(-13.0f, -1.0f, -14.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(44, 10).addBox(-12.5f, -0.5f, -16.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-14.0f, -0.5f, -4.0f, 1.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)18.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.root().getAllParts().forEach(ModelPart::resetPose);
            if (GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
                this.animate(GliderData.getAnimation(GliderData.AnimationStates.GLIDER_OPENING), OPEN_XWING, ageInTicks);
            }
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

