/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.client.sound;

import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class MovingSound
extends AbstractTickableSoundInstance {
    private final Object entity;
    private final Supplier<Boolean> stopCondition;
    private boolean donePlaying = false;

    public MovingSound(Object object, SoundEvent soundIn, SoundSource categoryIn, boolean repeat, Supplier<Boolean> stopCondition, float volumeSfx, RandomSource randomSource) {
        super(soundIn, categoryIn, randomSource);
        this.entity = object;
        this.stopCondition = stopCondition;
        this.looping = repeat;
        this.volume = volumeSfx;
    }

    public void tick() {
        Object object = this.entity;
        if (object instanceof Entity) {
            Entity entityObject = (Entity)object;
            if (this.stopCondition.get().booleanValue() || !entityObject.isAlive()) {
                this.setDonePlaying();
            }
            this.x = (float)entityObject.getX();
            this.y = (float)entityObject.getY();
            this.z = (float)entityObject.getZ();
        }
        if ((object = this.entity) instanceof BlockEntity) {
            BlockEntity tileObject = (BlockEntity)object;
            BlockPos pos = tileObject.getBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
        }
    }

    public void setDonePlaying() {
        this.looping = false;
        this.donePlaying = true;
        this.delay = 0;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isStopped() {
        return this.donePlaying;
    }

    public int getDelay() {
        return this.delay;
    }

    @NotNull
    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.LINEAR;
    }
}

