/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.threetag.palladiumcore.event.EntityEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import net.threetag.palladiumcore.event.PlayerEvents;
import net.venturecraft.gliders.common.GliderDamageSource;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;
import org.jetbrains.annotations.NotNull;

public class GliderEvents
implements PlayerEvents.Tracking,
EntityEvents.LightningStrike,
LivingEntityEvents.ItemUse {
    public static void initEvents() {
        GliderEvents instance = new GliderEvents();
        EntityEvents.LIGHTNING_STRIKE.register((Object)instance);
        LivingEntityEvents.ITEM_USE_START.register((Object)instance);
        LivingEntityEvents.ITEM_USE_TICK.register((Object)instance);
        LivingEntityEvents.ITEM_USE_STOP.register((Object)instance);
        PlayerEvents.START_TRACKING.register((Object)instance);
    }

    public void lightningStrike(List<Entity> entities, LightningBolt lightningBolt) {
        for (Entity entity : entities) {
            Level level;
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)player);
            boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
            boolean isGliding = GliderUtil.isGlidingWithActiveGlider((LivingEntity)player);
            if (!hasCopperMod && isGliding) {
                GliderItem.setBroken(chestItem, true);
                return;
            }
            if (!hasCopperMod || !isGliding) continue;
            GliderItem.setStruck(chestItem, true);
            if (!GliderItem.hasBeenStruck(chestItem) || !((level = player.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            player.hurt(GliderDamageSource.getSource(serverLevel, GliderDamageSource.ZAP_EXPERIMENT), 2.0f);
        }
    }

    public EventResult livingEntityItemUse(LivingEntity entity, @NotNull ItemStack stack, AtomicInteger duration) {
        return GliderUtil.isGlidingWithActiveGlider(entity) ? EventResult.cancel() : EventResult.pass();
    }

    public void playerTracking(Player tracker, Entity trackedEntity) {
        if (trackedEntity instanceof Player) {
            Player trackedPlayer = (Player)trackedEntity;
            if (tracker instanceof ServerPlayer) {
                ServerPlayer trackerPlayer = (ServerPlayer)tracker;
                GliderData.syncTo(trackerPlayer);
            }
        }
    }
}

