/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.venturecraft.gliders.common.item.ItemComponentRegistry;
import net.venturecraft.gliders.util.ModConstants;

public class GliderItem
extends Item
implements Equipable {
    private final Supplier<ItemStack> repair;

    public GliderItem(Item.Properties itemProperties, Supplier<ItemStack> stackSupplier) {
        super(itemProperties);
        this.repair = stackSupplier;
    }

    public static boolean isSpaceGlider(ItemStack stack) {
        return stack.getDisplayName().getString().contains("xwing");
    }

    public static ItemStack setCopper(ItemStack itemStack, boolean copper) {
        itemStack.set((DataComponentType)ItemComponentRegistry.COPPER_UPGRADE.get(), (Object)copper);
        return itemStack;
    }

    public static boolean hasCopperUpgrade(ItemStack itemStack) {
        DataComponentMap compound = itemStack.getComponents();
        if (!compound.has((DataComponentType)ItemComponentRegistry.COPPER_UPGRADE.get())) {
            return false;
        }
        return (Boolean)compound.get((DataComponentType)ItemComponentRegistry.COPPER_UPGRADE.get());
    }

    public static ItemStack setNether(ItemStack itemStack, boolean copper) {
        itemStack.set((DataComponentType)ItemComponentRegistry.NETHER_UPGRADE.get(), (Object)copper);
        return itemStack;
    }

    public static boolean hasNetherUpgrade(ItemStack itemStack) {
        DataComponentMap compound = itemStack.getComponents();
        if (!compound.has((DataComponentType)ItemComponentRegistry.NETHER_UPGRADE.get())) {
            return false;
        }
        return (Boolean)compound.get((DataComponentType)ItemComponentRegistry.NETHER_UPGRADE.get());
    }

    public static boolean isGlidingEnabled(ItemStack itemStack) {
        DataComponentMap compound = itemStack.getComponents();
        if (!compound.has((DataComponentType)ItemComponentRegistry.GLIDE.get())) {
            return false;
        }
        return (Boolean)compound.get((DataComponentType)ItemComponentRegistry.GLIDE.get()) != false && !GliderItem.isBroken(itemStack);
    }

    public static boolean isTooBroken(ItemStack itemStack) {
        return itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1;
    }

    public static void setGlide(ItemStack itemStack, boolean canGlide) {
        itemStack.set((DataComponentType)ItemComponentRegistry.GLIDE.get(), (Object)canGlide);
    }

    public static void setBroken(ItemStack itemStack, boolean broken) {
        itemStack.set((DataComponentType)ItemComponentRegistry.BROKEN.get(), (Object)broken);
    }

    public static boolean isBroken(ItemStack itemStack) {
        DataComponentMap compound = itemStack.getComponents();
        if (!compound.has((DataComponentType)ItemComponentRegistry.BROKEN.get())) {
            return false;
        }
        return (Boolean)compound.get((DataComponentType)ItemComponentRegistry.BROKEN.get());
    }

    public static void setStruck(ItemStack itemStack, boolean isStruck) {
        itemStack.set((DataComponentType)ItemComponentRegistry.STRUCK.get(), (Object)isStruck);
    }

    public static boolean hasBeenStruck(ItemStack itemStack) {
        DataComponentMap compound = itemStack.getComponents();
        if (!compound.has((DataComponentType)ItemComponentRegistry.STRUCK.get())) {
            return false;
        }
        return (Boolean)compound.get((DataComponentType)ItemComponentRegistry.STRUCK.get());
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.getItem() == this.repair.get().getItem();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (GliderItem.hasCopperUpgrade(stack) || GliderItem.hasNetherUpgrade(stack)) {
            tooltip.add((Component)Component.translatable((String)ModConstants.INSTALLED_UPGRADES));
            if (GliderItem.hasCopperUpgrade(stack)) {
                tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)ModConstants.COPPER_UPGRADE)));
            }
            if (GliderItem.hasNetherUpgrade(stack)) {
                tooltip.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)ModConstants.NETHER_UPGRADE)));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        EquipmentSlot equipmentslot = player.getEquipmentSlotForItem(itemstack);
        ItemStack equipmentSlotStack = player.getItemBySlot(equipmentslot);
        if (equipmentSlotStack.isEmpty()) {
            player.setItemSlot(equipmentslot, itemstack.copy());
            if (!level.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            itemstack.setCount(0);
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }

    public Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_ELYTRA;
    }
}

