/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.data;

import commonnetwork.api.Network;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.venturecraft.gliders.data.neoforge.GliderDataImpl;
import net.venturecraft.gliders.network.SyncGliderData;
import net.venturecraft.gliders.util.GliderUtil;

public class GliderData {
    public static AnimationState glideAnimation = new AnimationState();
    public static AnimationState fallingAnimation = new AnimationState();
    public static AnimationState gliderOpeningAnimation = new AnimationState();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean getIsGliding(LivingEntity player) {
        return GliderDataImpl.getIsGliding(player);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getLightningTimer(LivingEntity player) {
        return GliderDataImpl.getLightningTimer(player);
    }

    public static void tick(LivingEntity livingEntity) {
        GliderData.glideAndFallLogic(livingEntity);
        GliderUtil.onTickPlayerGlide(livingEntity.level(), livingEntity);
        if (!GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            GliderData.setLightningTimer(livingEntity, 0);
        }
        if (livingEntity.level().isClientSide) {
            return;
        }
        GliderData.setIsGliding(livingEntity, GliderUtil.isGlidingWithActiveGlider(livingEntity));
        if (livingEntity.tickCount % 40 == 0) {
            GliderData.sync(livingEntity);
        }
    }

    private static void glideAndFallLogic(LivingEntity livingEntity) {
        if (GliderData.getIsGliding(livingEntity) || GliderUtil.isGlidingWithActiveGlider(livingEntity)) {
            if (!glideAnimation.isStarted()) {
                glideAnimation.start(livingEntity.tickCount);
            }
            if (!gliderOpeningAnimation.isStarted()) {
                gliderOpeningAnimation.start(livingEntity.tickCount);
            }
        } else {
            glideAnimation.stop();
            gliderOpeningAnimation.stop();
        }
    }

    public static void sync(LivingEntity livingEntity) {
        if (livingEntity.level().isClientSide) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        SyncGliderData syncGliderData = new SyncGliderData(livingEntity.getId(), GliderData.serializeNBT());
        Network.getNetworkHandler().sendToClient((Object)syncGliderData, (ServerPlayer)livingEntity);
    }

    public static void syncTo(ServerPlayer receiver) {
        if (receiver.level().isClientSide) {
            throw new IllegalStateException("Don't sync client -> server");
        }
        Network.getNetworkHandler().sendToClient((Object)new SyncGliderData(receiver.getId(), GliderData.serializeNBT()), receiver);
    }

    public static AnimationState getAnimation(AnimationStates animationStates) {
        return switch (animationStates.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> fallingAnimation;
            case 1 -> glideAnimation;
            case 2 -> gliderOpeningAnimation;
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setLightningTimer(LivingEntity player, int lightningTimer) {
        void var1_1;
        GliderDataImpl.setLightningTimer(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setIsGliding(LivingEntity player, boolean isGliding) {
        void var1_1;
        GliderDataImpl.setIsGliding(player, (boolean)var1_1);
    }

    public static void deserializeNBT(Player player, CompoundTag nbt) {
        GliderData.setIsGliding((LivingEntity)player, nbt.getBoolean("is_gliding"));
        GliderData.setLightningTimer((LivingEntity)player, nbt.getInt("lightningTimer"));
    }

    public static CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        return compoundTag;
    }

    public static enum AnimationStates {
        FALLING,
        GLIDING,
        GLIDER_OPENING;

    }
}

