/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.util.GliderUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerEntityMixin {
    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo info) {
        Player player = (Player)this;
        GliderData.tick((LivingEntity)player);
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void livingEntityAttack(CallbackInfo info) {
        Player player = (Player)this;
        if (GliderUtil.isGlidingWithActiveGlider((LivingEntity)player)) {
            info.cancel();
        }
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void livingEntityHurt(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        ItemStack chestItem = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)player);
        boolean hasCopperMod = GliderItem.hasCopperUpgrade(chestItem);
        boolean isGliding = GliderUtil.isGlidingWithActiveGlider((LivingEntity)player);
        boolean isLightning = damageSource.is(DamageTypes.LIGHTNING_BOLT);
        if (hasCopperMod && isGliding && isLightning) {
            cir.setReturnValue((Object)false);
        }
    }
}

