/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.neoforge;

import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.threetag.palladiumcore.util.Platform;
import net.venturecraft.gliders.VCGliders;
import net.venturecraft.gliders.VCGlidersClient;
import net.venturecraft.gliders.compat.trinket.CuriosUtil;
import net.venturecraft.gliders.data.neoforge.VCAttachments;
import net.venturecraft.gliders.neoforge.data.BlockTagsProvider;
import net.venturecraft.gliders.neoforge.data.DamageSourceGeneration;
import net.venturecraft.gliders.neoforge.data.EnglishLangProvider;
import net.venturecraft.gliders.neoforge.data.ItemModelGeneration;
import net.venturecraft.gliders.neoforge.data.ItemTagsProvider;
import net.venturecraft.gliders.neoforge.data.SoundProvider;

@Mod(value="vc_gliders")
@EventBusSubscriber(modid="vc_gliders", bus=EventBusSubscriber.Bus.MOD)
public class VCGlidersNeoForge {
    public VCGlidersNeoForge(IEventBus eventBus, ModContainer container) {
        VCGliders.init();
        VCAttachments.register(eventBus);
        if (Platform.isClient()) {
            VCGlidersClient.init();
        }
        if (Platform.isModLoaded((String)"curios")) {
            CuriosUtil.init(eventBus);
        }
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent e) {
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        DataGenerator generator = e.getGenerator();
        BlockTagsProvider blockTagsProvider = (BlockTagsProvider)generator.addProvider(e.includeServer(), (DataProvider)new BlockTagsProvider(generator.getPackOutput(), e.getLookupProvider(), existingFileHelper));
        generator.addProvider(e.includeServer(), (DataProvider)new ItemTagsProvider(generator.getPackOutput(), e.getLookupProvider(), blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new ItemModelGeneration(generator, existingFileHelper));
        generator.addProvider(e.includeClient(), (DataProvider)new EnglishLangProvider(generator));
        generator.addProvider(e.includeClient(), (DataProvider)new SoundProvider(generator, existingFileHelper));
        generator.addProvider(e.includeServer(), (DataProvider)new DamageSourceGeneration(generator.getPackOutput(), e.getLookupProvider()));
    }
}

