/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.neoforge.data;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.threetag.palladiumcore.registry.RegistryHolder;
import net.venturecraft.gliders.VCGliders;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.common.item.ItemRegistry;

public class ItemModelGeneration
extends ItemModelProvider {
    public ItemModelGeneration(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "vc_gliders", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryHolder entry : ItemRegistry.ITEMS.getEntries()) {
            if (entry.get() instanceof GliderItem) {
                ResourceLocation gliderId = BuiltInRegistries.ITEM.getKey((Object)((Item)entry.get()));
                this.layeredItem(ResourceLocation.fromNamespaceAndPath((String)gliderId.getNamespace(), (String)(gliderId.getPath() + "_copper_upgrade")), gliderId, VCGliders.id("copper_upgrade"));
                this.layeredItem(ResourceLocation.fromNamespaceAndPath((String)gliderId.getNamespace(), (String)(gliderId.getPath() + "_nether_upgrade")), gliderId, VCGliders.id("nether_upgrade"));
                this.layeredItem(ResourceLocation.fromNamespaceAndPath((String)gliderId.getNamespace(), (String)(gliderId.getPath() + "_combined_upgrades")), gliderId, VCGliders.id("combined_upgrades"));
                continue;
            }
            this.basicItem((Item)entry.get());
        }
        this.basicItem(VCGliders.id("damaged_glider"));
    }

    public ItemModelBuilder layeredItem(ResourceLocation destination, ResourceLocation item, ResourceLocation resourceLocation) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(destination.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)("item/" + item.getPath())))).texture("layer1", ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)("item/" + resourceLocation.getPath())));
    }

    public ItemModelBuilder basicItem(ResourceLocation destination) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(destination.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)destination.getNamespace(), (String)("item/" + destination.getPath())));
    }

    public ItemModelBuilder layeredItem(ResourceLocation item, ResourceLocation resourceLocation) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)("item/" + item.getPath())))).texture("layer1", ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)("item/" + resourceLocation.getPath())));
    }
}

