/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.neoforge.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.venturecraft.gliders.VCGlidersClient;
import net.venturecraft.gliders.client.layer.PlayerGliderLayer;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.util.GliderUtil;

@EventBusSubscriber(modid="vc_gliders", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onRenderLevelLast(RenderLevelStageEvent event) {
        RenderBuffers bufferSource = Minecraft.getInstance().renderBuffers();
        LocalPlayer living = Minecraft.getInstance().player;
        ItemStack stack = CuriosTrinketsUtil.getInstance().getFirstFoundGlider((LivingEntity)living);
        PoseStack posestack = event.getPoseStack();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON && stack.getItem() instanceof GliderItem && GliderUtil.isGlidingWithActiveGlider((LivingEntity)living)) {
            posestack.pushPose();
            posestack.mulPose(Axis.XP.rotationDegrees(180.0f));
            posestack.mulPose(Axis.YP.rotationDegrees(living.getViewYRot(1.0f)));
            posestack.translate(0.0, -2.4, -0.5);
            posestack.scale(1.5f, 1.5f, 1.5f);
            if (GliderItem.isSpaceGlider(stack)) {
                posestack.translate(0.0, -0.2, 0.0);
                posestack.mulPose(Axis.YP.rotation(180.0f));
                PlayerGliderLayer.xWingModel.setupAnim((Entity)living, 0.0f, 0.0f, living.tickCount, 0.0f, 0.0f);
                PlayerGliderLayer.xWingModel.renderToBuffer(posestack, bufferSource.bufferSource().getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PlayerGliderLayer.getGliderTexture(stack))), VCGlidersClient.lightLevel, OverlayTexture.NO_OVERLAY, -1);
            } else {
                PlayerGliderLayer.gliderModel.setupAnim((Entity)living, 0.0f, 0.0f, living.tickCount, 0.0f, 0.0f);
                PlayerGliderLayer.gliderModel.renderToBuffer(posestack, bufferSource.bufferSource().getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)PlayerGliderLayer.getGliderTexture(stack))), VCGlidersClient.lightLevel, OverlayTexture.NO_OVERLAY, -1);
            }
            posestack.popPose();
        }
    }

    @SubscribeEvent
    public static void onMovement(MovementInputUpdateEvent event) {
        if (GliderUtil.isGlidingWithActiveGlider((LivingEntity)Minecraft.getInstance().player)) {
            event.getInput().shiftKeyDown = false;
        }
    }
}

