/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.network;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.venturecraft.gliders.VCGliders;
import net.venturecraft.gliders.util.ClientUtil;
import net.venturecraft.gliders.util.GliderUtil;

public class MessagePlaySound {
    public static final ResourceLocation CHANNEL = VCGliders.id("play_sound");
    public static final StreamCodec<FriendlyByteBuf, MessagePlaySound> STREAM_CODEC = StreamCodec.ofMember(MessagePlaySound::encode, MessagePlaySound::new);
    private final ResourceLocation sound;
    private final UUID playerUUID;

    public MessagePlaySound(ResourceLocation sound, UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.sound = sound;
    }

    public MessagePlaySound(FriendlyByteBuf buffer) {
        this.sound = buffer.readResourceLocation();
        this.playerUUID = buffer.readUUID();
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.sound);
        buffer.writeUUID(this.playerUUID);
    }

    public static void handle(PacketContext<MessagePlaySound> context) {
        if (Side.CLIENT.equals((Object)context.side())) {
            MessagePlaySound.handleClient(context);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(PacketContext<MessagePlaySound> context) {
        Player player;
        if (Minecraft.getInstance().level != null && (player = Minecraft.getInstance().level.getPlayerByUUID(((MessagePlaySound)context.message()).playerUUID)) != null) {
            ClientUtil.playGliderSound(player, ((MessagePlaySound)context.message()).sound, SoundSource.PLAYERS, true, () -> !GliderUtil.isGlidingWithActiveGlider((LivingEntity)player), 0.1f, RandomSource.create());
        }
    }
}

