/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.options.controls.ControlsScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.venturecraft.gliders.VCGlidersClient;
import net.venturecraft.gliders.client.sound.MovingSound;
import net.venturecraft.gliders.util.GliderUtil;
import net.venturecraft.gliders.util.VCGliderTags;
import net.venturecraft.gliders.util.neoforge.ClientUtilImpl;

public class ClientUtil {
    public static boolean shouldChangePerspective = true;
    public static CameraType backupPerspective = Minecraft.getInstance().options.getCameraType();

    public static void playPositionedSoundRecord(SoundEvent sound, float pitch, float volume) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)pitch, (float)volume));
    }

    public static void updraftParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide || random.nextInt(5) != 0) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !GliderUtil.isGlidingWithActiveGlider((LivingEntity)player)) {
            return;
        }
        if (!state.is(VCGliderTags.UPDRAFT_BLOCKS)) {
            return;
        }
        if (player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > 64.0) {
            return;
        }
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, true, (double)pos.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + random.nextDouble() * 2.0, (double)pos.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 1.0, 0.0);
    }

    public static void playGliderSound(Player player, ResourceLocation soundName, SoundSource category, boolean repeat, Supplier<Boolean> stopCondition, float volume, RandomSource randomSource) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new MovingSound(player, SoundEvent.createFixedRangeEvent((ResourceLocation)soundName, (float)1.0f), category, repeat, stopCondition, volume, randomSource));
    }

    public static void createToast(MutableComponent title, MutableComponent subtitle) {
        Minecraft.getInstance().getToasts().addToast((Toast)new SystemToast(SystemToast.SystemToastId.NARRATOR_TOGGLE, (Component)title, (Component)subtitle));
    }

    public static void povButton(ControlsScreen controlsScreen) {
        int startingY;
        int i = controlsScreen.width / 2 - 155;
        int j = i + 160;
        int k = startingY = (int)((double)controlsScreen.height / 3.3 - 12.0 + 48.0);
        for (int attempt = 0; attempt < 10; ++attempt) {
            boolean overlaps = false;
            for (Renderable widget : controlsScreen.renderables) {
                if (!(widget instanceof AbstractWidget)) continue;
                AbstractWidget existing = (AbstractWidget)widget;
                int existingX = existing.getX();
                int existingY = existing.getY();
                int existingW = existing.getWidth();
                int existingH = existing.getHeight();
                if (existingX != j || k >= existingY + existingH || k + 20 <= existingY) continue;
                overlaps = true;
                break;
            }
            if (!overlaps) break;
            k += 24;
        }
        AbstractWidget customButton = VCGlidersClient.autoPerspective.createButton(Minecraft.getInstance().options, j, k, 150);
        controlsScreen.addRenderableWidget((GuiEventListener)customButton);
        for (Renderable widget : controlsScreen.renderables) {
            AbstractWidget existing;
            if (!(widget instanceof AbstractWidget) || !(existing = (AbstractWidget)widget).getMessage().equals((Object)CommonComponents.GUI_DONE)) continue;
            int desiredY = k + 24;
            if (existing.getY() >= desiredY) break;
            existing.setY(desiredY);
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addPredicate(Item item, ResourceLocation resourceLocation, ClampedItemPropertyFunction clampedItemPropertyFunction) {
        void var2_2;
        void var1_1;
        ClientUtilImpl.addPredicate(item, (ResourceLocation)var1_1, (ClampedItemPropertyFunction)var2_2);
    }

    public static void setPlayerPerspective(String pointOfView) {
        if (((Boolean)VCGlidersClient.autoPerspective.get()).booleanValue() && !pointOfView.isEmpty()) {
            backupPerspective = Minecraft.getInstance().options.getCameraType();
            Minecraft.getInstance().options.setCameraType(CameraType.valueOf((String)pointOfView));
            return;
        }
        if (backupPerspective != null) {
            Minecraft.getInstance().options.setCameraType(backupPerspective);
            backupPerspective = null;
        }
    }
}

