/*
 * Decompiled with CFR 0.152.
 */
package net.venturecraft.gliders.util;

import commonnetwork.api.Network;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.venturecraft.gliders.common.compat.trinket.CuriosTrinketsUtil;
import net.venturecraft.gliders.common.item.GliderItem;
import net.venturecraft.gliders.common.sound.SoundRegistry;
import net.venturecraft.gliders.data.GliderData;
import net.venturecraft.gliders.network.MessagePOV;
import net.venturecraft.gliders.util.VCGliderTags;

public class GliderUtil {
    public static boolean hasGliderEquipped(LivingEntity livingEntity) {
        return CuriosTrinketsUtil.getInstance().getFirstFoundGlider(livingEntity).getItem() instanceof GliderItem;
    }

    public static boolean isGliderActive(LivingEntity livingEntity) {
        ItemStack glider = CuriosTrinketsUtil.getInstance().getFirstFoundGlider(livingEntity);
        if (glider == null) {
            return false;
        }
        if (glider.getItem() instanceof GliderItem) {
            return GliderItem.isGlidingEnabled(glider);
        }
        return false;
    }

    public static boolean canDeployHere(LivingEntity livingEntity) {
        if (livingEntity.isPassenger()) {
            return false;
        }
        boolean isAir = !livingEntity.onGround() && livingEntity.level().getBlockState(livingEntity.blockPosition().below(2)).isAir() && livingEntity.level().getBlockState(livingEntity.blockPosition().below()).isAir();
        boolean updraftAround = GliderUtil.nearUpdraft(livingEntity);
        boolean isUpdraft = livingEntity.level().getBlockState(livingEntity.blockPosition().below()).is(VCGliderTags.UPDRAFT_BLOCKS);
        return isUpdraft || isAir || updraftAround || livingEntity.fallDistance > 2.0f || GliderUtil.isGliderActive(livingEntity);
    }

    public static boolean nearUpdraft(LivingEntity livingEntity) {
        Iterator iterator = BlockPos.withinManhattanStream((BlockPos)livingEntity.blockPosition(), (int)2, (int)3, (int)2).iterator();
        while (iterator.hasNext()) {
            BlockState above;
            BlockPos pos = (BlockPos)iterator.next();
            BlockState blockState = livingEntity.level().getBlockState(pos);
            if (!blockState.is(VCGliderTags.UPDRAFT_BLOCKS) || !(above = livingEntity.level().getBlockState(pos.above())).isAir() && above.isSolid()) continue;
            if (blockState.hasProperty((Property)BlockStateProperties.LIT)) {
                return (Boolean)blockState.getValue((Property)BlockStateProperties.LIT);
            }
            return true;
        }
        return false;
    }

    public static ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static void onTickPlayerGlide(Level level, LivingEntity player) {
        ItemStack glider = CuriosTrinketsUtil.getInstance().getFirstFoundGlider(player);
        boolean playerCanGlide = !GliderUtil.isFlyingBlocked(player);
        boolean gliderCanGlide = GliderItem.isGlidingEnabled(glider);
        if (player instanceof Player) {
            Player player1 = (Player)player;
            boolean bl = playerCanGlide = playerCanGlide && !player1.getAbilities().flying;
        }
        if (playerCanGlide && gliderCanGlide) {
            player.resetFallDistance();
            Vec3 m = player.getDeltaMovement();
            boolean hasSpeedMods = GliderItem.hasCopperUpgrade(glider) && GliderItem.hasBeenStruck(glider);
            GliderUtil.lightningLogic(level, player, glider);
            if (player.tickCount % (player.level().dimension() == Level.NETHER ? 40 : 100) == 0 && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int damageAmount = player.level().dimension() == Level.NETHER && !GliderItem.hasNetherUpgrade(glider) ? glider.getMaxDamage() / 2 : 1;
                glider.setDamageValue(glider.getDamageValue() + damageAmount);
                if (glider.getDamageValue() >= glider.getMaxDamage()) {
                    level.playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f));
                    GliderItem.setBroken(glider, true);
                    if (player.level().dimension() != Level.NETHER) {
                        glider.setCount(0);
                    }
                }
            }
            GliderUtil.handleNetherLogic(level, player, glider);
            if (GliderUtil.checkUpdraft(level, player)) {
                return;
            }
            float horizonalSpeed = (float)player.getDeltaMovement().horizontalDistance();
            if (horizonalSpeed >= 0.01f) {
                if (GliderItem.isSpaceGlider(glider)) {
                    for (int i = 0; i < 2; ++i) {
                        level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 1.0, 0.0, 0.0);
                    }
                }
                if (hasSpeedMods) {
                    level.addParticle((ParticleOptions)ParticleTypes.WITCH, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.5, 0.0, 0.0);
                }
            }
            if (m.y < -0.05) {
                player.setDeltaMovement(new Vec3(m.x, -0.05, m.z));
            }
            return;
        }
        if (GliderUtil.isFlyingBlocked(player)) {
            GliderItem.setGlide(glider, false);
            GliderItem.setStruck(glider, false);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Network.getNetworkHandler().sendToClient((Object)new MessagePOV(""), serverPlayer);
            }
        }
    }

    private static void handleNetherLogic(Level level, LivingEntity player, ItemStack glider) {
        if (level.dimension() == Level.NETHER && !GliderItem.hasNetherUpgrade(glider) && player.level().random.nextInt(24) == 0 && !player.isSilent()) {
            player.level().playLocalSound(player.getX() + 0.5, player.getY() + 0.5, player.getZ() + 0.5, SoundEvents.BLAZE_BURN, player.getSoundSource(), 1.0f + level.random.nextFloat(), level.random.nextFloat() * 0.7f + 0.3f, false);
            for (int i = 0; i < 2; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.2, 1.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.0, 0.2, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private static void lightningLogic(Level level, LivingEntity player, ItemStack glider) {
        if (level.isRainingAt(player.blockPosition())) {
            if (GliderData.getIsGliding(player)) {
                int lightningTimer = GliderData.getLightningTimer(player) + 1;
                GliderData.setLightningTimer(player, lightningTimer);
                if (lightningTimer == 1) {
                    player.playSound((SoundEvent)SoundRegistry.INCOMING_LIGHTNING.get());
                }
                if (player.level().random.nextInt(24) == 0 && lightningTimer > 200 && !GliderItem.hasBeenStruck(glider)) {
                    LightningBolt lightningBolt = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
                    lightningBolt.setPos(player.getX(), player.getY(), player.getZ());
                    lightningBolt.setVisualOnly(false);
                    level.addFreshEntity((Entity)lightningBolt);
                }
            }
            if (player.level().random.nextInt(24) == 0 && !GliderItem.hasCopperUpgrade(glider)) {
                for (int i = 0; i < 2; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.WAX_ON, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.2, 1.0, 0.0);
                    level.addParticle((ParticleOptions)ParticleTypes.WAX_OFF, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.0, 0.2, 0.0);
                    level.addParticle((ParticleOptions)ParticleTypes.WARPED_SPORE, player.getRandomX(0.5), player.getY() + 2.5, player.getRandomZ(0.5), 0.0, 0.0, 0.0);
                }
            }
        } else {
            GliderData.setLightningTimer(player, 0);
        }
    }

    public static boolean checkUpdraft(Level world, LivingEntity player) {
        AABB boundingBox = player.getBoundingBox().contract(2.0, 20.0, 2.0);
        List blocks = world.getBlockStatesIfLoaded(boundingBox).toList();
        Stream<BlockState> filteredBlocks = blocks.stream().filter(blockState -> blockState.is(VCGliderTags.UPDRAFT_BLOCKS) && GliderUtil.checkLit(blockState));
        if (filteredBlocks.toList().size() > 0 || GliderUtil.nearUpdraft(player)) {
            player.setDeltaMovement(0.0, 0.5, 0.0);
            return true;
        }
        return false;
    }

    private static boolean checkLit(BlockState blockState) {
        if (blockState.hasProperty((Property)BlockStateProperties.LIT)) {
            return (Boolean)blockState.getValue((Property)BlockStateProperties.LIT);
        }
        return true;
    }

    public static boolean isFlyingBlocked(LivingEntity livingEntity) {
        return livingEntity.onGround() || livingEntity.isInWater() || livingEntity.isUnderWater() || livingEntity.isSwimming() || livingEntity.isFallFlying();
    }

    public static boolean isGlidingWithActiveGlider(LivingEntity livingEntity) {
        return GliderUtil.hasGliderEquipped(livingEntity) && GliderUtil.isGliderActive(livingEntity) && !livingEntity.onGround() && !livingEntity.isInWater();
    }
}

