/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.mixin;

import com.mojang.authlib.GameProfile;
import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.TagModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.ITempleStateCacheProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerTickMixin
extends Player {
    @Shadow
    public ServerGamePacketListenerImpl connection;
    @Shadow
    @Final
    public ServerPlayerGameMode gameMode;

    public ServerPlayerTickMixin(Level $$0, BlockPos $$1, float $$2, GameProfile $$3) {
        super($$0, $$1, $$2, $$3);
    }

    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void betterdeserttemples_playerTick(CallbackInfo info) {
        if (this.gameMode.isSurvival() && this.tickCount % 100 == 0) {
            boolean isInTemple;
            if (!BetterDesertTemplesCommon.CONFIG.general.applyMiningFatigue) {
                return;
            }
            BlockPos playerPos = this.blockPosition();
            StructureStart structureStart = this.serverLevel().structureManager().getStructureWithPieceAt(playerPos, TagModule.APPLIES_MINING_FATIGUE);
            boolean bl = isInTemple = this.serverLevel().isLoaded(playerPos) && structureStart.isValid();
            if (!isInTemple) {
                return;
            }
            boolean isTempleCleared = ((ITempleStateCacheProvider)this.serverLevel()).getTempleStateCache().isTempleCleared(structureStart.getChunkPos().getWorldPosition());
            if (isTempleCleared) {
                return;
            }
            if (!this.hasEffect(MobEffects.DIG_SLOWDOWN) || this.getEffect(MobEffects.DIG_SLOWDOWN).getAmplifier() < 2 || this.getEffect(MobEffects.DIG_SLOWDOWN).getDuration() < 120) {
                if (!this.hasEffect(MobEffects.DIG_SLOWDOWN)) {
                    this.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.ELDER_GUARDIAN_CURSE), SoundSource.HOSTILE, this.getX(), this.getY(), this.getZ(), 1.0f, 1.0f, this.serverLevel().getSeed()));
                }
                this.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 600, 2), (Entity)this);
            }
        }
    }
}

