/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.mru.RegistryUtils;
import dev.imb11.sounds.SoundsClient;
import dev.imb11.sounds.util.MixinStatics;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class ConfiguredSound {
    public static final Codec<ConfiguredSound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(ConfiguredSound::getId), (App)ResourceLocation.CODEC.fieldOf("soundEvent").forGetter(sound -> sound.soundEvent), (App)Codec.BOOL.fieldOf("shouldPlay").forGetter(ConfiguredSound::shouldPlay), (App)Codec.FLOAT.fieldOf("pitch").forGetter(ConfiguredSound::getPitch), (App)Codec.FLOAT.fieldOf("volume").forGetter(ConfiguredSound::getVolume)).apply((Applicative)instance, ConfiguredSound::new));
    public final String id;
    public boolean enabled;
    public ResourceLocation soundEvent;
    public float pitch = 1.0f;
    public float volume = 1.0f;
    private float _pendingPitch = 1.0f;
    private float _pendingVolume = 1.0f;
    private ResourceLocation _pendingSoundEvent;
    protected static long lastShownToast = -1L;

    public ConfiguredSound(String id, ResourceLocation soundEvent, boolean enabled, float pitch, float volume) {
        this.enabled = enabled;
        this.soundEvent = soundEvent;
        this.pitch = pitch;
        this.volume = volume;
        this._pendingPitch = pitch;
        this._pendingVolume = volume;
        this._pendingSoundEvent = this.soundEvent;
        this.id = id;
    }

    public ConfiguredSound(String id, Holder.Reference<SoundEvent> soundEvent, boolean enabled, float pitch, float volume) {
        this(id, soundEvent.key().location(), enabled, pitch, volume);
    }

    public ConfiguredSound(String id, SoundEvent soundEvent, boolean enabled, float pitch, float volume) {
        this(id, soundEvent.getLocation(), enabled, pitch, volume);
    }

    public ConfiguredSound(String id, Holder<SoundEvent> soundEvent, boolean enabled, float pitch, float volume) {
        this(id, (SoundEvent)soundEvent.value(), enabled, pitch, volume);
    }

    private <T extends ConfiguredSound> ArrayList<Option<?>> createDefaultOptions(T defaults) {
        Option volumeOpt = Option.createBuilder().name((Component)Component.translatable((String)"sounds.config.volume.name")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"sounds.config.volume.description")}).build()).binding((Object)Float.valueOf(defaults.volume), () -> Float.valueOf(this.volume), val -> {
            this.volume = val.floatValue();
        }).listener((opt, val) -> {
            this._pendingVolume = val.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).step((Number)Float.valueOf(0.1f))).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).build();
        Option pitchOpt = Option.createBuilder().name((Component)Component.translatable((String)"sounds.config.pitch.name")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"sounds.config.pitch.description")}).build()).binding((Object)Float.valueOf(defaults.pitch), () -> Float.valueOf(this.pitch), val -> {
            this.pitch = val.floatValue();
        }).listener((opt, val) -> {
            this._pendingPitch = val.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).step((Number)Float.valueOf(0.1f))).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).build();
        Option soundEventOpt = Option.createBuilder().name((Component)Component.translatable((String)"sounds.config.event.name")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"sounds.config.event.description")}).build()).binding((Object)defaults.soundEvent.toString(), () -> this.soundEvent.toString(), val -> {
            this.soundEvent = ResourceLocation.parse((String)val);
        }).listener((opt, val) -> {
            this._pendingSoundEvent = ResourceLocation.parse((String)val);
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(false).values(MixinStatics.FOUND_SOUND_EVENTS.stream().map(ResourceLocation::toString).toList())).build();
        return new ArrayList(List.of(volumeOpt, pitchOpt, soundEventOpt));
    }

    public <T extends ConfiguredSound> ArrayList<Option<?>> addExtraOptions(T defaults) {
        return new ArrayList();
    }

    public ButtonOption getPreviewButton() {
        return ButtonOption.createBuilder().name((Component)Component.translatable((String)"sounds.config.preview.name", (Object[])new Object[]{""})).description(OptionDescription.of((Component[])new Component[]{Component.translatable((String)"sounds.config.preview.option.description")})).action((a, b) -> this.playPreviewSound()).build();
    }

    public OptionGroup getOptionGroup(ConfiguredSound defaults) {
        ArrayList<Option<?>> defaultOptions = this.createDefaultOptions(defaults);
        ArrayList<Option<?>> extraOptions = this.addExtraOptions(defaults);
        ArrayList allOptions = new ArrayList(defaultOptions);
        allOptions.addAll(extraOptions);
        Option shouldPlay = Option.createBuilder().name((Component)Component.translatable((String)"sounds.config.shouldPlay.option")).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)"sounds.config.shouldPlay.option.description")}).build()).binding((Object)defaults.enabled, () -> this.enabled, val -> {
            this.enabled = val;
        }).listener((opt, val) -> allOptions.forEach(option -> option.setAvailable(val.booleanValue()))).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).build();
        return OptionGroup.createBuilder().name((Component)Component.translatable((String)("sounds.config." + this.id + ".option")).withStyle(ChatFormatting.UNDERLINE)).description(OptionDescription.createBuilder().text(new Component[]{Component.translatable((String)("sounds.config." + this.id + ".option.description"))}).build()).option((Option)this.getPreviewButton()).option(shouldPlay).options(allOptions).collapsed(true).build();
    }

    public final SoundEvent fetchSoundEvent(ResourceLocation location) {
        return (SoundEvent)RegistryUtils.getSoundEventRegistry((ClientLevel)Minecraft.getInstance().level).apply(location);
    }

    public void playSound() {
        block3: {
            if (this.enabled) {
                try {
                    this.playSound(this.soundEvent, this.pitch, this.volume);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                    if (System.currentTimeMillis() <= lastShownToast + 5000L) break block3;
                    lastShownToast = System.currentTimeMillis();
                    Minecraft client = Minecraft.getInstance();
                    ToastComponent toastManager = client.getToasts();
                    toastManager.addToast((Toast)SystemToast.multiline((Minecraft)client, (SystemToast.SystemToastId)SystemToast.SystemToastId.WORLD_ACCESS_FAILURE, (Component)Component.translatable((String)"sounds.config.play.error.title"), (Component)Component.translatable((String)"sounds.config.play.error.description", (Object[])new Object[]{this.getId()})));
                }
            }
        }
    }

    private void playPreviewSound() {
        block2: {
            try {
                this.playSound(this._pendingSoundEvent, this._pendingPitch, this._pendingVolume);
            }
            catch (Exception ignored) {
                if (System.currentTimeMillis() <= lastShownToast + 5000L) break block2;
                lastShownToast = System.currentTimeMillis();
                Minecraft client = Minecraft.getInstance();
                ToastComponent toastManager = client.getToasts();
                toastManager.addToast((Toast)SystemToast.multiline((Minecraft)client, (SystemToast.SystemToastId)SystemToast.SystemToastId.WORLD_ACCESS_FAILURE, (Component)Component.translatable((String)"sounds.config.preview.error.title"), (Component)Component.translatable((String)"sounds.config.preview.error.description")));
            }
        }
    }

    private void playSound(ResourceLocation soundEvent, float pitch, float volume) {
        this.playSound((SoundInstance)new SimpleSoundInstance(soundEvent, SoundSource.MASTER, volume, pitch, SoundsClient.RANDOM, false, 0, SoundInstance.Attenuation.LINEAR, 0.0, 0.0, 0.0, true));
    }

    @Nullable
    public SimpleSoundInstance getSoundInstance() {
        if (this.enabled) {
            try {
                SoundEvent event = (SoundEvent)RegistryUtils.getSoundEventRegistry((ClientLevel)Minecraft.getInstance().level).apply(this.soundEvent);
                return SimpleSoundInstance.forUI((SoundEvent)event, (float)this.pitch, (float)this.volume);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public void playSound(SoundInstance soundInstance) {
        if (this.enabled) {
            Minecraft.getInstance().getSoundManager().play(soundInstance);
        }
    }

    public void stopSound(SoundInstance soundInstance) {
        if (this.enabled) {
            Minecraft.getInstance().getSoundManager().stop(soundInstance);
        }
    }

    public boolean shouldPlay() {
        return this.enabled;
    }

    public ResourceLocation getSoundEvent() {
        return this.soundEvent;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public String getId() {
        return this.id;
    }
}

