/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;

public class TagPair {
    private static final Codec<SoundType> BLOCK_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("pitch").forGetter(SoundType::getPitch), (App)Codec.FLOAT.fieldOf("volume").forGetter(SoundType::getVolume), (App)SoundEvent.DIRECT_CODEC.fieldOf("break").forGetter(SoundType::getBreakSound), (App)SoundEvent.DIRECT_CODEC.fieldOf("step").forGetter(SoundType::getStepSound), (App)SoundEvent.DIRECT_CODEC.fieldOf("place").forGetter(SoundType::getPlaceSound), (App)SoundEvent.DIRECT_CODEC.fieldOf("hit").forGetter(SoundType::getHitSound), (App)SoundEvent.DIRECT_CODEC.fieldOf("fall").forGetter(SoundType::getFallSound)).apply((Applicative)instance, SoundType::new));
    public static final Codec<TagPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagList.getCodec(BuiltInRegistries.BLOCK.key()).fieldOf("keys").forGetter(TagPair::getKeys), (App)BLOCK_GROUP_CODEC.fieldOf("group").forGetter(TagPair::getGroup), (App)Codec.BOOL.fieldOf("enabled").forGetter(TagPair::isEnabled)).apply((Applicative)instance, TagPair::new));
    private final TagList<Block> keys;
    private final SoundType group;
    private boolean enabled;

    public TagList<Block> getKeys() {
        return this.keys;
    }

    public SoundType getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TagPair(TagList<Block> keys, SoundType group) {
        this.keys = keys;
        this.group = group;
        this.enabled = true;
    }

    public TagPair(TagList<Block> keys, SoundType group, boolean enabled) {
        this(keys, group);
        this.enabled = enabled;
    }

    public static class Builder {
        private final TagList<Block> keys = new TagList(new ArrayList());
        private SoundType group = SoundType.STONE;
        private boolean enabled = true;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder group(float pitch, float volume, SoundEvent breakSound, SoundEvent stepSound, SoundEvent placeSound, SoundEvent hitSound, SoundEvent fallSound) {
            this.group = new SoundType(pitch, volume, breakSound, stepSound, placeSound, hitSound, fallSound);
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(Block ... keys) {
            for (Block key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(Block key) {
            this.keys.add((Either<ResourceKey<Block>, TagKey<Block>>)Either.left((Object)((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)key).orElseThrow(() -> new RuntimeException("TagPair.Builder: Could not find RegistryKey for " + key.toString())))));
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(TagKey<Block> ... keys) {
            for (TagKey<Block> key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(TagKey<Block> key) {
            this.keys.add((Either<ResourceKey<Block>, TagKey<Block>>)Either.right(key));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TagPair build() {
            return new TagPair(this.keys, this.group, this.enabled);
        }
    }
}

