/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.operation.ModifyInjectionPoint;
import org.sinytra.adapter.patch.transformer.operation.ModifyInjectionTarget;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public class DynFixAtVariableAssignStore
implements DynamicFixer<Data> {
    private static final Set<String> ACCEPTED_ANNOTATIONS = Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;");

    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesAny(ACCEPTED_ANNOTATIONS) && methodContext.hasInjectionPointValue("INVOKE")) {
            MethodContext.TargetPair cleanInjectionTarget = methodContext.findCleanInjectionTarget();
            List<AbstractInsnNode> cleanInsns = methodContext.findInjectionTargetInsns(cleanInjectionTarget);
            if (cleanInsns.size() != 1) {
                return null;
            }
            MethodContext.TargetPair dirtyInjectionTarget = methodContext.findDirtyInjectionTarget();
            if (dirtyInjectionTarget == null) {
                return null;
            }
            return new Data(cleanInjectionTarget.methodNode(), dirtyInjectionTarget, cleanInsns.getFirst());
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        VarInsnNode varInsn;
        MethodNode cleanTargetMethod = data.cleanTargetMethod();
        MethodNode dirtyTargetMethod = data.dirtyTarget().methodNode();
        AbstractInsnNode cleanInjectionInsn = data.cleanInjectionInsn();
        AbstractInsnNode next = DynFixAtVariableAssignStore.findNextUsefulInsn(cleanInjectionInsn);
        if (!(next instanceof VarInsnNode) || !OpcodeUtil.isStoreOpcode((varInsn = (VarInsnNode)next).getOpcode())) {
            return null;
        }
        LocalVariableNode cleanLocal = methodContext.cleanLocalsTable().getByIndexOrNull(varInsn.var);
        if (cleanLocal == null) {
            return null;
        }
        List<LocalVariableNode> cleanLocals = methodContext.cleanLocalsTable().getForType(cleanLocal);
        List<LocalVariableNode> dirtyLocals = methodContext.dirtyLocalsTable().getForType(cleanLocal);
        if (cleanLocals.size() != dirtyLocals.size()) {
            return null;
        }
        LocalVariableNode dirtyLocal = dirtyLocals.get(cleanLocals.indexOf(cleanLocal));
        List<AbstractInsnNode> cleanStoreInsns = DynFixAtVariableAssignStore.findStoreInsns(cleanTargetMethod.instructions, cleanLocal.index);
        int cleanStoreInsnIndex = cleanStoreInsns.indexOf(varInsn);
        if (cleanStoreInsnIndex == -1) {
            return null;
        }
        List<AbstractInsnNode> dirtyStoreInsns = DynFixAtVariableAssignStore.findStoreInsns(dirtyTargetMethod.instructions, dirtyLocal.index);
        if (cleanStoreInsns.size() != dirtyStoreInsns.size()) {
            return null;
        }
        AbstractInsnNode dirtyStoreInsn = dirtyStoreInsns.get(cleanStoreInsnIndex);
        MethodInsnNode previousMethodCall = (MethodInsnNode)AdapterUtil.iterateInsns(dirtyStoreInsn, AbstractInsnNode::getPrevious, i -> i instanceof MethodInsnNode);
        if (previousMethodCall == null) {
            return null;
        }
        if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;")) {
            return DynFixAtVariableAssignStore.handleWrapAnnotation(methodContext, data, previousMethodCall);
        }
        String newInjectionPoint = Type.getObjectType((String)previousMethodCall.owner).getDescriptor() + previousMethodCall.name + previousMethodCall.desc;
        return DynamicFixer.FixResult.of(new ModifyInjectionPoint((String)null, newInjectionPoint, true, true).apply(methodContext), PatchAuditTrail.Match.FULL);
    }

    @Nullable
    private static DynamicFixer.FixResult handleWrapAnnotation(MethodContext methodContext, Data data, MethodInsnNode previousMethodCall) {
        if (previousMethodCall.owner.equals(data.dirtyTarget().classNode().name)) {
            String newTarget = previousMethodCall.name + previousMethodCall.desc;
            return DynamicFixer.FixResult.of(new ModifyInjectionTarget(List.of(newTarget)).apply(methodContext), PatchAuditTrail.Match.FULL);
        }
        return null;
    }

    private static List<AbstractInsnNode> findStoreInsns(InsnList insns, int index) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode insn : insns) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (varInsn.var != index || !OpcodeUtil.isStoreOpcode(varInsn.getOpcode())) continue;
            list.add(insn);
        }
        return list;
    }

    private static AbstractInsnNode findNextUsefulInsn(AbstractInsnNode insn) {
        return AdapterUtil.iterateInsns(insn, AbstractInsnNode::getNext, i -> !(i instanceof TypeInsnNode) && !(i instanceof FrameNode) && !(i instanceof LineNumberNode) && !(i instanceof LabelNode));
    }

    public record Data(MethodNode cleanTargetMethod, MethodContext.TargetPair dirtyTarget, AbstractInsnNode cleanInjectionInsn) {
    }
}

