/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.analysis.params.EnhancedParamsDiff;
import org.sinytra.adapter.patch.analysis.params.LayeredParamsDiffSnapshot;
import org.sinytra.adapter.patch.analysis.params.ParamsDiffSnapshot;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.BundledMethodTransform;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformTarget;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class DynFixParameterTypeAdapter
implements DynamicFixer<Data> {
    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesDesc("Lorg/spongepowered/asm/mixin/injection/Redirect;")) {
            MethodQualifier qualifier = methodContext.getInjectionPointMethodQualifier();
            if (qualifier == null) {
                return null;
            }
            MethodContext.TargetPair dirtyPair = methodContext.findDirtyInjectionTarget();
            if (dirtyPair == null) {
                return null;
            }
            List<MethodInsnNode> newMethodCalls = StreamSupport.stream(dirtyPair.methodNode().instructions.spliterator(), false).filter(i -> {
                if (!(i instanceof MethodInsnNode)) return false;
                MethodInsnNode minsn = (MethodInsnNode)i;
                if (!minsn.owner.equals(qualifier.internalOwnerName())) return false;
                if (!minsn.name.equals(qualifier.name())) return false;
                if (minsn.desc.equals(qualifier.desc())) return false;
                return true;
            }).map(i -> (MethodInsnNode)i).toList();
            if (newMethodCalls.size() != 1) {
                return null;
            }
            MethodInsnNode newCall = newMethodCalls.getFirst();
            LayeredParamsDiffSnapshot diff = EnhancedParamsDiff.createLayered(List.of(Type.getArgumentTypes((String)qualifier.desc())), List.of(Type.getArgumentTypes((String)newCall.desc)));
            Set<List<AbstractInsnNode>> modifyCalls = DynFixParameterTypeAdapter.validateReplacements(methodContext, qualifier, diff.replacements());
            if (modifyCalls == null) {
                return null;
            }
            return new Data(newCall, diff, modifyCalls, qualifier);
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        Patch.Result result = ((BundledMethodTransform.Builder)((BundledMethodTransform.Builder)BundledMethodTransform.builder().modifyInjectionPoint(MethodCallAnalyzer.getCallQualifier(data.newCall()))).transform(data.diff().asParameterTransformer(ParamTransformTarget.INJECTION_POINT, false))).apply(methodContext);
        if (result == Patch.Result.PASS) {
            return null;
        }
        MethodQualifier qualifier = data.qualifier();
        for (List<AbstractInsnNode> call : data.modifyCalls()) {
            for (AbstractInsnNode insn : call) {
                MethodInsnNode minsn;
                if (!(insn instanceof MethodInsnNode) || !qualifier.matches(minsn = (MethodInsnNode)insn)) continue;
                minsn.desc = data.newCall().desc;
            }
        }
        return DynamicFixer.FixResult.of(result.or(Patch.Result.APPLY), PatchAuditTrail.Match.FULL);
    }

    @Nullable
    private static Set<List<AbstractInsnNode>> validateReplacements(MethodContext methodContext, MethodQualifier qualifier, List<Pair<Integer, Type>> replacements) {
        MethodNode mixinMethod = methodContext.getMixinMethod();
        List<List<AbstractInsnNode>> insns = MethodCallAnalyzer.getInvocationInsns(mixinMethod, qualifier);
        LocalVariableLookup lookup = new LocalVariableLookup(methodContext.getMixinMethod());
        Set paramVars = replacements.stream().map(p -> lookup.getByParameterOrdinal((int)((Integer)p.getFirst()).intValue()).index).collect(Collectors.toSet());
        HashSet<List<AbstractInsnNode>> usedInsns = new HashSet<List<AbstractInsnNode>>();
        for (AbstractInsnNode insn : methodContext.getMixinMethod().instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (!paramVars.contains(varInsn.var)) continue;
            List call = insns.stream().filter(l -> l.contains(varInsn)).findFirst().orElse(null);
            if (call == null) {
                return null;
            }
            usedInsns.add(call);
        }
        return usedInsns;
    }

    public record Data(MethodInsnNode newCall, ParamsDiffSnapshot diff, Set<List<AbstractInsnNode>> modifyCalls, MethodQualifier qualifier) {
    }
}

