/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.sinytra.adapter.patch.util.MockMixinRuntime;
import org.spongepowered.asm.mixin.injection.code.ISliceContext;
import org.spongepowered.asm.mixin.injection.code.InsnListReadOnly;
import org.spongepowered.asm.mixin.injection.code.MethodSlice;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.refmap.IMixinContext;

public class DynFixSliceBoundary
implements DynamicFixer<Data> {
    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        MethodContext.TargetPair dirtyTarget = methodContext.findDirtyInjectionTarget();
        if (dirtyTarget == null) {
            return null;
        }
        AnnotationHandle sliceAnnotation = methodContext.methodAnnotation().getNested("slice").orElse(null);
        if (sliceAnnotation == null) {
            return null;
        }
        if (DynFixSliceBoundary.passesSliceCheck(sliceAnnotation, methodContext)) {
            return null;
        }
        List<AnnotationHandle> slices = Stream.of("from", "to").flatMap(s -> sliceAnnotation.getNested((String)s).stream()).toList();
        return new Data(sliceAnnotation, slices);
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        MethodContext.TargetPair dirtyTarget = methodContext.findDirtyInjectionTarget();
        Target mixinTarget = MockMixinRuntime.createMixinTarget(dirtyTarget);
        AnnotationHandle slice = data.slice();
        IMixinContext mixinContext = MockMixinRuntime.forClass(classNode.name, dirtyTarget.classNode().name, methodContext.patchContext().environment());
        ISliceContext sliceContext = MockMixinRuntime.forSlice(mixinContext, methodNode);
        MethodSlice methodSlice = MethodSlice.parse((ISliceContext)sliceContext, (AnnotationNode)slice.unwrap());
        InsnListReadOnly insns = methodSlice.getSlice(mixinTarget);
        if (insns.size() != dirtyTarget.methodNode().instructions.size()) {
            return null;
        }
        return DynamicFixer.FixResult.of(data.slices().stream().reduce(Patch.Result.PASS, (a, b) -> a.or(DynFixSliceBoundary.fixSlideInjectionPoint(b, dirtyTarget.methodNode())), Patch.Result::or), PatchAuditTrail.Match.FULL);
    }

    private static Patch.Result fixSlideInjectionPoint(AnnotationHandle annotation, MethodNode dirtyMethod) {
        if (!annotation.getValue("value").map(AnnotationValueHandle::get).map("INVOKE"::equals).orElse(false).booleanValue()) {
            return Patch.Result.PASS;
        }
        AnnotationValueHandle targetHandle = annotation.getValue("target").orElse(null);
        if (targetHandle == null) {
            return Patch.Result.PASS;
        }
        MethodQualifier target = MethodQualifier.create((String)targetHandle.get()).orElse(null);
        if (target == null) {
            return Patch.Result.PASS;
        }
        ArrayList<MethodInsnNode> candidates = new ArrayList<MethodInsnNode>();
        for (AbstractInsnNode insn : dirtyMethod.instructions) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode minsn = (MethodInsnNode)insn;
            if (!minsn.name.equals(target.name())) continue;
            candidates.add(minsn);
        }
        if (candidates.size() != 1) {
            return Patch.Result.PASS;
        }
        MethodInsnNode insn = (MethodInsnNode)candidates.getFirst();
        String qualifier = String.valueOf(Type.getObjectType((String)insn.owner)) + insn.name + insn.desc;
        targetHandle.set(qualifier);
        return Patch.Result.APPLY;
    }

    private static boolean passesSliceCheck(AnnotationHandle slice, MethodContext methodContext) {
        MethodContext.TargetPair dirtyTarget = methodContext.findDirtyInjectionTarget();
        Target mixinTarget = MockMixinRuntime.createMixinTarget(dirtyTarget);
        IMixinContext mixinContext = MockMixinRuntime.forClass(methodContext.getMixinClass().name, dirtyTarget.classNode().name, methodContext.patchContext().environment());
        ISliceContext sliceContext = MockMixinRuntime.forSlice(mixinContext, methodContext.getMixinMethod());
        MethodSlice methodSlice = MethodSlice.parse((ISliceContext)sliceContext, (AnnotationNode)slice.unwrap());
        InsnListReadOnly insns = methodSlice.getSlice(mixinTarget);
        return insns.size() != dirtyTarget.methodNode().instructions.size();
    }

    public record Data(AnnotationHandle slice, List<AnnotationHandle> slices) {
    }
}

