/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.util.MethodQualifier;

public record DivertRedirectorTransform(Consumer<InstructionAdapter> patcher) implements MethodTransform
{
    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/injection/Redirect;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        MethodQualifier target;
        String value = methodContext.injectionPointAnnotation().getValue("value").map(AnnotationValueHandle::get).orElse(null);
        if ("INVOKE".equals(value) && (target = methodContext.getInjectionPointMethodQualifier()) != null) {
            boolean applied = false;
            block0: for (AbstractInsnNode insn : methodNode.instructions) {
                MethodInsnNode minsn;
                if (!(insn instanceof MethodInsnNode) || !target.matches(minsn = (MethodInsnNode)insn)) continue;
                for (AbstractInsnNode previous = insn.getPrevious(); previous != null; previous = previous.getPrevious()) {
                    if (!(previous instanceof LabelNode)) continue;
                    MethodNode dummy = new MethodNode();
                    InstructionAdapter adapter = new InstructionAdapter((MethodVisitor)dummy);
                    LabelNode gotoTarget = new LabelNode();
                    dummy.instructions.add((AbstractInsnNode)gotoTarget);
                    this.patcher.accept(adapter);
                    methodNode.instructions.insert((AbstractInsnNode)minsn, dummy.instructions);
                    methodNode.instructions.insert(previous, (AbstractInsnNode)new JumpInsnNode(167, gotoTarget));
                    applied = true;
                    continue block0;
                }
            }
            if (applied) {
                return Patch.Result.APPLY;
            }
        }
        return Patch.Result.PASS;
    }
}

