/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api;

import com.mojang.authlib.GameProfile;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.impl.placeholder.ViewObjectImpl;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record PlaceholderContext(MinecraftServer server, Supplier<CommandSourceStack> lazySource, @Nullable ServerLevel world, @Nullable ServerPlayer player, @Nullable Entity entity, @Nullable GameProfile gameProfile, ViewObject view) {
    public static ParserContext.Key<PlaceholderContext> KEY = new ParserContext.Key<PlaceholderContext>("placeholder_context", PlaceholderContext.class);

    public PlaceholderContext(MinecraftServer server, CommandSourceStack source, @Nullable ServerLevel world, @Nullable ServerPlayer player, @Nullable Entity entity, @Nullable GameProfile gameProfile, ViewObject view) {
        this(server, () -> source, world, player, entity, gameProfile, view);
    }

    public PlaceholderContext(MinecraftServer server, CommandSourceStack source, @Nullable ServerLevel world, @Nullable ServerPlayer player, @Nullable Entity entity, @Nullable GameProfile gameProfile) {
        this(server, source, world, player, entity, gameProfile, ViewObject.DEFAULT);
    }

    public CommandSourceStack source() {
        return this.lazySource.get();
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public boolean hasGameProfile() {
        return this.gameProfile != null;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public ParserContext asParserContext() {
        return ParserContext.of(KEY, this);
    }

    public PlaceholderContext withView(ViewObject view) {
        return new PlaceholderContext(this.server, this.lazySource, this.world, this.player, this.entity, this.gameProfile, view);
    }

    public void addToContext(ParserContext context) {
        context.with(KEY, this);
    }

    public static PlaceholderContext of(MinecraftServer server) {
        return PlaceholderContext.of(server, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(MinecraftServer server, ViewObject view) {
        return new PlaceholderContext(server, () -> ((MinecraftServer)server).createCommandSourceStack(), null, null, null, null, view);
    }

    public static PlaceholderContext of(GameProfile profile, MinecraftServer server) {
        return PlaceholderContext.of(profile, server, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(GameProfile profile, MinecraftServer server, ViewObject view) {
        String name = profile.getName() != null ? profile.getName() : profile.getId().toString();
        return new PlaceholderContext(server, () -> new CommandSourceStack(CommandSource.NULL, Vec3.ZERO, Vec2.ZERO, server.overworld(), server.getProfilePermissions(profile), name, (Component)Component.literal((String)name), server, null), null, null, null, profile, view);
    }

    public static PlaceholderContext of(ServerPlayer player) {
        return PlaceholderContext.of(player, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(ServerPlayer player, ViewObject view) {
        return new PlaceholderContext(player.getServer(), () -> ((ServerPlayer)player).createCommandSourceStack(), player.serverLevel(), player, (Entity)player, player.getGameProfile(), view);
    }

    public static PlaceholderContext of(CommandSourceStack source) {
        return PlaceholderContext.of(source, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(CommandSourceStack source, ViewObject view) {
        return new PlaceholderContext(source.getServer(), source, source.getLevel(), source.getPlayer(), source.getEntity(), source.getPlayer() != null ? source.getPlayer().getGameProfile() : null, view);
    }

    public static PlaceholderContext of(Entity entity) {
        return PlaceholderContext.of(entity, ViewObject.DEFAULT);
    }

    public static PlaceholderContext of(Entity entity, ViewObject view) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return PlaceholderContext.of(player, view);
        }
        return new PlaceholderContext(entity.getServer(), () -> ((Entity)entity).createCommandSourceStack(), (ServerLevel)entity.level(), null, entity, null, view);
    }

    public static interface ViewObject {
        public static final ViewObject DEFAULT = ViewObject.of(ResourceLocation.fromNamespaceAndPath((String)"placeholder_api", (String)"default"));

        public static ViewObject of(ResourceLocation identifier) {
            return new ViewObjectImpl(identifier);
        }

        public ResourceLocation identifier();
    }
}

