/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public record DynamicTextNode(String id, ParserContext.Key<Function<String, Component>> key) implements TextNode
{
    public static DynamicTextNode of(String id, ParserContext.Key<Function<String, Component>> key) {
        return new DynamicTextNode(id, key);
    }

    public static ParserContext.Key<Function<String, @Nullable Component>> key(String id) {
        return new ParserContext.Key<Function<String, Component>>("dynamic:" + id, null);
    }

    @Override
    public Component toText(ParserContext context, boolean removeBackslashes) {
        Function<String, Component> x = context.get(this.key);
        if (x != null) {
            Component t = x.apply(this.id);
            if (t != null) {
                return t;
            }
            return Component.literal((String)("[INVALID KEY " + this.key.key() + " | " + this.id + "]")).withStyle(ChatFormatting.ITALIC).withColor(0xFF0000);
        }
        return Component.literal((String)("[MISSING CONTEXT FOR " + this.key.key() + " | " + this.id + "]")).withStyle(ChatFormatting.ITALIC).withColor(0xFF0000);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

