/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.EmptyNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.impl.GeneralUtils;
import java.util.List;
import net.minecraft.network.chat.Component;

public interface TextNode {
    public Component toText(ParserContext var1, boolean var2);

    default public Component toText(ParserContext context) {
        return this.toText(context, true);
    }

    default public Component toText(PlaceholderContext context) {
        return this.toText(context.asParserContext(), true);
    }

    default public Component toText() {
        return this.toText(ParserContext.of(), true);
    }

    default public boolean isDynamic() {
        return false;
    }

    public static TextNode convert(Component input) {
        return GeneralUtils.convertToNodes(input);
    }

    public static TextNode of(String input) {
        return new LiteralNode(input);
    }

    public static TextNode wrap(TextNode ... nodes) {
        return new ParentNode(nodes);
    }

    public static TextNode wrap(List<TextNode> nodes) {
        return new ParentNode(nodes.toArray(GeneralUtils.CASTER));
    }

    public static TextNode asSingle(TextNode ... nodes) {
        return switch (nodes.length) {
            case 0 -> EmptyNode.INSTANCE;
            case 1 -> nodes[0];
            default -> TextNode.wrap(nodes);
        };
    }

    public static TextNode asSingle(List<TextNode> nodes) {
        return switch (nodes.size()) {
            case 0 -> EmptyNode.INSTANCE;
            case 1 -> nodes.get(0);
            default -> TextNode.wrap(nodes);
        };
    }

    public static TextNode[] array(TextNode ... nodes) {
        return nodes;
    }

    public static TextNode empty() {
        return EmptyNode.INSTANCE;
    }
}

