/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.impl.GeneralUtils;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ParentNode
implements ParentTextNode {
    public static final ParentNode EMPTY = new ParentNode(new TextNode[0]);
    protected final TextNode[] children;

    public ParentNode(TextNode ... children) {
        this.children = children;
    }

    public ParentNode(Collection<TextNode> children) {
        this(children.toArray(GeneralUtils.CASTER));
    }

    @Override
    public final TextNode[] getChildren() {
        return this.children;
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new ParentNode(children);
    }

    @Override
    public final Component toText(ParserContext context, boolean removeBackslashes) {
        boolean compact;
        boolean bl = compact = context != null && context.get(ParserContext.Key.COMPACT_TEXT) != Boolean.FALSE;
        if (this.children.length == 0) {
            return Component.empty();
        }
        if (this.children.length == 1 && this.children[0] != null && compact) {
            Component out = this.children[0].toText(context, true);
            if (GeneralUtils.isEmpty(out)) {
                return out;
            }
            return (MutableComponent)this.applyFormatting(out.copy(), context);
        }
        MutableComponent base = compact ? null : Component.empty();
        for (int i = 0; i < this.children.length; ++i) {
            Component child;
            if (this.children[i] == null || GeneralUtils.isEmpty(child = this.children[i].toText(context, true))) continue;
            if (base == null) {
                if (child.getStyle().isEmpty()) {
                    base = child.copy();
                    continue;
                }
                base = Component.empty();
                base.append(child);
                continue;
            }
            base.append(child);
        }
        if (base == null || GeneralUtils.isEmpty((Component)base)) {
            return Component.empty();
        }
        return this.applyFormatting(base, context);
    }

    protected Component applyFormatting(MutableComponent out, ParserContext context) {
        return out.setStyle(this.applyFormatting(out.getStyle(), context));
    }

    protected Style applyFormatting(Style style, ParserContext context) {
        return style;
    }

    public String toString() {
        return "ParentNode{children=" + Arrays.toString(this.children) + "}";
    }
}

