/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers;

import com.mojang.brigadier.StringReader;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.ClickActionNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class MarkdownLiteParserV1
implements NodeParser {
    public static NodeParser ALL = new MarkdownLiteParserV1(MarkdownFormat.values());
    private final EnumSet<MarkdownFormat> allowedFormatting = EnumSet.noneOf(MarkdownFormat.class);
    private final Function<TextNode[], TextNode> spoilerFormatting;
    private final Function<TextNode[], TextNode> backtickFormatting;
    private final BiFunction<TextNode[], TextNode, TextNode> urlFormatting;

    public MarkdownLiteParserV1(MarkdownFormat ... formatting) {
        this(MarkdownLiteParserV1::defaultSpoilerFormatting, MarkdownLiteParserV1::defaultQuoteFormatting, formatting);
    }

    public MarkdownLiteParserV1(Function<TextNode[], TextNode> spoilerFormatting, Function<TextNode[], TextNode> quoteFormatting, MarkdownFormat ... formatting) {
        this(spoilerFormatting, quoteFormatting, MarkdownLiteParserV1::defaultUrlFormatting, formatting);
    }

    public MarkdownLiteParserV1(Function<TextNode[], TextNode> spoilerFormatting, Function<TextNode[], TextNode> quoteFormatting, BiFunction<TextNode[], TextNode, TextNode> urlFormatting, MarkdownFormat ... formatting) {
        for (MarkdownFormat form : formatting) {
            this.allowedFormatting.add(form);
        }
        this.spoilerFormatting = spoilerFormatting;
        this.backtickFormatting = quoteFormatting;
        this.urlFormatting = urlFormatting;
    }

    public static TextNode defaultSpoilerFormatting(TextNode[] textNodes) {
        return new HoverNode<TextNode, Component>(TextNode.array(new FormattingNode(TextNode.array(TextNode.of("["), TranslatedNode.of("options.hidden", new Object[0]), TextNode.of("]")), ChatFormatting.GRAY, ChatFormatting.ITALIC)), HoverNode.Action.TEXT, TextNode.asSingle(textNodes));
    }

    public static TextNode defaultQuoteFormatting(TextNode[] textNodes) {
        return new FormattingNode(textNodes, ChatFormatting.GRAY, ChatFormatting.ITALIC);
    }

    public static TextNode defaultUrlFormatting(TextNode[] textNodes, TextNode url) {
        return new ClickActionNode(TextNode.array(new FormattingNode(textNodes, ChatFormatting.BLUE, ChatFormatting.UNDERLINE)), ClickEvent.Action.OPEN_URL, url);
    }

    @Override
    public TextNode[] parseNodes(TextNode input) {
        if (input instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)input;
            ArrayList list = new ArrayList();
            this.parseLiteral(literalNode, list::add);
            return this.parseSubNodes(list.listIterator(), null, -1, false);
        }
        if (input instanceof TranslatedNode) {
            TranslatedNode translatedNode = (TranslatedNode)input;
            return new TextNode[]{translatedNode.transform(this)};
        }
        if (input instanceof ParentTextNode) {
            ParentTextNode parentTextNode = (ParentTextNode)input;
            ArrayList<SubNode<TextNode>> list = new ArrayList<SubNode<TextNode>>();
            for (TextNode children : parentTextNode.getChildren()) {
                if (children instanceof LiteralNode) {
                    LiteralNode literalNode = (LiteralNode)children;
                    this.parseLiteral(literalNode, list::add);
                    continue;
                }
                list.add(new SubNode<TextNode>(SubNodeType.TEXT_NODE, TextNode.asSingle(this.parseNodes(children))));
            }
            return new TextNode[]{parentTextNode.copyWith(this.parseSubNodes(list.listIterator(), null, -1, false), (NodeParser)this)};
        }
        return new TextNode[]{input};
    }

    private void parseLiteral(LiteralNode literalNode, Consumer<SubNode<?>> consumer) {
        StringReader reader = new StringReader(literalNode.value());
        StringBuilder builder = new StringBuilder();
        while (reader.canRead()) {
            char i = reader.read();
            if (i == '\\' && reader.canRead()) {
                char next = reader.read();
                builder.append(i);
                builder.append(next);
                continue;
            }
            SubNodeType<String> type = null;
            if (reader.canRead()) {
                char i2 = reader.read();
                if (i2 == i) {
                    switch (i) {
                        case '~': {
                            SubNodeType<String> subNodeType = SubNodeType.DOUBLE_WAVY_LINE;
                            break;
                        }
                        case '|': {
                            SubNodeType<String> subNodeType = SubNodeType.SPOILER_LINE;
                            break;
                        }
                        default: {
                            SubNodeType<String> subNodeType = type = null;
                        }
                    }
                }
                if (type == null) {
                    reader.setCursor(reader.getCursor() - 1);
                }
            }
            if (type == null) {
                switch (i) {
                    case '`': {
                        SubNodeType<String> subNodeType = SubNodeType.BACK_TICK;
                        break;
                    }
                    case '*': {
                        SubNodeType<String> subNodeType = SubNodeType.STAR;
                        break;
                    }
                    case '_': {
                        SubNodeType<String> subNodeType = SubNodeType.FLOOR;
                        break;
                    }
                    case '(': {
                        SubNodeType<String> subNodeType = SubNodeType.BRACKET_OPEN;
                        break;
                    }
                    case ')': {
                        SubNodeType<String> subNodeType = SubNodeType.BRACKET_CLOSE;
                        break;
                    }
                    case '[': {
                        SubNodeType<String> subNodeType = SubNodeType.SQR_BRACKET_OPEN;
                        break;
                    }
                    case ']': {
                        SubNodeType<String> subNodeType = SubNodeType.SQR_BRACKET_CLOSE;
                        break;
                    }
                    default: {
                        SubNodeType<String> subNodeType = type = null;
                    }
                }
            }
            if (type != null) {
                if (!builder.isEmpty()) {
                    consumer.accept(new SubNode<String>(SubNodeType.STRING, builder.toString()));
                    builder = new StringBuilder();
                }
                consumer.accept(new SubNode<String>(type, (String)type.selfValue));
                continue;
            }
            builder.append(i);
        }
        if (!builder.isEmpty()) {
            consumer.accept(new SubNode<String>(SubNodeType.STRING, builder.toString()));
        }
    }

    private TextNode[] parseSubNodes(ListIterator<SubNode<?>> nodes, @Nullable SubNodeType endAt, int count, boolean requireEmpty) {
        ArrayList<TextNode> out = new ArrayList<TextNode>();
        int startIndex = nodes.nextIndex();
        StringBuilder builder = new StringBuilder();
        while (nodes.hasNext()) {
            SubNode<?> next = nodes.next();
            if (next.type == endAt) {
                boolean endingOrSpace;
                int foundCount = 1;
                if (requireEmpty && nodes.hasNext()) {
                    SubNode<?> prev = nodes.next();
                    endingOrSpace = prev.type != SubNodeType.STRING || ((String)prev.value).startsWith(" ");
                    nodes.previous();
                } else {
                    endingOrSpace = true;
                }
                if (foundCount == count && endingOrSpace) {
                    if (!builder.isEmpty()) {
                        out.add(new LiteralNode(builder.toString()));
                    }
                    return out.toArray(TextParserImpl.CASTER);
                }
                int xStart = nodes.nextIndex();
                while (nodes.hasNext() && nodes.next().type == endAt) {
                    if (++foundCount != count) continue;
                    if (requireEmpty && nodes.hasNext()) {
                        SubNode<?> prev = nodes.next();
                        nodes.previous();
                        if (prev.type == SubNodeType.STRING && !((String)prev.value).startsWith(" ")) break;
                    }
                    if (!builder.isEmpty()) {
                        out.add(new LiteralNode(builder.toString()));
                    }
                    return out.toArray(TextParserImpl.CASTER);
                }
                while (xStart != nodes.nextIndex()) {
                    nodes.previous();
                }
            }
            if (next.type == SubNodeType.TEXT_NODE) {
                if (!builder.isEmpty()) {
                    out.add(new LiteralNode(builder.toString()));
                    builder = new StringBuilder();
                }
                out.add((TextNode)next.value);
                continue;
            }
            if (next.type == SubNodeType.STRING) {
                builder.append((String)next.value);
                continue;
            }
            if (next.type == SubNodeType.BACK_TICK && this.allowedFormatting.contains((Object)MarkdownFormat.QUOTE)) {
                TextNode[] value = this.parseSubNodes(nodes, next.type, 1, false);
                if (value != null) {
                    if (!builder.isEmpty()) {
                        out.add(new LiteralNode(builder.toString()));
                        builder = new StringBuilder();
                    }
                    out.add(this.backtickFormatting.apply(value));
                    continue;
                }
            } else if (next.type == SubNodeType.SPOILER_LINE && this.allowedFormatting.contains((Object)MarkdownFormat.SPOILER)) {
                TextNode[] value = this.parseSubNodes(nodes, next.type, 1, false);
                if (value != null) {
                    if (!builder.isEmpty()) {
                        out.add(new LiteralNode(builder.toString()));
                        builder = new StringBuilder();
                    }
                    out.add(this.spoilerFormatting.apply(value));
                    continue;
                }
            } else if (next.type == SubNodeType.DOUBLE_WAVY_LINE && this.allowedFormatting.contains((Object)MarkdownFormat.STRIKETHROUGH)) {
                TextNode[] value = this.parseSubNodes(nodes, next.type, 1, false);
                if (value != null) {
                    if (!builder.isEmpty()) {
                        out.add(new LiteralNode(builder.toString()));
                        builder = new StringBuilder();
                    }
                    out.add(new FormattingNode(value, ChatFormatting.STRIKETHROUGH));
                    continue;
                }
            } else if (next.type == SubNodeType.STAR || next.type == SubNodeType.FLOOR) {
                boolean two = false;
                if (nodes.hasNext() && (next.type == SubNodeType.STAR && this.allowedFormatting.contains((Object)MarkdownFormat.BOLD) || next.type == SubNodeType.FLOOR && this.allowedFormatting.contains((Object)MarkdownFormat.UNDERLINE))) {
                    SubNode<?> nexter = nodes.next();
                    if (nexter.type == next.type) {
                        two = true;
                        int i = nodes.nextIndex();
                        TextNode[] value = this.parseSubNodes(nodes, next.type, 2, false);
                        if (value != null) {
                            if (!builder.isEmpty()) {
                                out.add(new LiteralNode(builder.toString()));
                                builder = new StringBuilder();
                            }
                            out.add(new FormattingNode(value, next.type == SubNodeType.STAR ? ChatFormatting.BOLD : ChatFormatting.UNDERLINE));
                            continue;
                        }
                    }
                    nodes.previous();
                }
                if (!two && this.allowedFormatting.contains((Object)MarkdownFormat.ITALIC)) {
                    TextNode[] value;
                    boolean startingOrSpace;
                    if (nodes.hasPrevious()) {
                        SubNode<?> prev = nodes.previous();
                        startingOrSpace = prev.type != SubNodeType.STRING || ((String)prev.value).endsWith(" ");
                        nodes.next();
                    } else {
                        startingOrSpace = true;
                    }
                    if (startingOrSpace && (value = this.parseSubNodes(nodes, next.type, 1, next.type == SubNodeType.FLOOR)) != null) {
                        if (!builder.isEmpty()) {
                            out.add(new LiteralNode(builder.toString()));
                            builder = new StringBuilder();
                        }
                        out.add(new FormattingNode(value, ChatFormatting.ITALIC));
                        continue;
                    }
                }
            } else if (next.type == SubNodeType.SQR_BRACKET_OPEN && this.allowedFormatting.contains((Object)MarkdownFormat.URL) && nodes.hasNext()) {
                int start = nodes.nextIndex();
                TextNode[] value = this.parseSubNodes(nodes, SubNodeType.SQR_BRACKET_CLOSE, 1, false);
                if (value != null && nodes.hasNext()) {
                    TextNode[] url;
                    boolean check;
                    boolean bl = check = nodes.next().type == SubNodeType.BRACKET_OPEN;
                    if (check && (url = this.parseSubNodes(nodes, SubNodeType.BRACKET_CLOSE, 1, false)) != null) {
                        if (!builder.isEmpty()) {
                            out.add(new LiteralNode(builder.toString()));
                            builder = new StringBuilder();
                        }
                        out.add(this.urlFormatting.apply(value, TextNode.asSingle(url)));
                        continue;
                    }
                }
                while (start != nodes.nextIndex()) {
                    nodes.previous();
                }
            }
            builder.append((String)next.value);
        }
        if (endAt == null) {
            if (!builder.isEmpty()) {
                out.add(new LiteralNode(builder.toString()));
            }
            return out.toArray(TextParserImpl.CASTER);
        }
        while (startIndex != nodes.nextIndex()) {
            nodes.previous();
        }
        return null;
    }

    public static enum MarkdownFormat {
        BOLD,
        ITALIC,
        UNDERLINE,
        STRIKETHROUGH,
        QUOTE,
        SPOILER,
        URL;

    }

    private record SubNodeType<T>(T selfValue) {
        public static final SubNodeType<TextNode> TEXT_NODE = new SubNodeType<Object>(null);
        public static final SubNodeType<String> STRING = new SubNodeType<Object>(null);
        public static final SubNodeType<String> STAR = new SubNodeType<String>("*");
        public static final SubNodeType<String> FLOOR = new SubNodeType<String>("_");
        public static final SubNodeType<String> DOUBLE_WAVY_LINE = new SubNodeType<String>("~~");
        public static final SubNodeType<String> BACK_TICK = new SubNodeType<String>("`");
        public static final SubNodeType<String> SPOILER_LINE = new SubNodeType<String>("||");
        public static final SubNodeType<String> BRACKET_OPEN = new SubNodeType<String>("(");
        public static final SubNodeType<String> BRACKET_CLOSE = new SubNodeType<String>(")");
        public static final SubNodeType<String> SQR_BRACKET_OPEN = new SubNodeType<String>("[");
        public static final SubNodeType<String> SQR_BRACKET_CLOSE = new SubNodeType<String>("]");
    }

    private record SubNode<T>(SubNodeType<T> type, T value) {
    }
}

