/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl;

import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.node.parent.StyledNode;
import java.util.ArrayList;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class GeneralUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Text Placeholder API");
    public static final boolean IS_DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final TextNode[] CASTER = new TextNode[0];

    public static String durationToString(long x) {
        long seconds = x % 60L;
        long minutes = x / 60L % 60L;
        long hours = x / 3600L % 24L;
        long days = x / 86400L;
        if (days > 0L) {
            return String.format("%dd%dh%dm%ds", days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%dh%dm%ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%dm%ds", minutes, seconds);
        }
        if (seconds > 0L) {
            return String.format("%ds", seconds);
        }
        return "---";
    }

    public static boolean isEmpty(Component text) {
        PlainTextContents.LiteralContents l;
        ComponentContents componentContents;
        return (text.getContents() == PlainTextContents.EMPTY || (componentContents = text.getContents()) instanceof PlainTextContents.LiteralContents && (l = (PlainTextContents.LiteralContents)componentContents).text().isEmpty()) && text.getSiblings().isEmpty();
    }

    public static MutableComponent toGradient(Component base, GradientNode.GradientProvider posToColor) {
        return GeneralUtils.recursiveGradient(base, posToColor, 0, GeneralUtils.getGradientLength(base)).text();
    }

    private static int getGradientLength(Component base) {
        int n;
        ComponentContents componentContents = base.getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents l = (PlainTextContents.LiteralContents)componentContents;
            n = l.text().length();
        } else {
            n = base.getContents() == PlainTextContents.EMPTY ? 0 : 1;
        }
        int length = n;
        for (Component text : base.getSiblings()) {
            length += GeneralUtils.getGradientLength(text);
        }
        return length;
    }

    private static TextLengthPair recursiveGradient(Component base, GradientNode.GradientProvider posToColor, int pos, int totalLength) {
        if (base.getStyle().getColor() == null) {
            MutableComponent out = Component.empty().setStyle(base.getStyle());
            ComponentContents componentContents = base.getContents();
            if (componentContents instanceof PlainTextContents.LiteralContents) {
                PlainTextContents.LiteralContents literalTextContent = (PlainTextContents.LiteralContents)componentContents;
                int l = literalTextContent.text().length();
                for (int i = 0; i < l; ++i) {
                    char next;
                    int character = literalTextContent.text().charAt(i);
                    int value = Character.isHighSurrogate((char)character) && i + 1 < l ? (Character.isLowSurrogate(next = literalTextContent.text().charAt(++i)) ? Character.toCodePoint((char)character, next) : character) : character;
                    out.append((Component)Component.literal((String)Character.toString(value)).setStyle(Style.EMPTY.withColor(posToColor.getColorAt(pos++, totalLength))));
                }
            } else {
                out.append((Component)base.plainCopy().setStyle(Style.EMPTY.withColor(posToColor.getColorAt(pos++, totalLength))));
            }
            for (Component sibling : base.getSiblings()) {
                TextLengthPair pair = GeneralUtils.recursiveGradient(sibling, posToColor, pos, totalLength);
                pos = pair.length;
                out.append((Component)pair.text);
            }
            return new TextLengthPair(out, pos);
        }
        return new TextLengthPair(base.copy(), pos + base.getString().length());
    }

    public static int rgbToInt(float r, float g, float b) {
        return ((int)(r * 255.0f) & 0xFF) << 16 | ((int)(g * 255.0f) & 0xFF) << 8 | (int)(b * 255.0f) & 0xFF;
    }

    public static Component deepTransform(Component input) {
        MutableComponent output = GeneralUtils.cloneText(input);
        GeneralUtils.removeHoverAndClick(output);
        return output;
    }

    public static Component removeHoverAndClick(Component input) {
        MutableComponent output = GeneralUtils.cloneText(input);
        GeneralUtils.removeHoverAndClick(output);
        return output;
    }

    private static void removeHoverAndClick(MutableComponent input) {
        ComponentContents componentContents;
        if (input.getStyle() != null) {
            input.setStyle(input.getStyle().withHoverEvent(null).withClickEvent(null));
        }
        if ((componentContents = input.getContents()) instanceof TranslatableContents) {
            TranslatableContents text = (TranslatableContents)componentContents;
            for (int i = 0; i < text.getArgs().length; ++i) {
                Object arg = text.getArgs()[i];
                if (!(arg instanceof MutableComponent)) continue;
                MutableComponent argText = (MutableComponent)arg;
                GeneralUtils.removeHoverAndClick(argText);
            }
        }
        for (Component sibling : input.getSiblings()) {
            GeneralUtils.removeHoverAndClick((MutableComponent)sibling);
        }
    }

    public static MutableComponent cloneText(Component input) {
        MutableComponent baseText;
        ComponentContents componentContents = input.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            ArrayList<Object> obj = new ArrayList<Object>();
            for (Object arg : translatable.getArgs()) {
                if (arg instanceof Component) {
                    Component argText = (Component)arg;
                    obj.add(GeneralUtils.cloneText(argText));
                    continue;
                }
                obj.add(arg);
            }
            baseText = Component.translatable((String)translatable.getKey(), (Object[])obj.toArray());
        } else {
            baseText = input.plainCopy();
        }
        for (Component sibling : input.getSiblings()) {
            baseText.append((Component)GeneralUtils.cloneText(sibling));
        }
        baseText.setStyle(input.getStyle());
        return baseText;
    }

    public static MutableComponent cloneTransformText(Component input, Function<MutableComponent, MutableComponent> transform) {
        MutableComponent baseText;
        ComponentContents componentContents = input.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            ArrayList<Object> obj = new ArrayList<Object>();
            for (Object arg : translatable.getArgs()) {
                if (arg instanceof Component) {
                    Component argText = (Component)arg;
                    obj.add(GeneralUtils.cloneTransformText(argText, transform));
                    continue;
                }
                obj.add(arg);
            }
            baseText = Component.translatable((String)translatable.getKey(), (Object[])obj.toArray());
        } else {
            baseText = input.plainCopy();
        }
        for (Component sibling : input.getSiblings()) {
            baseText.append((Component)GeneralUtils.cloneTransformText(sibling, transform));
        }
        baseText.setStyle(input.getStyle());
        return transform.apply(baseText);
    }

    public static Component getItemText(ItemStack stack, boolean rarity) {
        if (!stack.isEmpty()) {
            MutableComponent mutableText = Component.empty().append(stack.getHoverName());
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                mutableText.withStyle(ChatFormatting.ITALIC);
            }
            if (rarity) {
                mutableText.withStyle(stack.getRarity().color());
            }
            mutableText.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack))));
            return mutableText;
        }
        return Component.empty().append(ItemStack.EMPTY.getHoverName());
    }

    public static ParentNode convertToNodes(Component input) {
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        ComponentContents componentContents = input.getContents();
        if (componentContents instanceof PlainTextContents.LiteralContents) {
            PlainTextContents.LiteralContents content = (PlainTextContents.LiteralContents)componentContents;
            list.add(new LiteralNode(content.text()));
        } else {
            componentContents = input.getContents();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents content = (TranslatableContents)componentContents;
                ArrayList<Object> args = new ArrayList<Object>();
                for (Object arg : content.getArgs()) {
                    if (arg instanceof Component) {
                        Component text = (Component)arg;
                        args.add(GeneralUtils.convertToNodes(text));
                        continue;
                    }
                    if (arg instanceof String) {
                        String s = (String)arg;
                        args.add(new LiteralNode(s));
                        continue;
                    }
                    args.add(arg);
                }
                list.add(TranslatedNode.ofFallback(content.getKey(), content.getFallback(), args.toArray()));
            } else {
                componentContents = input.getContents();
                if (componentContents instanceof ScoreContents) {
                    ScoreContents content = (ScoreContents)componentContents;
                    list.add(new ScoreNode(content.getName(), content.getObjective()));
                } else {
                    componentContents = input.getContents();
                    if (componentContents instanceof KeybindContents) {
                        KeybindContents content = (KeybindContents)componentContents;
                        list.add(new KeybindNode(content.getName()));
                    } else {
                        componentContents = input.getContents();
                        if (componentContents instanceof SelectorContents) {
                            SelectorContents content = (SelectorContents)componentContents;
                            list.add(new SelectorNode(content.getPattern(), content.getSeparator().map(GeneralUtils::convertToNodes)));
                        } else {
                            componentContents = input.getContents();
                            if (componentContents instanceof NbtContents) {
                                NbtContents content = (NbtContents)componentContents;
                                list.add(new NbtNode(content.getNbtPath(), content.isInterpreting(), content.getSeparator().map(GeneralUtils::convertToNodes), content.getDataSource()));
                            }
                        }
                    }
                }
            }
        }
        for (Component child : input.getSiblings()) {
            list.add(GeneralUtils.convertToNodes(child));
        }
        if (input.getStyle() == Style.EMPTY) {
            return new ParentNode(list);
        }
        Style style = input.getStyle();
        ParentNode hoverValue = style.getHoverEvent() != null && style.getHoverEvent().getAction() == HoverEvent.Action.SHOW_TEXT ? GeneralUtils.convertToNodes((Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT)) : null;
        LiteralNode clickValue = style.getClickEvent() != null ? new LiteralNode(style.getClickEvent().getValue()) : null;
        LiteralNode insertion = style.getInsertion() != null ? new LiteralNode(style.getInsertion()) : null;
        return new StyledNode(list.toArray(new TextNode[0]), style, hoverValue, (TextNode)clickValue, (TextNode)insertion);
    }

    public static TextNode removeColors(TextNode node) {
        if (node instanceof ParentTextNode) {
            ParentTextNode parentNode = (ParentTextNode)node;
            ArrayList<TextNode> list = new ArrayList<TextNode>();
            for (TextNode child : parentNode.getChildren()) {
                list.add(GeneralUtils.removeColors(child));
            }
            if (node instanceof ColorNode || node instanceof FormattingNode) {
                return new ParentNode(list.toArray(new TextNode[0]));
            }
            if (node instanceof StyledNode) {
                StyledNode styledNode = (StyledNode)node;
                return new StyledNode(list.toArray(new TextNode[0]), styledNode.rawStyle().withColor((TextColor)null), styledNode.hoverValue(), styledNode.clickValue(), styledNode.insertion());
            }
            return parentNode.copyWith(list.toArray(new TextNode[0]));
        }
        return node;
    }

    public record TextLengthPair(MutableComponent text, int length) {
        public static final TextLengthPair EMPTY = new TextLengthPair(null, 0);
    }

    public record MutableTransformer(Function<Style, Style> textMutableTextFunction) implements Function<MutableComponent, Component>
    {
        public static final MutableTransformer CLEAR = new MutableTransformer(x -> Style.EMPTY);

        @Override
        public Component apply(MutableComponent text) {
            return GeneralUtils.cloneTransformText((Component)text, this::transformStyle);
        }

        private MutableComponent transformStyle(MutableComponent mutableText) {
            return mutableText.setStyle(this.textMutableTextFunction.apply(mutableText.getStyle()));
        }
    }

    public record Pair<L, R>(L left, R right) {
    }
}

