/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.color;

import eu.pb4.placeholders.impl.GeneralUtils;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public record OkLab(float l, float a, float b) {
    public static OkLab fromRgb(int rgb) {
        return OkLab.fromLinearSRGB((float)FastColor.ARGB32.red((int)rgb) / 255.0f, (float)FastColor.ARGB32.green((int)rgb) / 255.0f, (float)FastColor.ARGB32.blue((int)rgb) / 255.0f);
    }

    static float f(float x) {
        if ((double)x >= 0.0031308) {
            return (float)(1.055 * Math.pow(x, 0.4166666666666667) - 0.055);
        }
        return (float)(12.92 * (double)x);
    }

    static float f_inv(float x) {
        if ((double)x >= 0.04045) {
            return (float)Math.pow(((double)x + 0.055) / 1.055, 2.4);
        }
        return x / 12.92f;
    }

    private static OkLab fromLinearSRGB(float r, float g, float b) {
        float l = 0.41222146f * r + 0.53633255f * g + 0.051445995f * b;
        float m = 0.2119035f * r + 0.6806995f * g + 0.10739696f * b;
        float s = 0.08830246f * r + 0.28171885f * g + 0.6299787f * b;
        float l_ = (float)Math.cbrt(l);
        float m_ = (float)Math.cbrt(m);
        float s_ = (float)Math.cbrt(s);
        return new OkLab(0.21045426f * l_ + 0.7936178f * m_ - 0.004072047f * s_, 1.9779985f * l_ - 2.4285922f * m_ + 0.4505937f * s_, 0.025904037f * l_ + 0.78277177f * m_ - 0.80867577f * s_);
    }

    public int toRgb() {
        return OkLab.toRgb(this.l, this.a, this.b);
    }

    public static int toRgb(float cL, float ca, float cb) {
        float l_ = cL + 0.39633778f * ca + 0.21580376f * cb;
        float m_ = cL - 0.105561346f * ca - 0.06385417f * cb;
        float s_ = cL - 0.08948418f * ca - 1.2914855f * cb;
        float l = l_ * l_ * l_;
        float m = m_ * m_ * m_;
        float s = s_ * s_ * s_;
        float r = 4.0767417f * l - 3.3077116f * m + 0.23096994f * s;
        float g = -1.268438f * l + 2.6097574f * m - 0.34131938f * s;
        float b = -0.0041960864f * l - 0.7034186f * m + 1.7076147f * s;
        float max = Math.max(Math.max(Math.max(r, g), b), 1.0f);
        float min = Math.min(Math.min(Math.min(r, g), b), 0.0f);
        float mult = 1.0f;
        if (max > 1.0f || min < 0.0f) {
            // empty if block
        }
        return GeneralUtils.rgbToInt(Mth.clamp((float)(r * mult), (float)0.0f, (float)1.0f), Mth.clamp((float)(g * mult), (float)0.0f, (float)1.0f), Mth.clamp((float)(b * mult), (float)0.0f, (float)1.0f));
    }
}

