/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.placeholder.builtin;

import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.impl.GeneralUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class PlayerPlaceholders {
    public static void register() {
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"name"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(ctx.player().getName());
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)ctx.gameProfile().getName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"name_visual"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(GeneralUtils.removeHoverAndClick(ctx.player().getName()));
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)ctx.gameProfile().getName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"name_unformatted"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(ctx.player().getName().getString());
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)ctx.gameProfile().getName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"ping"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(String.valueOf(ctx.player().connection.latency()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"ping_colored"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                int x = ctx.player().connection.latency();
                return PlaceholderResult.value((Component)Component.literal((String)String.valueOf(x)).withStyle(x < 100 ? ChatFormatting.GREEN : (x < 200 ? ChatFormatting.GOLD : ChatFormatting.RED)));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"displayname"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(ctx.player().getDisplayName());
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)ctx.gameProfile().getName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"display_name"), (PlaceholderHandler)Placeholders.getPlaceholders().get((Object)ResourceLocation.fromNamespaceAndPath((String)"player", (String)"displayname")));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"displayname_visual"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(GeneralUtils.removeHoverAndClick(ctx.player().getDisplayName()));
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)ctx.gameProfile().getName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"display_name_visual"), (PlaceholderHandler)Placeholders.getPlaceholders().get((Object)ResourceLocation.fromNamespaceAndPath((String)"player", (String)"displayname_visual")));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"displayname_unformatted"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value((Component)Component.literal((String)ctx.player().getDisplayName().getString()));
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)ctx.gameProfile().getName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"display_name_unformatted"), (PlaceholderHandler)Placeholders.getPlaceholders().get((Object)ResourceLocation.fromNamespaceAndPath((String)"player", (String)"displayname_unformatted")));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"inventory_slot"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    int slot = Integer.parseInt(arg);
                    Inventory inventory = ctx.player().getInventory();
                    if (slot >= 0 && slot < inventory.getContainerSize()) {
                        ItemStack stack = inventory.getItem(slot);
                        return PlaceholderResult.value(GeneralUtils.getItemText(stack, true));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return PlaceholderResult.invalid("Invalid argument");
            }
            return PlaceholderResult.invalid("No player or invalid argument!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"inventory_slot_no_rarity"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    int slot = Integer.parseInt(arg);
                    Inventory inventory = ctx.player().getInventory();
                    if (slot >= 0 && slot < inventory.getContainerSize()) {
                        ItemStack stack = inventory.getItem(slot);
                        return PlaceholderResult.value(GeneralUtils.getItemText(stack, false));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return PlaceholderResult.invalid("Invalid argument");
            }
            return PlaceholderResult.invalid("No player or invalid argument!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"equipment_slot"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    EquipmentSlot slot = EquipmentSlot.byName((String)arg);
                    ItemStack stack = ctx.player().getItemBySlot(slot);
                    return PlaceholderResult.value(GeneralUtils.getItemText(stack, true));
                }
                catch (Exception exception) {
                    return PlaceholderResult.invalid("Invalid argument");
                }
            }
            return PlaceholderResult.invalid("No player or invalid argument!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"equipment_slot_no_rarity"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    EquipmentSlot slot = EquipmentSlot.byName((String)arg);
                    ItemStack stack = ctx.player().getItemBySlot(slot);
                    return PlaceholderResult.value(GeneralUtils.getItemText(stack, false));
                }
                catch (Exception exception) {
                    return PlaceholderResult.invalid("Invalid argument");
                }
            }
            return PlaceholderResult.invalid("No player or invalid argument!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"playtime"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                int x = ctx.player().getStats().getValue(Stats.CUSTOM.get((Object)Stats.PLAY_TIME));
                return PlaceholderResult.value(arg != null ? DurationFormatUtils.formatDuration((long)((long)x * 50L), (String)arg, (boolean)true) : GeneralUtils.durationToString((long)x / 20L));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"statistic"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    String[] args = arg.split(" ");
                    if (args.length == 1) {
                        ResourceLocation identifier = ResourceLocation.tryParse((String)args[0]);
                        if (identifier != null) {
                            Stat stat = Stats.CUSTOM.get((Object)((ResourceLocation)BuiltInRegistries.CUSTOM_STAT.get(identifier)));
                            int x = ctx.player().getStats().getValue(stat);
                            return PlaceholderResult.value(stat.format(x));
                        }
                    } else if (args.length >= 2) {
                        Object key;
                        StatType statType;
                        ResourceLocation type = ResourceLocation.tryParse((String)args[0]);
                        ResourceLocation id = ResourceLocation.tryParse((String)args[1]);
                        if (type != null && (statType = (StatType)BuiltInRegistries.STAT_TYPE.get(type)) != null && (key = statType.getRegistry().get(id)) != null) {
                            Stat stat = statType.get(key);
                            int x = ctx.player().getStats().getValue(stat);
                            return PlaceholderResult.value(stat.format(x));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return PlaceholderResult.invalid("Invalid statistic!");
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"statistic_raw"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    String[] args = arg.split(" ");
                    if (args.length == 1) {
                        ResourceLocation identifier = ResourceLocation.tryParse((String)args[0]);
                        if (identifier != null) {
                            Stat stat = Stats.CUSTOM.get((Object)((ResourceLocation)BuiltInRegistries.CUSTOM_STAT.get(identifier)));
                            int x = ctx.player().getStats().getValue(stat);
                            return PlaceholderResult.value(String.valueOf(x));
                        }
                    } else if (args.length >= 2) {
                        Object key;
                        StatType statType;
                        ResourceLocation type = ResourceLocation.tryParse((String)args[0]);
                        ResourceLocation id = ResourceLocation.tryParse((String)args[1]);
                        if (type != null && (statType = (StatType)BuiltInRegistries.STAT_TYPE.get(type)) != null && (key = statType.getRegistry().get(id)) != null) {
                            Stat stat = statType.get(key);
                            int x = ctx.player().getStats().getValue(stat);
                            return PlaceholderResult.value(String.valueOf(x));
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return PlaceholderResult.invalid("Invalid statistic!");
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"objective"), (ctx, arg) -> {
            if (ctx.hasPlayer() && arg != null) {
                try {
                    ServerScoreboard scoreboard = ctx.server().getScoreboard();
                    Objective scoreboardObjective = scoreboard.getObjective(arg);
                    if (scoreboardObjective == null) {
                        return PlaceholderResult.invalid("Invalid objective!");
                    }
                    ReadOnlyScoreInfo score = scoreboard.getPlayerScoreInfo((ScoreHolder)ctx.player(), scoreboardObjective);
                    return PlaceholderResult.value(String.valueOf(score.value()));
                }
                catch (Exception exception) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"pos_x"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                double value = ctx.player().getX();
                Object format = "%.2f";
                if (arg != null) {
                    try {
                        int x = Integer.parseInt(arg);
                        format = "%." + x + "f";
                    }
                    catch (Exception e) {
                        format = "%.2f";
                    }
                }
                return PlaceholderResult.value(String.format((String)format, value));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"pos_y"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                double value = ctx.player().getY();
                Object format = "%.2f";
                if (arg != null) {
                    try {
                        int x = Integer.parseInt(arg);
                        format = "%." + x + "f";
                    }
                    catch (Exception e) {
                        format = "%.2f";
                    }
                }
                return PlaceholderResult.value(String.format((String)format, value));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"pos_z"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                double value = ctx.player().getZ();
                Object format = "%.2f";
                if (arg != null) {
                    try {
                        int x = Integer.parseInt(arg);
                        format = "%." + x + "f";
                    }
                    catch (Exception e) {
                        format = "%.2f";
                    }
                }
                return PlaceholderResult.value(String.format((String)format, value));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"uuid"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(ctx.player().getStringUUID());
            }
            if (ctx.hasGameProfile()) {
                return PlaceholderResult.value(Component.nullToEmpty((String)String.valueOf(ctx.gameProfile().getId())));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"health"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(String.format("%.0f", Float.valueOf(ctx.player().getHealth())));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"max_health"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(String.format("%.0f", Float.valueOf(ctx.player().getMaxHealth())));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"hunger"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(String.valueOf(ctx.player().getFoodData().getFoodLevel()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"saturation"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                return PlaceholderResult.value(String.format("%.0f", Float.valueOf(ctx.player().getFoodData().getSaturationLevel())));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"team_name"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                PlayerTeam team = ctx.player().getTeam();
                return PlaceholderResult.value((Component)(team == null ? Component.empty() : Component.nullToEmpty((String)team.getName())));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"team_displayname"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                PlayerTeam team = ctx.player().getTeam();
                return PlaceholderResult.value((Component)(team == null ? Component.empty() : team.getDisplayName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"player", (String)"team_displayname_formatted"), (ctx, arg) -> {
            if (ctx.hasPlayer()) {
                PlayerTeam team = ctx.player().getTeam();
                return PlaceholderResult.value((Component)(team == null ? Component.empty() : team.getFormattedDisplayName()));
            }
            return PlaceholderResult.invalid("No player!");
        });
    }
}

