/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.placeholder.builtin;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.arguments.StringArgs;
import eu.pb4.placeholders.impl.GeneralUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerScoreEntry;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ServerPlaceholders {
    public static void register() {
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"tps"), (ctx, arg) -> {
            double tps = (float)TimeUnit.SECONDS.toMillis(1L) / Math.max(ctx.server().getCurrentSmoothedTickTime(), ctx.server().tickRateManager().millisecondsPerTick());
            Object format = "%.1f";
            if (arg != null) {
                try {
                    int x = Integer.parseInt(arg);
                    format = "%." + x + "f";
                }
                catch (Exception e) {
                    format = "%.1f";
                }
            }
            return PlaceholderResult.value(String.format((String)format, tps));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"tps_colored"), (ctx, arg) -> {
            double tps = (float)TimeUnit.SECONDS.toMillis(1L) / Math.max(ctx.server().getCurrentSmoothedTickTime(), ctx.server().tickRateManager().millisecondsPerTick());
            Object format = "%.1f";
            if (arg != null) {
                try {
                    int x = Integer.parseInt(arg);
                    format = "%." + x + "f";
                }
                catch (Exception e) {
                    format = "%.1f";
                }
            }
            return PlaceholderResult.value((Component)Component.literal((String)String.format((String)format, tps)).withStyle(tps > 19.0 ? ChatFormatting.GREEN : (tps > 16.0 ? ChatFormatting.GOLD : ChatFormatting.RED)));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"mspt"), (ctx, arg) -> PlaceholderResult.value(String.format("%.0f", Float.valueOf(ctx.server().getCurrentSmoothedTickTime()))));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"mspt_colored"), (ctx, arg) -> {
            float x = ctx.server().getCurrentSmoothedTickTime();
            return PlaceholderResult.value((Component)Component.literal((String)String.format("%.0f", Float.valueOf(x))).withStyle(x < 45.0f ? ChatFormatting.GREEN : (x < 51.0f ? ChatFormatting.GOLD : ChatFormatting.RED)));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"time"), (ctx, arg) -> {
            SimpleDateFormat format = new SimpleDateFormat(arg != null ? arg : "HH:mm:ss");
            return PlaceholderResult.value(format.format(new Date(System.currentTimeMillis())));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"time_new"), (ctx, arg) -> {
            StringArgs args = arg == null ? StringArgs.empty() : StringArgs.full(arg, ' ', ':');
            DateTimeFormatter format = DateTimeFormatter.ofPattern(args.get("format", "HH:mm:ss"));
            LocalDateTime date = args.get("zone") != null ? LocalDateTime.now(ZoneId.of(args.get("zone", ""))) : LocalDateTime.now();
            return PlaceholderResult.value(format.format(date));
        });
        Object ref = new Object(){
            WeakReference<MinecraftServer> server;
            long ms;
        };
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"uptime"), (arg_0, arg_1) -> ServerPlaceholders.lambda$register$6(ref, arg_0, arg_1));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"version"), (ctx, arg) -> PlaceholderResult.value(ctx.server().getServerVersion()));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"motd"), (ctx, arg) -> {
            ServerStatus metadata = ctx.server().getStatus();
            if (metadata == null) {
                return PlaceholderResult.invalid("Server metadata missing!");
            }
            return PlaceholderResult.value(metadata.description());
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"mod_version"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((Component)Component.literal((String)((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"mod_name"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((Component)Component.literal((String)((ModContainer)container.get()).getMetadata().getName()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"brand"), (ctx, arg) -> PlaceholderResult.value((Component)Component.literal((String)ctx.server().getServerModName())));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"mod_count"), (ctx, arg) -> PlaceholderResult.value((Component)Component.literal((String)("" + FabricLoader.getInstance().getAllMods().size()))));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"mod_description"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((Component)Component.literal((String)((ModContainer)container.get()).getMetadata().getDescription()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"name"), (ctx, arg) -> PlaceholderResult.value(ctx.server().name()));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"used_ram"), (ctx, arg) -> {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            return PlaceholderResult.value(Objects.equals(arg, "gb") ? String.format("%.1f", Float.valueOf((float)heapUsage.getUsed() / 1.0737418E9f)) : String.format("%d", heapUsage.getUsed() / 0x100000L));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"max_ram"), (ctx, arg) -> {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            return PlaceholderResult.value(Objects.equals(arg, "gb") ? String.format("%.1f", Float.valueOf((float)heapUsage.getMax() / 1.0737418E9f)) : String.format("%d", heapUsage.getMax() / 0x100000L));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"online"), (ctx, arg) -> PlaceholderResult.value(String.valueOf(ctx.server().getPlayerList().getPlayerCount())));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"max_players"), (ctx, arg) -> PlaceholderResult.value(String.valueOf(ctx.server().getPlayerList().getMaxPlayers())));
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"objective_name_top"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                ServerScoreboard scoreboard = ctx.server().getScoreboard();
                Objective scoreboardObjective = scoreboard.getObjective(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    Collection scoreboardEntries = scoreboard.listPlayerScores(scoreboardObjective);
                    PlayerScoreEntry scoreboardEntry = ((PlayerScoreEntry[])scoreboardEntries.toArray(PlayerScoreEntry[]::new))[scoreboardEntries.size() - position];
                    return PlaceholderResult.value(scoreboardEntry.ownerName());
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid("Invalid position!");
                }
            }
            return PlaceholderResult.invalid("Not enough arguments!");
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"server", (String)"objective_score_top"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                ServerScoreboard scoreboard = ctx.server().getScoreboard();
                Objective scoreboardObjective = scoreboard.getObjective(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    Collection scoreboardEntries = scoreboard.listPlayerScores(scoreboardObjective);
                    PlayerScoreEntry scoreboardEntry = ((PlayerScoreEntry[])scoreboardEntries.toArray(PlayerScoreEntry[]::new))[scoreboardEntries.size() - position];
                    return PlaceholderResult.value(String.valueOf(scoreboardEntry.value()));
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid("Invalid position!");
                }
            }
            return PlaceholderResult.invalid("Not enough arguments!");
        });
    }

    private static /* synthetic */ PlaceholderResult lambda$register$6(1 ref, PlaceholderContext ctx, String arg) {
        if (ref.server == null || !ref.server.refersTo(ctx.server())) {
            ref.server = new WeakReference<MinecraftServer>(ctx.server());
            ref.ms = System.currentTimeMillis() - (long)ctx.server().getTickCount() * 50L;
        }
        return PlaceholderResult.value(arg != null ? DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - ref.ms), (String)arg, (boolean)true) : GeneralUtils.durationToString((System.currentTimeMillis() - ref.ms) / 1000L));
    }
}

