/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.placeholder.builtin;

import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.NaturalSpawner;

public class WorldPlaceholders {
    static final int CHUNK_AREA = (int)Math.pow(17.0, 2.0);

    public static void register() {
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"time"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            long dayTime = (long)((double)world.getDayTime() * 3.6 / 60.0);
            return PlaceholderResult.value(String.format("%02d:%02d", (dayTime / 60L + 6L) % 24L, dayTime % 60L));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"time_alt"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            long dayTime = (long)((double)world.getDayTime() * 3.6 / 60.0);
            long x = (dayTime / 60L + 6L) % 24L;
            long y = x % 12L;
            if (y == 0L) {
                y = 12L;
            }
            return PlaceholderResult.value(String.format("%02d:%02d %s", y, dayTime % 60L, x > 11L ? "PM" : "AM"));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"day"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            return PlaceholderResult.value("" + world.getDayTime() / 24000L);
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"id"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            return PlaceholderResult.value(world.dimension().location().toString());
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"name"), (ctx, arg) -> {
            String[] words;
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            ArrayList<String> parts = new ArrayList<String>();
            for (String word : words = world.dimension().location().getPath().split("_")) {
                CharSequence[] s = word.split("", 2);
                s[0] = s[0].toUpperCase(Locale.ROOT);
                parts.add(String.join((CharSequence)"", s));
            }
            return PlaceholderResult.value(String.join((CharSequence)" ", parts));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"player_count"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            return PlaceholderResult.value("" + world.players().size());
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"mob_count_colored"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            NaturalSpawner.SpawnState info = world.getChunkSource().getLastSpawnState();
            MobCategory spawnGroup = null;
            if (arg != null) {
                spawnGroup = MobCategory.valueOf((String)arg.toUpperCase(Locale.ROOT));
            }
            if (spawnGroup != null) {
                int count = info.getMobCategoryCounts().getInt((Object)spawnGroup);
                int cap = spawnGroup.getMaxInstancesPerChunk() * info.getSpawnableChunkCount() / CHUNK_AREA;
                return PlaceholderResult.value((Component)(count > 0 ? Component.literal((String)("" + count)).withStyle(count > cap ? ChatFormatting.LIGHT_PURPLE : ((double)count > 0.8 * (double)cap ? ChatFormatting.RED : ((double)count > 0.5 * (double)cap ? ChatFormatting.GOLD : ChatFormatting.GREEN))) : Component.literal((String)"-").withStyle(ChatFormatting.GRAY)));
            }
            int cap = 0;
            for (MobCategory group : MobCategory.values()) {
                cap += group.getMaxInstancesPerChunk();
            }
            cap = cap * info.getSpawnableChunkCount() / CHUNK_AREA;
            int count = 0;
            IntIterator intIterator = info.getMobCategoryCounts().values().iterator();
            while (intIterator.hasNext()) {
                int value = (Integer)intIterator.next();
                count += value;
            }
            return PlaceholderResult.value((Component)(count > 0 ? Component.literal((String)("" + count)).withStyle(count > cap ? ChatFormatting.LIGHT_PURPLE : ((double)count > 0.8 * (double)cap ? ChatFormatting.RED : ((double)count > 0.5 * (double)cap ? ChatFormatting.GOLD : ChatFormatting.GREEN))) : Component.literal((String)"-").withStyle(ChatFormatting.GRAY)));
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"mob_count"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            NaturalSpawner.SpawnState info = world.getChunkSource().getLastSpawnState();
            MobCategory spawnGroup = null;
            if (arg != null) {
                spawnGroup = MobCategory.valueOf((String)arg.toUpperCase(Locale.ROOT));
            }
            if (spawnGroup != null) {
                return PlaceholderResult.value("" + info.getMobCategoryCounts().getInt((Object)spawnGroup));
            }
            int x = 0;
            IntIterator intIterator = info.getMobCategoryCounts().values().iterator();
            while (intIterator.hasNext()) {
                int value = (Integer)intIterator.next();
                x += value;
            }
            return PlaceholderResult.value("" + x);
        });
        Placeholders.register(ResourceLocation.fromNamespaceAndPath((String)"world", (String)"mob_cap"), (ctx, arg) -> {
            ServerLevel world = ctx.player() != null ? ctx.player().serverLevel() : ctx.server().overworld();
            NaturalSpawner.SpawnState info = world.getChunkSource().getLastSpawnState();
            MobCategory spawnGroup = null;
            if (arg != null) {
                spawnGroup = MobCategory.valueOf((String)arg.toUpperCase(Locale.ROOT));
            }
            if (spawnGroup != null) {
                return PlaceholderResult.value("" + spawnGroup.getMaxInstancesPerChunk() * info.getSpawnableChunkCount() / CHUNK_AREA);
            }
            int x = 0;
            for (MobCategory group : MobCategory.values()) {
                x += group.getMaxInstancesPerChunk();
            }
            return PlaceholderResult.value("" + x * info.getSpawnableChunkCount() / CHUNK_AREA);
        });
    }
}

