/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.placeholders.api.arguments.SimpleArguments;
import eu.pb4.placeholders.api.arguments.StringArgs;
import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.BoldNode;
import eu.pb4.placeholders.api.node.parent.ClickActionNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.FontNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import eu.pb4.placeholders.api.node.parent.InsertNode;
import eu.pb4.placeholders.api.node.parent.ItalicNode;
import eu.pb4.placeholders.api.node.parent.ObfuscatedNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.StrikethroughNode;
import eu.pb4.placeholders.api.node.parent.StyledNode;
import eu.pb4.placeholders.api.node.parent.TransformNode;
import eu.pb4.placeholders.api.node.parent.UnderlinedNode;
import eu.pb4.placeholders.api.parsers.tag.NodeCreator;
import eu.pb4.placeholders.api.parsers.tag.SimpleTags;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.placeholders.impl.StringArgOps;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BuiltinTags {
    public static final TextColor DEFAULT_COLOR = TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.WHITE);

    public static void register() {
        HashMap<ChatFormatting, List<String>> aliases = new HashMap<ChatFormatting, List<String>>();
        aliases.put(ChatFormatting.GOLD, List.of("orange"));
        aliases.put(ChatFormatting.GRAY, List.of("grey", "light_gray", "light_grey"));
        aliases.put(ChatFormatting.LIGHT_PURPLE, List.of("pink"));
        aliases.put(ChatFormatting.DARK_PURPLE, List.of("purple"));
        aliases.put(ChatFormatting.DARK_GRAY, List.of("dark_grey"));
        for (ChatFormatting formatting : ChatFormatting.values()) {
            if (formatting.isFormat()) continue;
            TagRegistry.registerDefault(SimpleTags.color(formatting.getName(), aliases.containsKey(formatting) ? (Collection)aliases.get(formatting) : List.of(), formatting));
        }
        TagRegistry.registerDefault(TextTag.enclosing("bold", List.of("b"), "formatting", true, NodeCreator.bool(BoldNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("underline", List.of("underlined", "u"), "formatting", true, NodeCreator.bool(UnderlinedNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("strikethrough", List.of("st"), "formatting", true, NodeCreator.bool(StrikethroughNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("obfuscated", List.of("obf", "matrix"), "formatting", true, NodeCreator.bool(ObfuscatedNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("italic", List.of("i", "em"), "formatting", true, NodeCreator.bool(ItalicNode::new)));
        TagRegistry.registerDefault(TextTag.enclosing("color", List.of("colour", "c"), "color", true, (nodes, data, parser) -> new ColorNode(nodes, TextColor.parseColor((String)data.get("value", 0, "white")).result().orElse(DEFAULT_COLOR))));
        TagRegistry.registerDefault(TextTag.enclosing("font", "other_formatting", false, (nodes, data, parser) -> new FontNode(nodes, ResourceLocation.tryParse((String)data.get("value", 0, "")))));
        TagRegistry.registerDefault(TextTag.self("lang", List.of("translate"), "special", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                String part;
                String key = data.getNext("key");
                String fallback = data.get("fallback");
                ArrayList<TextNode> textList = new ArrayList<TextNode>();
                int i = 0;
                while ((part = data.getNext("" + i++)) != null) {
                    textList.add(parser.parseNode(part));
                }
                return TranslatedNode.ofFallback(key, fallback, textList.toArray(TextParserImpl.CASTER));
            }
            return TextNode.empty();
        }));
        TagRegistry.registerDefault(TextTag.self("lang_fallback", List.of("translatef", "langf", "translate_fallback"), "special", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                String part;
                String key = data.getNext("key");
                String fallback = data.getNext("fallback");
                ArrayList<TextNode> textList = new ArrayList<TextNode>();
                int i = 0;
                while ((part = data.getNext("" + i++)) != null) {
                    textList.add(parser.parseNode(part));
                }
                return TranslatedNode.ofFallback(key, fallback, textList.toArray(TextParserImpl.CASTER));
            }
            return TextNode.empty();
        }));
        TagRegistry.registerDefault(TextTag.self("keybind", List.of("key"), "special", false, data -> new KeybindNode(data.getNext("value", ""))));
        TagRegistry.registerDefault(TextTag.enclosing("click", "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                for (ClickEvent.Action action : ClickEvent.Action.values()) {
                    if (!action.getSerializedName().equals(data.getNext("type"))) continue;
                    return new ClickActionNode(nodes, action, (TextNode)new LiteralNode(data.getNext("value", "")));
                }
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("run_command", List.of("run_cmd"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, ClickEvent.Action.RUN_COMMAND, (TextNode)new LiteralNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("suggest_command", List.of("cmd"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, ClickEvent.Action.SUGGEST_COMMAND, (TextNode)new LiteralNode(data.getNext("value", "")));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("open_url", List.of("url"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, ClickEvent.Action.OPEN_URL, (TextNode)new LiteralNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("copy_to_clipboard", List.of("copy"), "click_action", false, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, ClickEvent.Action.COPY_TO_CLIPBOARD, (TextNode)new LiteralNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("change_page", List.of("page"), "click_action", true, (nodes, data, parser) -> {
            if (!data.isEmpty()) {
                return new ClickActionNode(nodes, ClickEvent.Action.CHANGE_PAGE, (TextNode)new LiteralNode(data.get("value", 0)));
            }
            return new ParentNode(nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("hover", "hover_event", true, (nodes, data, parser) -> {
            try {
                String type = data.getNext("type", "").toLowerCase(Locale.ROOT);
                if (data.size() > 1) {
                    if (type.equals("show_text") || type.equals("text")) {
                        return new HoverNode<TextNode, Component>(nodes, HoverNode.Action.TEXT, parser.parseNode(data.getNext("value", "")));
                    }
                    if (type.equals("show_entity") || type.equals("entity")) {
                        return new HoverNode<HoverNode.EntityNodeContent, HoverEvent.EntityTooltipInfo>(nodes, HoverNode.Action.ENTITY, new HoverNode.EntityNodeContent(EntityType.byString((String)data.getNext("entity", "")).orElse(EntityType.PIG), UUID.fromString(data.getNext("uuid", Util.NIL_UUID.toString())), new ParentNode(parser.parseNode(data.get("name", 3, "")))));
                    }
                    if (type.equals("show_item") || type.equals("item")) {
                        String value = data.getNext("value", "");
                        try {
                            return new HoverNode<HoverEvent.ItemStackInfo, HoverEvent.ItemStackInfo>(nodes, HoverNode.Action.ITEM_STACK, new HoverEvent.ItemStackInfo(ItemStack.parseOptional((HolderLookup.Provider)RegistryAccess.EMPTY, (CompoundTag)TagParser.parseTag((String)value))));
                        }
                        catch (Throwable e) {
                            ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)data.get("item", value)))).getDefaultInstance();
                            String count = data.getNext("count");
                            if (count != null) {
                                stack.setCount(Integer.parseInt(count));
                            }
                            return new HoverNode<HoverEvent.ItemStackInfo, HoverEvent.ItemStackInfo>(nodes, HoverNode.Action.ITEM_STACK, new HoverEvent.ItemStackInfo(stack));
                        }
                    }
                    return new HoverNode<TextNode, Component>(nodes, HoverNode.Action.TEXT, parser.parseNode(data.get("value", type)));
                }
                return new HoverNode<TextNode, Component>(nodes, HoverNode.Action.TEXT, parser.parseNode(data.get("value", type)));
            }
            catch (Exception exception) {
                return new ParentNode(nodes);
            }
        }));
        TagRegistry.registerDefault(TextTag.enclosing("insert", List.of("insertion"), "click_action", false, (nodes, data, parser) -> new InsertNode(nodes, (TextNode)new LiteralNode(data.get("value", 0)))));
        TagRegistry.registerDefault(TextTag.enclosing("clear_color", List.of("uncolor", "colorless"), "special", false, (nodes, data, parser) -> GeneralUtils.removeColors(TextNode.asSingle(nodes))));
        TagRegistry.registerDefault(TextTag.enclosing("rainbow", List.of("rb"), "gradient", true, (nodes, data, parser) -> {
            String type = data.get("type", "");
            float freq = SimpleArguments.floatNumber(data.getNext("frequency", data.get("freq", data.get("f"))), 1.0f);
            float saturation = SimpleArguments.floatNumber(data.getNext("saturation", data.get("sat", data.get("s"))), 1.0f);
            float offset = SimpleArguments.floatNumber(data.getNext("offset", data.get("off", data.get("o"))), 0.0f);
            int overriddenLength = SimpleArguments.intNumber(data.getNext("length", data.get("len", data.get("l"))), -1);
            int value = SimpleArguments.intNumber(data.get("value", data.get("val", data.get("v"))), 1);
            return new GradientNode(nodes, switch (type) {
                case "oklab", "okhcl" -> {
                    if (overriddenLength < 0) {
                        yield GradientNode.GradientProvider.rainbowOkLch(saturation, value, freq, offset);
                    }
                    yield GradientNode.GradientProvider.rainbowOkLch(saturation, value, freq, offset, overriddenLength);
                }
                case "hvs" -> {
                    if (overriddenLength < 0) {
                        yield GradientNode.GradientProvider.rainbowHvs(saturation, value, freq, offset);
                    }
                    yield GradientNode.GradientProvider.rainbowHvs(saturation, value, freq, offset, overriddenLength);
                }
                default -> overriddenLength < 0 ? GradientNode.GradientProvider.rainbow(saturation, value, freq, offset) : GradientNode.GradientProvider.rainbow(saturation, value, freq, offset, overriddenLength);
            });
        }));
        TagRegistry.registerDefault(TextTag.enclosing("gradient", List.of("gr"), "gradient", true, (nodes, data, parser) -> {
            String part;
            ArrayList<TextColor> textColors = new ArrayList<TextColor>();
            int i = 0;
            String type = data.get("type", "");
            while ((part = data.getNext("" + i)) != null) {
                TextColor.parseColor((String)part).result().ifPresent(textColors::add);
            }
            return new GradientNode(nodes, switch (type) {
                case "oklab" -> GradientNode.GradientProvider.colorsOkLab(textColors);
                case "hvs" -> GradientNode.GradientProvider.colorsHvs(textColors);
                case "hard" -> GradientNode.GradientProvider.colorsHard(textColors);
                default -> GradientNode.GradientProvider.colors(textColors);
            });
        }));
        TagRegistry.registerDefault(TextTag.enclosing("hard_gradient", List.of("hgr"), "gradient", true, (nodes, data, parser) -> {
            String part;
            ArrayList<TextColor> textColors = new ArrayList<TextColor>();
            int i = 0;
            while ((part = data.getNext("" + i)) != null) {
                TextColor.parseColor((String)part).result().ifPresent(textColors::add);
            }
            if (textColors.isEmpty()) {
                return new ParentNode(nodes);
            }
            return GradientNode.colorsHard(textColors, nodes);
        }));
        TagRegistry.registerDefault(TextTag.enclosing("clear", "special", false, (nodes, data, parser) -> new TransformNode(nodes, BuiltinTags.getTransform(data))));
        TagRegistry.registerDefault(TextTag.enclosing("rawstyle", "special", false, (nodes, data, parser) -> {
            DataResult x = Style.Serializer.CODEC.decode((DynamicOps)StringArgOps.INSTANCE, (Object)Either.right((Object)data));
            if (x.error().isPresent()) {
                System.out.println(((DataResult.Error)x.error().get()).message());
                return TextNode.asSingle(nodes);
            }
            return new StyledNode(nodes, (Style)((Pair)x.result().get()).getFirst(), null, null, null);
        }));
        TagRegistry.registerDefault(TextTag.self("score", "special", false, (nodes, data, parser) -> new ScoreNode(data.getNext("name", ""), data.getNext("objective", ""))));
        TagRegistry.registerDefault(TextTag.self("selector", "special", false, (nodes, data, parser) -> {
            String sel = data.getNext("pattern", "@p");
            String arg = data.getNext("separator");
            return new SelectorNode(sel, arg != null ? Optional.of(TextNode.of(arg)) : Optional.empty());
        }));
        TagRegistry.registerDefault(TextTag.self("nbt", "special", false, (nodes, data, parser) -> {
            BlockDataSource type;
            String source = data.getNext("source", "");
            String cleanLine1 = data.getNext("path", "");
            switch (source) {
                case "block": {
                    BlockDataSource blockDataSource = new BlockDataSource(cleanLine1);
                    break;
                }
                case "entity": {
                    BlockDataSource blockDataSource = new EntityDataSource(cleanLine1);
                    break;
                }
                case "storage": {
                    BlockDataSource blockDataSource = new StorageDataSource(ResourceLocation.tryParse((String)cleanLine1));
                    break;
                }
                default: {
                    BlockDataSource blockDataSource = type = null;
                }
            }
            if (type == null) {
                return TextNode.empty();
            }
            String separ = data.getNext("separator");
            Optional<TextNode> separator = separ != null ? Optional.of(TextNode.asSingle(parser.parseNode(separ))) : Optional.empty();
            boolean shouldInterpret = SimpleArguments.bool(data.getNext("interpret"), false);
            return new NbtNode(cleanLine1, shouldInterpret, separator, (DataSource)type);
        }));
    }

    private static Function<MutableComponent, Component> getTransform(StringArgs val) {
        if (val.isEmpty()) {
            return GeneralUtils.MutableTransformer.CLEAR;
        }
        Function<Style, Style> func = x -> x;
        Iterator<String> iterator = val.ordered().iterator();
        while (iterator.hasNext()) {
            String arg;
            func = func.andThen(switch (arg = iterator.next()) {
                case "hover" -> x -> x.withHoverEvent(null);
                case "click" -> x -> x.withClickEvent(null);
                case "color" -> x -> x.withColor((TextColor)null);
                case "insertion" -> x -> x.withInsertion(null);
                case "font" -> x -> x.withFont(null);
                case "bold" -> x -> x.withBold(null);
                case "italic" -> x -> x.withItalic(null);
                case "underline" -> x -> x.withUnderlined(null);
                case "strikethrough" -> x -> x.withStrikethrough(null);
                case "all" -> x -> Style.EMPTY;
                default -> x -> x;
            });
        }
        return new GeneralUtils.MutableTransformer(func);
    }

    private static boolean isntFalse(String arg) {
        return SimpleArguments.bool(arg, arg.isEmpty());
    }
}

