/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.textparser;

import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.placeholders.api.node.DirectTextNode;
import eu.pb4.placeholders.api.node.KeybindNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.NbtNode;
import eu.pb4.placeholders.api.node.ScoreNode;
import eu.pb4.placeholders.api.node.SelectorNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.BoldNode;
import eu.pb4.placeholders.api.node.parent.ClickActionNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.FontNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.GradientNode;
import eu.pb4.placeholders.api.node.parent.HoverNode;
import eu.pb4.placeholders.api.node.parent.InsertNode;
import eu.pb4.placeholders.api.node.parent.ItalicNode;
import eu.pb4.placeholders.api.node.parent.ObfuscatedNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.node.parent.StrikethroughNode;
import eu.pb4.placeholders.api.node.parent.TransformNode;
import eu.pb4.placeholders.api.node.parent.UnderlinedNode;
import eu.pb4.placeholders.api.parsers.TextParserV1;
import eu.pb4.placeholders.impl.GeneralUtils;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public final class TextTagsV1 {
    public static void register() {
        HashMap<String, List<String>> aliases = new HashMap<String, List<String>>();
        aliases.put("gold", List.of("orange"));
        aliases.put("gray", List.of("grey"));
        aliases.put("light_purple", List.of("pink"));
        aliases.put("dark_gray", List.of("dark_grey"));
        for (ChatFormatting formatting : ChatFormatting.values()) {
            if (formatting.isFormat()) continue;
            TextParserV1.registerDefault(TextParserV1.TextTag.of(formatting.getName(), aliases.containsKey(formatting.getName()) ? (List)aliases.get(formatting.getName()) : List.of(), "color", true, TextTagsV1.wrap((nodes, arg) -> new FormattingNode(nodes, formatting))));
        }
        TextParserV1.registerDefault(TextParserV1.TextTag.of("bold", List.of("b"), "formatting", true, TextTagsV1.bool(BoldNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("underline", List.of("underlined", "u"), "formatting", true, TextTagsV1.bool(UnderlinedNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("strikethrough", List.of("st"), "formatting", true, TextTagsV1.bool(StrikethroughNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("obfuscated", List.of("obf", "matrix"), "formatting", true, TextTagsV1.bool(ObfuscatedNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("italic", List.of("i", "em"), "formatting", true, TextTagsV1.bool(ItalicNode::new)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("color", List.of("colour", "c"), "color", true, TextTagsV1.wrap((nodes, data) -> new ColorNode(nodes, TextColor.parseColor((String)TextParserImpl.cleanArgument(data)).result().orElse(null)))));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("font", "other_formatting", false, TextTagsV1.wrap((nodes, data) -> new FontNode(nodes, ResourceLocation.tryParse((String)TextParserImpl.cleanArgument(data))))));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("lang", List.of("translate"), "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length > 0) {
                ArrayList<ParentNode> textList = new ArrayList<ParentNode>();
                boolean skipped = false;
                for (String part : lines) {
                    if (!skipped) {
                        skipped = true;
                        continue;
                    }
                    textList.add(new ParentNode(TextParserImpl.parse(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(part)), handlers)));
                }
                TranslatedNode out = TranslatedNode.of(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(lines[0])), textList.toArray(TextParserImpl.CASTER));
                return new TextParserV1.TagNodeValue(out, 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("lang_fallback", List.of("translatef", "langf", "translate_fallback"), "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length > 1) {
                ArrayList<ParentNode> textList = new ArrayList<ParentNode>();
                int skipped = 0;
                for (String part : lines) {
                    if (skipped < 2) {
                        ++skipped;
                        continue;
                    }
                    textList.add(new ParentNode(TextParserImpl.parse(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(part)), handlers)));
                }
                TranslatedNode out = TranslatedNode.ofFallback(TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(lines[0])), TextParserImpl.removeEscaping(TextParserImpl.cleanArgument(lines[1])), textList.toArray(TextParserImpl.CASTER));
                return new TextParserV1.TagNodeValue(out, 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("keybind", List.of("key"), "special", false, (tag, data, input, handlers, endAt) -> {
            if (!data.isEmpty()) {
                return new TextParserV1.TagNodeValue(new KeybindNode(TextParserImpl.cleanArgument(data)), 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("click", "click_action", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":", 2);
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (lines.length > 1) {
                for (ClickEvent.Action action : ClickEvent.Action.values()) {
                    if (!action.getSerializedName().equals(TextParserImpl.cleanArgument(lines[0]))) continue;
                    return out.value(new ClickActionNode(out.nodes(), action, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])))));
                }
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("run_command", List.of("run_cmd"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickEvent.Action.RUN_COMMAND, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("suggest_command", List.of("cmd"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickEvent.Action.SUGGEST_COMMAND, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("open_url", List.of("url"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickEvent.Action.OPEN_URL, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("copy_to_clipboard", List.of("copy"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickEvent.Action.COPY_TO_CLIPBOARD, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("change_page", List.of("page"), "click_action", true, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            if (!data.isEmpty()) {
                return out.value(new ClickActionNode(out.nodes(), ClickEvent.Action.CHANGE_PAGE, (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("hover", "hover_event", true, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out;
            block11: {
                String[] lines = data.split(":", 2);
                out = TextParserImpl.recursiveParsing(input, handlers, endAt);
                try {
                    if (lines.length > 1) {
                        HoverEvent.Action action = HoverEvent.Action.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)TextParserImpl.cleanArgument(lines[0].toLowerCase(Locale.ROOT)))).result().orElse(null);
                        if (action == HoverEvent.Action.SHOW_TEXT) {
                            return out.value(new HoverNode<ParentNode, Component>(out.nodes(), HoverNode.Action.TEXT, new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])), handlers))));
                        }
                        if (action == HoverEvent.Action.SHOW_ENTITY) {
                            if ((lines = lines[1].split(":", 3)).length == 3) {
                                return out.value(new HoverNode<HoverNode.EntityNodeContent, HoverEvent.EntityTooltipInfo>(out.nodes(), HoverNode.Action.ENTITY, new HoverNode.EntityNodeContent(EntityType.byString((String)TextParserImpl.restoreOriginalEscaping(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0])))).orElse(EntityType.PIG), UUID.fromString(TextParserImpl.cleanArgument(lines[1])), new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[2]))), handlers)))));
                            }
                            break block11;
                        }
                        if (action == HoverEvent.Action.SHOW_ITEM) {
                            try {
                                return out.value(new HoverNode<HoverEvent.ItemStackInfo, HoverEvent.ItemStackInfo>(out.nodes(), HoverNode.Action.ITEM_STACK, new HoverEvent.ItemStackInfo(ItemStack.parseOptional((HolderLookup.Provider)RegistryAccess.EMPTY, (CompoundTag)TagParser.parseTag((String)TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])))))));
                            }
                            catch (Throwable e) {
                                lines = lines[1].split(":", 2);
                                if (lines.length > 0) {
                                    ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)lines[0]))).getDefaultInstance();
                                    if (lines.length > 1) {
                                        stack.setCount(Integer.parseInt(lines[1]));
                                    }
                                    return out.value(new HoverNode<HoverEvent.ItemStackInfo, HoverEvent.ItemStackInfo>(out.nodes(), HoverNode.Action.ITEM_STACK, new HoverEvent.ItemStackInfo(stack)));
                                }
                                break block11;
                            }
                        }
                        return out.value(new HoverNode<ParentNode, Component>(out.nodes(), HoverNode.Action.TEXT, new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)), handlers))));
                    }
                    return out.value(new HoverNode<ParentNode, Component>(out.nodes(), HoverNode.Action.TEXT, new ParentNode(TextParserImpl.parse(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)), handlers))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return out.value(new ParentNode(out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("insert", List.of("insertion"), "click_action", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(new InsertNode(out.nodes(), (TextNode)new LiteralNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)))));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("clear_color", List.of("uncolor", "colorless"), "special", false, (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(GeneralUtils.removeColors(new ParentNode(out.nodes())));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("rainbow", List.of("rb"), "gradient", true, (tag, data, input, handlers, endAt) -> {
            String[] val = data.split(":");
            float freq = 1.0f;
            float saturation = 1.0f;
            float offset = 0.0f;
            int overriddenLength = -1;
            if (val.length >= 1) {
                try {
                    freq = Float.parseFloat(val[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val.length >= 2) {
                try {
                    saturation = Float.parseFloat(val[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val.length >= 3) {
                try {
                    offset = Float.parseFloat(val[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val.length >= 4) {
                try {
                    overriddenLength = Integer.parseInt(val[3]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(overriddenLength < 0 ? GradientNode.rainbow(saturation, 1.0f, freq, offset, out.nodes()) : GradientNode.rainbow(saturation, 1.0f, freq, offset, overriddenLength, out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("gradient", List.of("gr"), "gradient", true, (tag, data, input, handlers, endAt) -> {
            String[] val = data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            ArrayList<TextColor> textColors = new ArrayList<TextColor>();
            for (String string : val) {
                TextColor.parseColor((String)string).result().ifPresent(textColors::add);
            }
            return out.value(GradientNode.colors(textColors, out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("hard_gradient", List.of("hgr"), "gradient", true, (tag, data, input, handlers, endAt) -> {
            String[] val = data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            ArrayList<TextColor> textColors = new ArrayList<TextColor>();
            for (String string : val) {
                TextColor.parseColor((String)string).result().ifPresent(textColors::add);
            }
            if (textColors.isEmpty()) {
                return out.value(new ParentNode(out.nodes()));
            }
            return out.value(GradientNode.colorsHard(textColors, out.nodes()));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("clear", "special", false, (tag, data, input, handlers, endAt) -> {
            String[] val = data.isEmpty() ? new String[]{} : data.split(":");
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return out.value(new TransformNode(out.nodes(), TextTagsV1.getTransform(val)));
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("raw_style", "special", false, (tag, data, input, handlers, endAt) -> new TextParserV1.TagNodeValue(new DirectTextNode((Component)Component.Serializer.fromJsonLenient((String)TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(data)), (HolderLookup.Provider)RegistryAccess.EMPTY)), 0)));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("score", "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length == 2) {
                return new TextParserV1.TagNodeValue(new ScoreNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0])), TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1]))), 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("selector", "special", false, (tag, data, input, handlers, endAt) -> {
            String[] lines = data.split(":");
            if (lines.length == 2) {
                return new TextParserV1.TagNodeValue(new SelectorNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0])), Optional.of(TextNode.asSingle(TextParserImpl.recursiveParsing(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1])), handlers, null).nodes()))), 0);
            }
            if (lines.length == 1) {
                return new TextParserV1.TagNodeValue(new SelectorNode(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[0])), Optional.empty()), 0);
            }
            return TextParserV1.TagNodeValue.EMPTY;
        }));
        TextParserV1.registerDefault(TextParserV1.TextTag.of("nbt", "special", false, (tag, data, input, handlers, endAt) -> {
            BlockDataSource type;
            String[] lines = data.split(":");
            if (lines.length < 3) {
                return TextParserV1.TagNodeValue.EMPTY;
            }
            String cleanLine1 = TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[1]));
            switch (lines[0]) {
                case "block": {
                    BlockDataSource blockDataSource = new BlockDataSource(cleanLine1);
                    break;
                }
                case "entity": {
                    BlockDataSource blockDataSource = new EntityDataSource(cleanLine1);
                    break;
                }
                case "storage": {
                    BlockDataSource blockDataSource = new StorageDataSource(ResourceLocation.tryParse((String)cleanLine1));
                    break;
                }
                default: {
                    BlockDataSource blockDataSource = type = null;
                }
            }
            if (type == null) {
                return TextParserV1.TagNodeValue.EMPTY;
            }
            Optional<TextNode> separator = lines.length > 3 ? Optional.of(TextNode.asSingle(TextParserImpl.recursiveParsing(TextParserImpl.restoreOriginalEscaping(TextParserImpl.cleanArgument(lines[3])), handlers, null).nodes())) : Optional.empty();
            boolean shouldInterpret = lines.length > 4 && Boolean.parseBoolean(lines[4]);
            return new TextParserV1.TagNodeValue(new NbtNode(lines[2], shouldInterpret, separator, (DataSource)type), 0);
        }));
    }

    private static Function<MutableComponent, Component> getTransform(String[] val) {
        if (val.length == 0) {
            return GeneralUtils.MutableTransformer.CLEAR;
        }
        Function<Style, Style> func = x -> x;
        String[] stringArray = val;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String arg;
            func = func.andThen(switch (arg = stringArray[i]) {
                case "hover" -> x -> x.withHoverEvent(null);
                case "click" -> x -> x.withClickEvent(null);
                case "color" -> x -> x.withColor((TextColor)null);
                case "insertion" -> x -> x.withInsertion(null);
                case "font" -> x -> x.withFont(null);
                case "bold" -> x -> x.withBold(null);
                case "italic" -> x -> x.withItalic(null);
                case "underline" -> x -> x.withUnderlined(null);
                case "strikethrough" -> x -> x.withStrikethrough(null);
                case "all" -> x -> Style.EMPTY;
                default -> x -> x;
            });
        }
        return new GeneralUtils.MutableTransformer(func);
    }

    private static boolean isntFalse(String arg) {
        return arg.isEmpty() || !arg.equals("false");
    }

    private static TextParserV1.TagNodeBuilder wrap(Wrapper wrapper) {
        return (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return new TextParserV1.TagNodeValue(wrapper.wrap(out.nodes(), data), out.length());
        };
    }

    private static TextParserV1.TagNodeBuilder bool(BooleanTag wrapper) {
        return (tag, data, input, handlers, endAt) -> {
            TextParserV1.NodeList out = TextParserImpl.recursiveParsing(input, handlers, endAt);
            return new TextParserV1.TagNodeValue(wrapper.wrap(out.nodes(), TextTagsV1.isntFalse(data)), out.length());
        };
    }

    static interface Wrapper {
        public TextNode wrap(TextNode[] var1, String var2);
    }

    static interface BooleanTag {
        public TextNode wrap(TextNode[] var1, boolean var2);
    }
}

